/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef MAILMIME_TYPES_H

#define MAILMIME_TYPES_H

#include <inttypes.h>
#include "mailimf.h"
#include "clist.h"
/* #include "alloc.h" */

enum {
  MAILMIME_COMPOSITE_TYPE_ERROR,
  MAILMIME_COMPOSITE_TYPE_MESSAGE,
  MAILMIME_COMPOSITE_TYPE_MULTIPART,
  MAILMIME_COMPOSITE_TYPE_EXTENSION
};

struct mailmime_composite_type {
  int type;
  char * token;
};


struct mailmime_content {
  struct mailmime_type * type;
  char * subtype;
  clist * parameters; /* elements are (struct mailmime_parameter *) */
};


enum {
  MAILMIME_DISCRETE_TYPE_ERROR,
  MAILMIME_DISCRETE_TYPE_TEXT,
  MAILMIME_DISCRETE_TYPE_IMAGE,
  MAILMIME_DISCRETE_TYPE_AUDIO,
  MAILMIME_DISCRETE_TYPE_VIDEO,
  MAILMIME_DISCRETE_TYPE_APPLICATION,
  MAILMIME_DISCRETE_TYPE_EXTENSION
};

struct mailmime_discrete_type {
  int type;
  char * extension;
};

enum {
  MAILMIME_FIELD_NONE,
  MAILMIME_FIELD_TYPE,
  MAILMIME_FIELD_TRANSFER_ENCODING,
  MAILMIME_FIELD_ID,
  MAILMIME_FIELD_DESCRIPTION,
  MAILMIME_FIELD_VERSION,
  MAILMIME_FIELD_DISPOSITION,
  MAILMIME_FIELD_LANGUAGE,
};

struct mailmime_field {
  int type;
  struct mailmime_content * content;
  struct mailmime_mechanism * encoding;
  char * id;
  char * description;
  uint32_t version;
  struct mailmime_disposition * disposition;
  struct mailmime_language * language;
};

enum {
  MAILMIME_MECHANISM_ERROR,
  MAILMIME_MECHANISM_7BIT,
  MAILMIME_MECHANISM_8BIT,
  MAILMIME_MECHANISM_BINARY,
  MAILMIME_MECHANISM_QUOTED_PRINTABLE,
  MAILMIME_MECHANISM_BASE64,
  MAILMIME_MECHANISM_TOKEN
};

struct mailmime_mechanism {
  int type;
  char * token;
};


struct mailmime_fields {
  clist * list; /* list of (struct mailmime_field *) */
};


struct mailmime_parameter {
  char * name;
  char * value;
};

enum {
  MAILMIME_TYPE_DISCRETE_TYPE,
  MAILMIME_TYPE_COMPOSITE_TYPE
};

struct mailmime_type {
  int type;
  struct mailmime_discrete_type * discrete_type;
  struct mailmime_composite_type * composite_type;
};

void mailmime_attribute_free(char * attribute);

struct mailmime_composite_type *
mailmime_composite_type_new(int type, char * token);

void mailmime_composite_type_free(struct mailmime_composite_type * ct);

struct mailmime_content *
mailmime_content_new(struct mailmime_type * type,
		     char * subtype,
		     clist * parameters);

void mailmime_content_free(struct mailmime_content * content);

void mailmime_description_free(char * description);

struct mailmime_discrete_type *
mailmime_discrete_type_new(int type, char * extension);

void mailmime_discrete_type_free(struct mailmime_discrete_type *
				 discrete_type);

void mailmime_encoding_free(struct mailmime_mechanism * encoding);

void mailmime_extension_token_free(char * extension);

void mailmime_id_free(char * id);

struct mailmime_mechanism * mailmime_mechanism_new(int type, char * token);

void mailmime_mechanism_free(struct mailmime_mechanism * mechanism);

struct mailmime_parameter *
mailmime_parameter_new(char * name, char * value);

void mailmime_parameter_free(struct mailmime_parameter * parameter);

void mailmime_subtype_free(char * subtype);

void mailmime_token_free(char * token);

struct mailmime_type *
mailmime_type_new(int type,
		  struct mailmime_discrete_type * discrete_type,
		  struct mailmime_composite_type * composite_type);

void mailmime_type_free(struct mailmime_type * type);

void mailmime_value_free(char * value);



struct mailmime_language {
  clist * list; /* atom (char *) */
};

struct mailmime_language * mailmime_language_new(clist * list);

void mailmime_language_free(struct mailmime_language * lang);


/*
void mailmime_x_token_free(gchar * x_token);
*/

struct mailmime_field *
mailmime_field_new(int type,
		   struct mailmime_content * content,
		   struct mailmime_mechanism * encoding,
		   char * id,
		   char * description,
		   uint32_t version,
		   struct mailmime_disposition * disposition,
		   struct mailmime_language * language);

void mailmime_field_free(struct mailmime_field * field);

struct mailmime_fields * mailmime_fields_new(clist * list);

void mailmime_fields_free(struct mailmime_fields * fields);


struct mailmime_multipart_body {
  clist * list;
};

struct mailmime_multipart_body *
mailmime_multipart_body_new(clist * list);

void mailmime_multipart_body_free(struct mailmime_multipart_body * mp_body);


enum {
  MAILMIME_DATA_TEXT,
  MAILMIME_DATA_FILE,
};

struct mailmime_data {
  int type;
  int encoding;
  int encoded;
  char * data;
  size_t length;
  char * filename;
};

struct mailmime_data * mailmime_data_new(int type, int encoding, int encoded,
					 char * data, size_t length,
					 char * filename);

void mailmime_data_free(struct mailmime_data * mime_data);


enum {
  MAILMIME_NONE,
  MAILMIME_SINGLE,
  MAILMIME_MULTIPLE,
  MAILMIME_MESSAGE
};

struct mailmime {
  /* parent information */
  int parent_type;
  struct mailmime * parent;
  clistiter * multipart_pos;

  int type;
  char * mime_start;
  size_t length;

  struct mailimf_fields * fields;

  struct mailmime_fields * mime_fields;
  struct mailmime_content * content_type;

  /* single part */
  struct mailmime_data * body;

  /* multi-part */
  struct mailmime_data * preamble;
  struct mailmime_data * epilogue;
  clist * list;

  /* message */
  struct mailmime * msg_mime;
  /*
    used only when composing message, when we want to attach
    a raw sub-part.
  */
  struct mailmime_data * msg_content;
};

struct mailmime * mailmime_new(int type,
			       char * mime_start,
			       size_t length,
			       struct mailimf_fields * fields,
			       struct mailmime_fields * mime_fields,
			       struct mailmime_content * content_type,
			       struct mailmime_data * body,
			       struct mailmime_data * preamble,
			       struct mailmime_data * epilogue,
			       clist * list,
			       struct mailmime * msg_mime,
			       struct mailmime_data * msg_content);

void mailmime_free(struct mailmime * mime);

struct mailmime_encoded_word {
  char * charset;
  char * text;
};

struct mailmime_encoded_word *
mailmime_encoded_word_new(char * charset, char * text);

void mailmime_encoded_word_free(struct mailmime_encoded_word * ew);

void mailmime_charset_free(char * charset);

void mailmime_encoded_text_free(char * text);


struct mailmime_disposition {
  struct mailmime_disposition_type * dsp_type;
  clist * disposition_parms; /* struct mailmime_disposition_parm */
};


enum {
  MAILMIME_DISPOSITION_TYPE_ERROR,
  MAILMIME_DISPOSITION_TYPE_INLINE,
  MAILMIME_DISPOSITION_TYPE_ATTACHMENT,
  MAILMIME_DISPOSITION_TYPE_EXTENSION
};

struct mailmime_disposition_type {
  int type;
  char * extension;
};


enum {
  MAILMIME_DISPOSITION_PARM_FILENAME,
  MAILMIME_DISPOSITION_PARM_CREATION_DATE,
  MAILMIME_DISPOSITION_PARM_MODIFICATION_DATE,
  MAILMIME_DISPOSITION_PARM_READ_DATE,
  MAILMIME_DISPOSITION_PARM_SIZE,
  MAILMIME_DISPOSITION_PARM_PARAMETER
};

struct mailmime_disposition_parm {
  int type;
  char * filename;
  char * creation_date;
  char * modification_date;
  char * read_date;
  size_t size;
  struct mailmime_parameter * parameter;
};

struct mailmime_disposition *
mailmime_disposition_new(struct mailmime_disposition_type * dsp_type,
			 clist * disposition_parms);

void mailmime_disposition_free(struct mailmime_disposition * dsp);

struct mailmime_disposition_type *
mailmime_disposition_type_new(int type, char * extension);

void mailmime_disposition_type_free(struct mailmime_disposition_type * dsp_type);

struct mailmime_disposition_parm *
mailmime_disposition_parm_new(int type,
			      char * filename,
			      char * creation_date,
			      char * modification_date,
			      char * read_date,
			      size_t size,
			      struct mailmime_parameter * parameter);

void mailmime_disposition_parm_free(struct mailmime_disposition_parm *
				    dsp_parm);

void mailmime_filename_parm_free(char * filename);

void mailmime_creation_date_parm_free(char * date);

void mailmime_modification_date_parm_free(char * date);

void mailmime_read_date_parm_free(char * date);

void mailmime_quoted_date_time_free(char * date);

struct mailmime_section {
  clist * list;
};

struct mailmime_section * mailmime_section_new(clist * list);

void mailmime_section_free(struct mailmime_section * section);



enum {
  MAILMIME_PART_TYPE_NONE,
  MAILMIME_PART_TYPE_TEXT,
  MAILMIME_PART_TYPE_FILE,
};

void mailmime_decoded_part_free(char * part);

#endif

