/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: newsnntp_types.h,v 1.6 2002/06/24 23:53:19 hoa Exp $
 */

#ifndef NEWSNNTP_TYPES_H

#define NEWSNNTP_TYPES_H

#include <inttypes.h>
#include "clist.h"

#include "mailstream.h"
#include "mmapstring.h"

enum {
  NEWSNNTP_NO_ERROR = 0,
  NEWSNNTP_WARNING_REQUEST_AUTHORIZATION_USERNAME,
  NEWSNNTP_WARNING_REQUEST_AUTHORIZATION_PASSWORD,
  NEWSNNTP_ERROR_STREAM,
  NEWSNNTP_ERROR_UNEXPECTED,
  NEWSNNTP_ERROR_NO_NEWSGROUP_SELECTED,
  NEWSNNTP_ERROR_NO_ARTICLE_SELECTED,
  NEWSNNTP_ERROR_INVALID_ARTICLE_NUMBER,
  NEWSNNTP_ERROR_ARTICLE_NOT_FOUND,
  NEWSNNTP_ERROR_UNEXPECTED_RESPONSE,
  NEWSNNTP_ERROR_INVALID_RESPONSE,
  NEWSNNTP_ERROR_NO_SUCH_NEWS_GROUP,
  NEWSNNTP_ERROR_POSTING_NOT_ALLOWED,
  NEWSNNTP_ERROR_POSTING_FAILED,
  NEWSNNTP_ERROR_PROGRAM_ERROR,
  NEWSNNTP_ERROR_NO_PERMISSION,
  NEWSNNTP_ERROR_COMMAND_NOT_UNDERSTOOD,
  NEWSNNTP_ERROR_COMMAND_NOT_SUPPORTED,
  NEWSNNTP_ERROR_CONNECTION_REFUSED,
  NEWSNNTP_ERROR_MEMORY,
  NEWSNNTP_ERROR_AUTHENTICATION_REJECTED,
  NEWSNNTP_ERROR_BAD_STATE,
};

struct newsnntp
{
  mailstream * stream;

  int readonly;

  uint32_t progr_rate;
  progress_function * progr_fun;
  
  MMAPString * stream_buffer;
  MMAPString * response_buffer;

  char * response;
};

typedef struct newsnntp newsnntp;

struct newsnntp_group_info
{
  char * name;
  uint32_t first;
  uint32_t last;
  uint32_t count;
  char type;
};

struct newsnntp_group_time {
  char * name;
  uint32_t date;
  char * email;
};

struct newsnntp_distrib_value_meaning {
  char * value;
  char * meaning;
};

struct newsnntp_distrib_default_value {
  uint32_t weight;
  char * group_pattern;
  char * value;
};

struct newsnntp_group_description {
  char * group_name;
  char * description;
};

struct newsnntp_xhdr_resp_item {
  uint32_t article;
  char * value;
};

struct newsnntp_xover_resp_item {
  uint32_t article;
  char * subject;
  char * author;
  char * date;
  char * message_id;
  char * references;
  size_t size;
  uint32_t line_count;
  clist * others;
};

#endif
