#! /bin/sh
#
# Script for spawning a mail reader through muttzilla.
#

# Arguments to the script:
#   1  to
#   2  cc
#   3  bcc
#   4  subject
#   5  body file
#   6  org

# start with a few useful defaults

debug=0               # uncomment if you wish to see the command line
userconf=".muttzillarc"

mailprog="mutt"
mailargs="mutt"
mailterm="xterm"      # comment out if mailer is X-capable
mailtitle="muttzilla mail"
mailname="muttzilla"

# read out configuration
[ -f /etc/muttzilla.conf ] && . /etc/muttzilla.conf
USERCONF="$HOME/$userconf"
[ -f "$USERCONF" ] && . $USERCONF

# source the appropriate library
. /usr/local/lib/muttzilla/$mailargs


if [ "$mailterm" != "None" ] ; then
    # in a "mailterm" if necessary
    COMMAND="$mailterm"
    [ "$mailname" != "None" ] && COMMAND="$COMMAND -name '$mailname'"
    [ "$mailtitle" != "None" ] && COMMAND="$COMMAND -title '$mailtitle'"
    COMMAND="$COMMAND -e '$mailprog' $ARGS"
else
    # or just by itself if it is already X-capable
    COMMAND="'$mailprog' $ARGS"
fi

# if doing command-line debugging
[ "$debug" != "0" ] && set -xv

eval "$COMMAND"
