#! /usr/bin/python
# -*- python -*-
#
# mznews.py  v1.0
# 
# Copyright (C) 2000 by Brian D. Winters
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#


"""Spawn a news reader from muttzilla.

I am not a very good with shell scripts, but understand python pretty
well, so I use this program instead of the default shell script.  It
does most of the same things as the shell script, but IMO is cleaner
and easier to read and maintain.  When this program departs from the
shell script version it is usually an improvement.
"""



### Configuration options   ###

globalconfig = '/etc/muttzilla.conf'


### Global variables which you can still configure here if you really,
### really want to, but should be handled in a configuration file.

userconfig = '~/.muttzillarc'

debug = 0


# Set some useful defaults.  Settings in userconfig override
# globalconfig override these constants.

xterm = 'xterm'           # set to None if mailer is X-capable
title = 'muttzilla news'  # set to None if you don't want to pass -title
name  = 'muttzilla'       # set to None if you don't want to pass -name

# Choose your preferred news reader and the correct argument style for it.

prog = 'tin'

argstyle = 'tin'
#argstyle = ''

### end configuration section


def errormsg(msg):
    import os.path, sys
    sys.stderr.write('%s: %s\n' % (os.path.basename(sys.argv[0]), msg))

def debugmsg(msg):
    if debug:
        errormsg(msg)


def main():
    import os, sys

    err = readconfig()
    if err:
        sys.exit(err)

    exec 'newsreaderf = %s' % argstyle
   
    args = apply(newsreaderf, sys.argv[1:])

    cmd = [prog,] + args
    if xterm is not None:
        subcmd = [xterm,]
        if name is not None:
            subcmd = subcmd + ['-name', name]
        if title is not None:
            subcmd = subcmd + ['-title', title]
        cmd = subcmd + ['-e',] + cmd

    debugmsg('command line is: %s' % str(cmd))

    os.execvp(cmd[0], cmd)


### parse configuration files ###

def readconfig():
    import os, re

    try:
        inf = open(globalconfig, 'r')
    except:
        pass
    else:
        debugmsg('processing %s' % globalconfig)
        res = parseconfig(inf, globalconfig)
        if res:
            return res

    infname = os.path.expandvars(os.path.expanduser(userconfig))
    if re.compile(os.sep).search(infname) is None and \
       (not os.altsep or re.compile(os.altsep).search(infname) is None):
        try:
            infname = os.environ['HOME'] + os.sep + infname
        except:
            pass
    try:
        inf = open(infname, 'r')
    except:
        pass
    else:
        debugmsg('processing %s' % infname)
        res = parseconfig(inf, infname)
        if res:
            return res

    return 0

def parseconfig(inf, fname):
    import shlex, string

    # format is parmname: (isvar, action)
    # elif isvar is 0:
    #    action is a variable to set
    # if isvar is 1:
    #    action is a function to call with one argument
    # else:
    #    ignore it
    lang = {'tempdir':   (2, None),
            'debug':     (0, 'debug'),
            'reread':    (2, None),
            'userconfig':(0, 'userconfig'),
            'mailscript':(2, None),
            'mailprog':  (2, None),
            'mailargs':  (2, None),
            'mailterm':  (2, None),
            'mailtitle': (2, None),
            'mailname':  (2, None),
            'mailenv':   (2, None),
            'newsscript':(2, None),
            'newsprog':  (0, 'prog'),
            'newsargs':  (0, 'argstyle'),
            'newsterm':  (0, 'xterm'),
            'newstitle': (0, 'title'),
            'newsname':  (0, 'name'),
            'newsenv':   (1, 'setenv')}

    cf = shlex.shlex(inf)
    cf.wordchars = cf.wordchars + r'/.\`~!@#%$%^&*()<>'

    langkeys = lang.keys()
    token = cf.get_token()
    while token != '':
        if token not in langkeys:
            errormsg('parse error in %s at line %u, unrecognized command "%s"'%
                     (fname, cf.lineno, token))
            return 1
        cmd = token
        token = cf.get_token()
        if token != '=':
            errormsg('parse error in %s at line %u, expected "=" but got "%s"'%
                     (fname, cf.lineno, token))
            return 1
        token = cf.get_token()
        if token == '':
            errormsg('parse error in %s at line %u, unexpected end of file '
                     'while processing %s' %
                     (fname, cf.lineno, cmd))
            return 1
        arg = token        

        ll = lang[cmd]
        if ll[0] == 0:
            setval(ll[1], arg)
        elif ll[0] == 1:
            eval('%s(%s)' % (ll[1], arg))
            debugmsg('calling %s(%s)' % (ll[1], arg))
        
        token = cf.get_token()

    return 0

def setval(var, val):
    if val == 'None':
        exec 'global %s\n%s = None' % (var, var)
        debugmsg('setting %s to None' % var)
    else:
        try:
            num = string.atoi(val)
        except:
            exec 'global %s\n%s = val' % (var, var)
            debugmsg('setting %s to "%s"' % (var, eval(var)))
        else:
            exec 'global %s\n%s = num' % (var, var)
            debugmsg('setting %s to %i' % (var, eval(var)))

def setenv(line):
    import os, re

    mo = re.compile(r'\s*(?P<var>\w+)\s*=\s*(P?<val>.*\S)\s*').match(line)

    if mo is not None:
        var = mo.group('var')
        val = mo.group('val')
        if val[0] == "'" and val[len(val)-1] == "'" or \
           val[0] == '"' and val[len(val)-1] == '"':
            val = val[1:-1]
        os.environ[var] = val
        debugmsg('setting environ "%s"="%s"' % (var, val))




### handle the differing argument styles of various mailers ###

def tin(host, group):
    args = []

    normalargs = ((host, '-g'),
                  (group, None))

    for i in normalargs:
        v, a = i
        if len(v) > 0:
            if a is not None:
                args.append(a)
            args.append(v)

    return args


if __name__ == '__main__':
    main()
