#! /bin/sh
#
# Script for spawning a news reader through muttzilla.
#

# Arguments to the script:
#   1  server
#   2  group

# start with a few useful defaults

debug=0               # uncomment if you wish to see the command line
userconf=".muttzillarc"

mailprog="tin"
mailargs="tin"
mailterm="xterm"      # comment out if mailer is X-capable
mailtitle="muttzilla news"
mailname="muttzilla"

# read out configuration
[ -f /etc/muttzilla.conf ] && . /etc/muttzilla.conf
USERCONF="$HOME/$userconf"
[ -f "$USERCONF" ] && . $USERCONF

# source the appropriate library
. /usr/local/lib/muttzilla/$newsargs


if [ "$newsterm" != "None" ] ; then
    # in a "newsterm" if necessary
    COMMAND="$newsterm"
    [ "$newsname" != "None" ] && COMMAND="$COMMAND -name '$newsname'"
    [ "$newstitle" != "None" ] && COMMAND="$COMMAND -title '$newstitle'"
    COMMAND="$COMMAND -e '$mailprog' $ARGS"
else
    # or just by itself if it is already X-capable
    COMMAND="'$mailprog' $ARGS"
fi

# if doing command-line debugging
[ "$debug" != "0" ] && set -xv

eval "$COMMAND"
