#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

import os, user, pickle
from paths import *

__config_rc_file_name = 'config'
__config_dir_name='.pmail'

config_dir = os.path.join(user.home, __config_dir_name)
config_rc_path = os.path.join(config_dir, __config_rc_file_name)

config = {}

def get_file(name):
  pdir = os.path.join(datadir, name)
  if os.path.exists(pdir):
    return pdir
  else:
    return name

def getCDict(dict, name):
  classd = dict.get(name)
  if not classd:
    classd = {}
    dict[name] = classd
  return classd

def getWindowParam(window, name, defa=None):
  return getParam('windows', window.name(), name, defa)

def setWindowParam(window, name, val):
  setParam('windows', window.name(), name, val)

def getParam(className, subName, name, default=None):
  if not className:
    classd = config
  else:
    classd = getCDict(config, className)
  sub = getCDict(classd, subName)
  res = sub.get(name)
  if res == None:
    res = default
  return res

def setParam(className, subName, name, value):
  if not className:
    classd = config
  else:
    classd = getCDict(config, className)
  sub = getCDict(classd, subName)
  sub[name] = value
  


def setup_config_dir():
  if not os.path.exists(config_dir):
    os.mkdir(config_dir)


_config_hooks = []

def register_config_hook(pre_load, post_load, pre_save, post_save):
  hook = {}
  hook['pre_load'] = pre_load
  hook['post_load'] = post_load
  hook['pre_save'] = pre_save
  hook['post_save'] = post_save
  _config_hooks.append(hook)

def run_config_hooks(name):
  for hook in _config_hooks:
    f = hook.get(name)
    if f: hook[name]()

def __deep_update_dict(left, right):
  for key, val in right.items():
    l = left.get(key)
    if l != None and  type(l) == type({}):
      __deep_update_dict(l, val)
    else:
      left[key] = val

def load_config():
  global config
  setup_config_dir()
  run_config_hooks('pre_load')
  res = 0
  try:
    f = open(config_rc_path, "r")
    #print config
    c = pickle.load(f)
    #config.update(c)
    __deep_update_dict(config, c)
    f.close()
    res = 1
  except IOError:
    if os.path.exists(config_rc_path):
      print 'Invalid config file(%s), ignoring' % config_rc_path    

  run_config_hooks('post_load')
  return res
  #print config
  
  

def save_config():
  run_config_hooks('pre_save')
  try:
    f = open(config_rc_path + '.tmp', "w")
    pickle.dump(config, f)
    f.close()
    if os.path.exists(config_rc_path):
      os.rename(config_rc_path, config_rc_path + '.bak' )    
    os.rename(config_rc_path + '.tmp', config_rc_path)
    #print config
  except IOError:
    print "Error writing to config file: %s" % configPath()
  run_config_hooks('post_save')

