#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

from gtk import *
try:
  from gnome.ui import *
except:
  pass
import libglade
import os
import sys

import config
import Base
try:
  import _pmailextensions
  have_pmailextensions = 1
except:
  have_pmailextensions = 0

def get_widgets(obj, widget):
  if isinstance(widget, GtkContainer):
    for child in widget.children():
      s = "obj._%s = child" % (child.get_name())
      try:
        exec s
      except :
        print 'get_widgets: could not do: %s' % s
      get_widgets(obj, child)

glades = {}

class Window(Base.PMailObject):
  def __init__(self, nfilename='all.glade', windowname=None):
    Base.PMailObject.__init__(self)

    filename = config.get_file(os.path.join('gtkf', nfilename))

    if not os.path.exists(filename):
      filename = config.get_file(os.path.join('plugins', nfilename))
      if not os.path.exists(filename):
        print 'Can\'t find required file: %s' % nfilename
        sys.exit(2)

    self.debug('loading file: %s' % filename)
    self._glade = libglade.GladeXML(filename)
    self.debug('done.')

    if not windowname:
      windowname = self.__class__.__name__

    self.debug('using widget: %s' % windowname)
    self._window = self._glade.get_widget(windowname)

    if not self._window:
      self.log_error('GladeWindow: could not find widget: %s' % windowname)

    get_widgets(self, self._window)

  def window(self):
    return self._window

  def show(self):
    if self._glade:
      self._glade = None
    self.update_display()
    self._window.show()

  def hide(self):
    self._window.hide()

  def destroy(self, d=None):
    self._window.destroy()

  def update_display(self):
    pass

  def set_parent(self, parent, dialog_w=0, dialog_h=0):
    if have_pmailextensions:
      _pmailextensions.window_set_parent(self._window._o,
                                         parent._o)
