#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

from gtk import *
import GtkExtra

import GladeWindow
import Base
import config
import gutil

_progress_bar = None

def show(title, label, count, parent):
  global _progress_bar
  
  _progress_bar = ProgressBar()
  _progress_bar._message.set_text(label)
  _progress_bar.window().set_title(title)
  _progress_bar.set_parent(parent)
  _progress_bar._count = count
  _progress_bar._canceled = 0
  _progress_bar.show()
  return _progress_bar

class ProgressBar(GladeWindow.Window):
  def __init__(self):
    GladeWindow.Window.__init__(self)

    sigs = { 'cancel': self.cancel  }
    self._glade.signal_autoconnect(sigs)

  def cancel(self, b):
    self._canceled = 1

  def user_aborted(self):
    return self._canceled

  def update(self, idx):
    f = float(idx)/float(self._count)
    self._bar.update(f)
    return TRUE

  def destroy(self, d=None):
    self._window.hide()
    GladeWindow.Window.destroy(self)

