#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

from gtk import *

import GladeWindow
import MsgWindow
import MainWindow
import mail.Plugin

def show(message):
  w = SMessageWindow(message)
  w.show()

class SMessageWindow(GladeWindow.Window):
  def __init__(self, message):
    GladeWindow.Window.__init__(self)

    self._message = message
    self._messageWindow = MsgWindow.create_message_window(MainWindow.window)

    self.box = GtkVBox()
    self._window.add(self.box)
    self.box.show()

    self.box.pack_start(self._messageWindow, expand=TRUE)
    self._messageWindow.show()
    self._messageWindow.display_message(message)
    mail.Plugin.call_plugins('message_displayed', (message,
                                                   self._messageWindow))
    
