#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

from gnome.ui import *
from gtk import *

import GladeWindow
import _pmailextensions

def show(parent, text):
  w = Spell(parent)
  w.show()
  w.check(text)


class Spell(GladeWindow.Window):
  def __init__(self, parent):
    GladeWindow.Window.__init__(self)

    self.set_parent(parent._window)

    sigs = { 'ok': self.destroy,
             'cancel': self.destroy,
             'found_word': self.found_word,
             'handled_word': self.handled_word
             }
    self._glade.signal_autoconnect(sigs)

    _pmailextensions.setup_gnome_spell(self._spell._o, self.found_word)


  def found_word(self, widget, d):
    #print 'found_word:', d
    pass

  def handled_word(self, widget, d):
    print _pmailextensions.spellinfo_get_original(d)

  def check(self, text):
    #print 'spelling:', text
    print self._spell.check(text)
  
    


