#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

import string

import Base

class SearchCriteria(Base.PMailObject):
  def __init__(self):
    Base.PMailObject.__init__(self)
    self._criteria = []

  AND = 0
  OR = 1

  CONTAINS=0
  NOT_CONTAINS=1
  EQUALS=2
  NOT_EQUALS=3
  GREATER_THAN=4
  LESS_THAN=5
  IS=6
  NOT=7

  operator_strings = [ 'Contains',
                       "Doesn't Contain",
                       'Equal To',
                       'Not Equal To',
                       'Greater Than',
                       'Less Than',
                       'Is',
                       'Is Not'
                       ]

  def add_operation(self, field_name, operator, val, bool_operator=None):
    dict = { 'field': string.upper(field_name),
             'operator': operator,
             'value': val,
             'bool': bool_operator
             }
    self._criteria.append(dict)

  def operations(self):
    return self._criteria
    
