#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  

import config
import util

import Source
from IMAP import IMAPSource
from POP import POPSource
from MH import MHSource
from SpoolFile import SpoolFileSource
import Plugin

def save_config():
  dicts = []

  for source in util.sources:
    source.save_message_cache()
    dict = source.get_config()
    dicts.append(dict)
  config.setParam(None, 'Mail', 'sources', dicts)


def load_config():

  dicts = config.getParam(None, 'Mail', 'sources', None)

  if dicts:
    for dict in dicts:
      classN = dict['class']
      exec "s = %s()" % classN
      s.read_config(dict)
      util.sources.append(s)
    for source in util.sources:
      source.fixup()
      Plugin.call_plugins('source_created', (source,))
  Source.update_next_unique_id(util.sources)

  
