#  PMail - GNOME/GTK/Python email client
#  Copyright (C) 2000 Scott Bender <sbender@harmony-ds.com>

#  This file is part of PMail.

#  PMail is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  PMail is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with GNU Emacs; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.  


from gtk import *
import GtkExtra

try:
  import gnome
  import _pmailextensions
except:
  pass

import mail.Plugin
import gtkf.gutil

class Plugin(mail.Plugin.Plugin):
  def __init__(self):
    mail.Plugin.Plugin.__init__(self)
    self._enabled = 0

  def name(self):
    return "HtmlViewer"

  def message_list_popup_items(self, message):
    if self._get_html_part(message):
      item = GtkMenuItem('Open Externally')
      item.connect('activate', self.open_html, message)
      return [item]
    return None

  def message_displayed(self, message, message_window):
    if self._enabled:
      self.open_html(None, message, 0)


  def _get_html_part(self, message, open_plain=1):
    part = message.get_parts()

    if part.mime_type() == 'text/html':
      npart = part
    else:
      npart = part.find_part('text', 'html', deep=1)

      if not npart and open_plain:
        npart = part
        
    return npart

  
  def open_html(self, d, message, open_plain=1):
    html_part = self._get_html_part(message)
    if html_part:
      view = _pmailextensions.gnome_mime_get_value(html_part.mime_type(),
                                                   'open')
      if view:
        fileName = html_part.write_to_file()
        gtkf.gutil.exec_mime_open(html_part.mime_type(), 'open', fileName)


#print 'Registering HtmlViwer plugin'
#config.register_config_hook(None, load_config, save_config, None)
mail.Plugin.register_plugin(Plugin())

