/*
 * (POP3Lite) UserConf - 3lite POP3 Daemon (per-user configuration)
 * Copyright (C) 2000, 2001 Gergely Nagy <8@free.bsd.hu>
 *
 * This file is part of POP3Lite.
 *
 * POP3Lite is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * POP3Lite is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $Id: userconf.h,v 1.3 2001/01/12 15:58:59 algernon Exp $
 */

#ifndef __POP3LITE_USERCONF_H__
#define __POP3LITE_USERCONF_H__ 1

#include <pop3lite.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" 
{
#endif /* __cpluslpus */

/**
 * P3LHook_userconf_load_config: hook to load per-user configuration
 * @control: the main control struct
 * @location: where to load configuration from (filename eg)
 * @table: where to put configuration
 *
 * This hook is used to load per-user configuration.
 *
 * Returns: nothing
 **/
typedef void (*P3LHook_userconf_load_config) ( P3LControl *control,
					       const char *location,
					       GHashTable *table );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* ! __POP3LITE_USERCONF_H__ */
