set aliasWindows {}
set aliasMod 0
set bookMod 0
proc Aliases {} {global idCnt t b option defaultFont aliasWindows
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm title $w $t(aliases)
set hd(w) $w
set hd(old,default_book) $option(default_book)
frame $w.mbar -relief raised -bd 1
FindAccelerators a {show addrbooks import}
menubutton $w.mbar.show -text $t(show) -menu $w.mbar.show.m -underline $a(show)
menu $w.mbar.show.m
set hd(showmenu) $w.mbar.show.m
set b($w.mbar.show) show_adrbook_menu
menubutton $w.mbar.book -text $t(addrbooks) -menu $w.mbar.book.m -underline $a(addrbooks)
set m $w.mbar.book.m
menu $m
$m add checkbutton -label $t(use_system_aliases) -variable option(use_system_aliases)
set b($m,[$m index end]) use_system_aliases
$m add separator
$m add command -label $t(add)... -command AddrbookAdd
set b($m,[$m index end]) add_addrbook
$m add command -label $t(delete)... -command AddrbookDelete
set b($m,[$m index end]) delete_addrbook
$m add cascade -label $t(set_default)... -menu $m.sd
set b($m,[$m index end]) set_default_addrbook
menu $m.sd
set hd(defaultmenu) $m.sd
set m $w.mbar.import.m
menubutton $w.mbar.import -text $t(import) -menu $m -underline $a(import)
set b($w.mbar.import) import_aliases_from_pgm
menu $m
$m add command -label mail -command "AddrbookImport mail"
$m add command -label elm -command "AddrbookImport elm"
$m add command -label pine -command "AddrbookImport pine"
pack $w.mbar.show $w.mbar.book $w.mbar.import -side left -padx 5
frame $w.l
scrollbar $w.l.scroll -relief raised -bd 1 -highlightthickness 0 -command "$w.l.list yview"
listbox $w.l.list -yscroll "$w.l.scroll set" -relief raised -bd 1 -exportselection false -highlightthickness 0 -font $defaultFont -selectmode extended
Size $w.l.list aliasList
set hd(listbox) $w.l.list
pack $w.l.scroll -side right -fill y
pack $w.l.list -expand 1 -fill both
bind $w.l.list <ButtonRelease-1> "SetAliasesState $id"
set b($w.l.list) alias_list
frame $w.b
button $w.b.new -text $t(new)... -command "AliasDetail $id new"
set b($w.b.new) new_alias
button $w.b.edit -text $t(edit) -state disabled -command "AliasDetail $id edit \$${id}(current)"
set b($w.b.edit) edit_alias
button $w.b.delete -text $t(delete) -state disabled -command "AliasDelete $id"
set b($w.b.delete) delete_alias
menubutton $w.b.move -text $t(move_to) -state disabled -menu $w.b.move.m -indicatoron 1 -relief raised
set b($w.b.move) move_alias
menu $w.b.move.m
set hd(movemenu) $w.b.move.m
button $w.b.close -text $t(close) -command "AliasClose $id"
set b($w.b.close) dismiss
pack $w.b.new $w.b.edit $w.b.delete $w.b.move $w.b.close -side left -expand 1 -pady 5
pack $w.mbar -side top -fill x
pack $w.b -side bottom -fill x
pack $w.l -expand 1 -fill both
AliasesUpdateBooklist $id
AliasesPopulate $id
Place $w aliases
lappend aliasWindows $id
bind $w <Destroy> AliasSave
trace variable option(use_system_aliases) w "AliasesUpdateBooklist {}"
trace variable option(addrbooks) w "AliasesUpdateBooklist {}"}
proc AliasesUpdateBooklist {handler args} {global aliasWindows option aliasBook
if {"" == $handler} {set hds $aliasWindows} {set hds $handler}
foreach handler $hds {upvar #0 $handler hd
$hd(showmenu) delete 1 end
$hd(movemenu) delete 1 end
$hd(defaultmenu) delete 1 end
foreach a $option(addrbooks) {set book [lindex $a 0]
if ![info exists hd(show,$book)] {set hd(show,$book) 1}}
set sysbook [lindex $option(system_aliases) 0]
if {$option(use_system_aliases)} {if ![info exists hd(show,$sysbook)] {set hd(show,$sysbook) 1}} {catch {unset hd(show,$sysbook)}}
foreach book [array names aliasBook writable,*] {regsub writable, $book {} name
$hd(showmenu) add checkbutton -label $name -variable ${handler}(show,$name) -command "AliasesPopulate $handler"
if $aliasBook(writable,$name) {$hd(movemenu) add command -label $name -command "AliasMoveTo move $handler $name"
$hd(defaultmenu) add radiobutton -label $name -variable option(default_book) -value $name -command {set bookMod 1}}}}}
proc AliasesPopulate {{handler {}}} {global aliasWindows
if {"" == $handler} {set hds $aliasWindows} {set hds $handler}
foreach handler $hds {upvar #0 $handler hd
set old {}
foreach sel [$hd(listbox) curselection] {lappend old $sel}
RatAlias list alias
set hd(aliasIds) [lsort [array names alias]]
set top [lindex [$hd(listbox) yview] 0]
$hd(listbox) delete 0 end
set hd(aliasIds) ""
foreach a [lsort [array names alias]] {set book [lindex $alias($a) 0]
if $hd(show,$book) {lappend hd(aliasIds) $a
$hd(listbox) insert end [format "%-10s  %-10s  %-20s  %s" $book $a [lindex $alias($a) 1] [lindex $alias($a) 2]]}}
$hd(listbox) yview moveto $top
foreach o $old {set i [lsearch -exact $hd(aliasIds) $o]
if {-1 != $i} {$hd(listbox) selection set $i
$hd(listbox) see $i}}
SetAliasesState $handler}}
proc SetAliasesState handler {upvar #0 $handler hd
global aliasBook
set onlywr 1
foreach selected [$hd(listbox) curselection] {set a [RatAlias get [lindex $hd(aliasIds) $selected]]
if !$aliasBook(writable,[lindex $a 0]) {set onlywr 0
break}}
set editState disabled
set moveState disabled
set deleteState disabled
set l [llength [$hd(listbox) curselection]]
if {$l == 1 && $onlywr} {set editState normal
set hd(current) [lindex $hd(aliasIds) [$hd(listbox) curselection]]}
if {$l > 0} {if $onlywr {set moveState normal
set deleteState normal}}
$hd(w).b.edit configure -state $editState
$hd(w).b.move configure -state $moveState
$hd(w).b.delete configure -state $deleteState}
proc AliasSave {} {global option aliasMod bookMod aliasBook
if $aliasMod {set books $option(addrbooks)
if $option(use_system_aliases) {lappend books $option(system_aliases)}
foreach book $books {if $aliasBook(changed,[lindex $book 0]) {RatAlias save [lindex $book 0] [lindex $book 2]}}
set aliasMod 0}
if $bookMod {SaveOptions
set bookMod 0}}
proc AliasClose handler {global aliasWindows aliasMod b
upvar #0 $handler hd
set i [lsearch -exact $aliasWindows $handler]
if {-1 != $i} {set aliasWindows [lreplace $aliasWindows $i $i]}
RecordSize $hd(listbox) aliasList
RecordPos $hd(w) aliases
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)}
proc AliasDetail {handler mode {template {}}} {global idCnt t b aliasBook option aliasDetail
upvar #0 $handler ahd
if {[string length $template] && [info exists aliasDetail($template)]} {wm deiconify $aliasDetail($template)
return}
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(mode) $mode
set hd(handler) $handler
toplevel $w
wm title $w $t(alias)
set hd(w) $w
label $w.book_label -text $t(addrbook):
set hd(book) $option(default_book)
menubutton $w.book_but -textvariable ${id}(book) -relief raised -menu $w.book_but.m
set b($w.book_but) alias_adr_book
menu $w.book_but.m
foreach book [array names aliasBook writable,*] {if !$aliasBook($book) {continue}
regsub writable, $book {} name
$w.book_but.m add radiobutton -label $name -value $name -variable ${id}(book)}
grid $w.book_label -sticky e
grid $w.book_but -row 0 -column 1 -sticky ew -padx 2 -pady 2
set line 1
foreach f {alias fullname} {label $w.${f}_label -text $t($f):
entry $w.${f}_entry -textvariable ${id}($f)
set b($w.${f}_entry) alias_$f
grid $w.${f}_label -sticky e
grid $w.${f}_entry -row $line -column 1 -sticky ew -padx 2 -pady 2
incr line}
label $w.content_label -text $t(content):
text $w.content_text -wrap word -setgrid true
set b($w.content_text) alias_content
grid $w.content_label -sticky ne
grid $w.content_text -row $line -column 1 -sticky nsew -padx 2 -pady 2
Size $w.content_text aliasText
set hd(content_text) $w.content_text
incr line
label $w.comment_label -text $t(comment):
text $w.comment_text -wrap word
set b($w.comment_text) alias_comment
grid $w.comment_label -sticky ne
grid $w.comment_text -row $line -column 1 -sticky nsew -padx 2 -pady 2
Size $w.comment_text aliasText
set hd(comment_text) $w.comment_text
grid columnconfigure $w 1 -weight 1
grid rowconfigure $w 3 -weight 1
bindtags $w.content_text [list Text $w.content_text . all]
bind $w.content_text <Key-Return> {break}
bindtags $w.comment_text [list Text $w.comment_text . all]
bind $w.comment_text <Key-Return> {break}
OkButtons $w $t(ok) $t(cancel) "AliasDetailDone $id"
grid $w.buttons - -pady 5 -sticky ew
if [string length $template] {set aliasDetail($template) $w
set hd(template) $template
set a [RatAlias get $template]
set hd(alias) $template
set hd(book) [lindex $a 0]
set hd(fullname) [lindex $a 1]
$hd(content_text) insert 1.0 [lindex $a 2]
$hd(comment_text) insert 1.0 [lindex $a 3]
set hd(old,book) $hd(book)}
set hd(old,alias) $hd(alias)
focus $w.alias_entry
Place $w aliasDetail}
proc AliasDetailDone {handler action} {global t b aliasMod aliasBook aliasDetail
upvar #0 $handler hd
if {1 == $action} {set hd(content) [string trim [$hd(content_text) get 1.0 end]]
set hd(comment) [string trim [$hd(comment_text) get 1.0 end]]
if {0 == [string length $hd(alias)] || 0 == [string length $hd(content)]} {Popup $t(need_alias_and_content)
return}
if {"edit" == $hd(mode)} {RatAlias delete $hd(old,alias)
set aliasBook(changed,$hd(old,book)) 1}
RatAlias add $hd(book) $hd(alias) $hd(fullname) $hd(content) $hd(comment)
set aliasMod 1
set aliasBook(changed,$hd(book)) 1
AliasesPopulate}
RecordPos $hd(w) aliasDetail
RecordSize $hd(content_text) aliasText
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)
if [info exists hd(template)] {unset aliasDetail($hd(template))}
unset hd}
proc AliasDelete handler {upvar #0 $handler hd
global aliasBook aliasMod
foreach a [$hd(listbox) curselection] {set alias [lindex $hd(aliasIds) $a]
set aliasBook(changed,[lindex [RatAlias get $alias] 0]) 1
set aliasMod 1
RatAlias delete $alias}
AliasesPopulate}
proc AddrbookImport format {global idCnt t b
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm title $w $t(import)
set hd(w) $w
set hd(format) $format
label $w.label -text $t(name):
entry $w.entry -textvariable ${id}(name) -width 20
set b($w.entry) name_of_adrbook
grid $w.label -sticky e
grid $w.entry -row 0 -column 1 -sticky ew -pady 5
frame $w.chooser
set hd(fh) [FileSelectorCreate $w.chooser ${id}(fname) "AddrbookImportDone $id 1" 0 1]
grid $w.chooser - -sticky nsew -pady 5 -padx 5
grid columnconfigure $w 1 -weight 1
grid rowconfigure $w 1 -weight 1
OkButtons $w $t(ok) $t(cancel) "AddrbookImportDone $id"
grid $w.buttons - -pady 5 -sticky ew
bind $w <Return> {}
Place $w addrbookImport
update
focus $w.entry}
proc AddrbookImportDone {handler action} {upvar #0 $handler hd
global option t b bookMod aliasBook
if $action {if ![string length $hd(name)] {Popup $t(need_name)
return}
if [info exists aliasBook(writable,$hd(name)] {Popup $t(book_already_exists)
return}
FileSelectorCleanup $hd(fh)
if {![file isfile $hd(fname)] || ![file readable $hd(fname)]} {Popup "$t(illegal_file_spec): $hd(fname)"
return}
set aliasBook(writable,$hd(name)) 0
set aliasBook(changed,$hd(name)) 0
set bookMod 1
lappend option(addrbooks) [list $hd(name) $hd(format) $hd(fname)]
switch $hd(format) {mail {ReadMailAliases $hd(fname) $hd(name)} elm {ReadElmAliases $hd(fname) $hd(name)} pine {ReadPineAliases $hd(fname) $hd(name)}}
AliasesPopulate}
RecordPos $hd(w) addrbookAdd
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)
unset hd}
proc AddrbookAdd {} {global idCnt t b
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm title $w $t(new)
set hd(w) $w
label $w.label -text $t(name):
entry $w.entry -textvariable ${id}(name) -width 20
set b($w.entry) name_of_adrbook
grid $w.label -sticky e
grid $w.entry -row 0 -column 1 -sticky ew -pady 5
frame $w.chooser
set hd(fh) [FileSelectorCreate $w.chooser ${id}(fname) "AddrbookAddDone $id 1" 0 0]
grid $w.chooser - -sticky nsew -pady 5 -padx 5
grid columnconfigure $w 1 -weight 1
grid rowconfigure $w 1 -weight 1
OkButtons $w $t(ok) $t(cancel) "AddrbookAddDone $id"
bind $w <Return> ""
grid $w.buttons - -pady 5 -sticky ew
Place $w addrbookAdd
update
focus $w.entry}
proc AddrbookAddDone {handler action} {upvar #0 $handler hd
global option t b bookMod aliasBook
if $action {if ![string length $hd(name)] {Popup $t(need_name)
return}
if [info exists aliasBook(writable,$hd(name)] {Popup $t(book_already_exists)
return}
FileSelectorCleanup $hd(fh)
set dir [file dirname $hd(fname)]
if {([file exists $hd(fname)] && ![file readable $hd(fname)]) || [file isdirectory $hd(fname)] ||(![file exists $hd(fname)] && ![file writable $dir])} {Popup "$t(illegal_file_spec): $hd(fname)"
return}
if {([file isfile $hd(fname)] && [file writable $hd(fname)]) ||(![file exists $hd(fname)] && [file isdirectory $dir] && [file writable $dir])} {set aliasBook(writable,$hd(name)) 1} {set aliasBook(writable,$hd(name)) 0}
set aliasBook(changed,$hd(name)) 0
set bookMod 1
lappend option(addrbooks) [list $hd(name) tkrat $hd(fname)]
if [file exists $hd(fname)] {RatAlias read $hd(fname)}}
RecordPos $hd(w) addrbookAdd
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)
unset hd}
proc AddrbookDelete {} {global idCnt t b option defaultFont
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm title $w $t(delete)
set hd(w) $w
frame $w.l
scrollbar $w.l.scroll -bd 1 -highlightthickness 0 -command "$w.l.list yview"
listbox $w.l.list -yscroll "$w.l.scroll set" -bd 1 -exportselection false -highlightthickness 0 -font $defaultFont -selectmode extended
Size $w.l.list bookList
set hd(listbox) $w.l.list
pack $w.l.scroll -side right -fill y
pack $w.l.list -expand 1 -fill both
set b($w.l.list) list_of_books_to_delete
OkButtons $w $t(delete) $t(cancel) "AddrbookDeleteDone $id"
pack $w.l $w.buttons -side top -padx 5 -pady 5 -expand 1 -fill both
foreach book [lsort $option(addrbooks)] {$hd(listbox) insert end [lindex $book 0]}
Place $w addrBookDelete}
proc AddrbookDeleteDone {handler action} {upvar #0 $handler hd
global option aliasBook bookMod t b
if $action {foreach s [$hd(listbox) curselection] {lappend del [$hd(listbox) get $s]}
set keep {}
set remove {}
foreach book $option(addrbooks) {if {-1 == [lsearch -exact $del [lindex $book 0]]} {lappend keep $book} {lappend remove [lindex $book 0]}}
if {-1 != [lsearch -exact $remove $option(default_book)]} {set newDefault {}
foreach book [array names aliasBook writable,*] {if !$aliasBook($book) {continue}
regsub writable, $book {} name
if {-1 == [lsearch -exact $remove $name]} {set newDefault $name
break}}
if ![string length $newDefault] {Popup $t(need_writable_book)
return}
set option(default_book) $newDefault}
foreach r $remove {unset aliasBook(writable,$r)
unset aliasBook(changed,$r)}
set option(addrbooks) $keep
RatAlias list alias
foreach a [array names alias] {if {-1 != [lsearch -exact $del [lindex $alias($a) 0]]} {RatAlias delete $a}}
AliasesPopulate
set bookMod 1}
RecordPos $hd(w) addrBookDelete
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)
unset hd}
proc AliasMoveTo {op handler dest} {upvar #0 $handler hd
global aliasMod aliasBook
foreach i [$hd(listbox) curselection] {set a [lindex $hd(aliasIds) $i]
set alias [RatAlias get $a]
RatAlias delete $a
eval RatAlias add [lreplace $alias 0 0 $dest $a]
set aliasBook(changed,[lindex $alias 0]) 1
set aliasBook(changed,$dest) 1}
AliasesPopulate
incr aliasMod}
proc AliasExtract handler {global idCnt t b aliasBook option
upvar #0 $handler fh
set adrlist {}
foreach a [$fh(current) get from return_path reply_to sender cc bcc to] {if [$a isMe] {continue}
set good 1
foreach a2 $adrlist {if ![$a compare $a2] {set good 0
break}}
if $good {lappend adrlist $a}}
if ![llength $adrlist] {Popup $t(could_not_find_adr)
return}
RatAlias list alias
foreach a [array names alias] {foreach adr [split [lindex $alias($a) 2]] {set present($adr) 1}}
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm title $w $t(extract_adr)
set hd(w) $w
frame $w.book
label $w.book.label -text $t(addrbook):
set hd(book) $option(default_book)
menubutton $w.book.menu -textvariable ${id}(book) -relief raised -menu $w.book.menu.m -width 20 -indicatoron 1
set b($w.book.menu) aliases_adr_book
menu $w.book.menu.m
foreach book [array names aliasBook writable,*] {if !$aliasBook($book) {continue}
regsub writable, $book {} name
$w.book.menu.m add radiobutton -label $name -value $name -variable ${id}(book)}
pack $w.book.label $w.book.menu -side left
pack $w.book -side top -pady 5
frame $w.f
label $w.f.use -text $t(use)
label $w.f.name -text $t(alias)
label $w.f.fname -text $t(fullname)
label $w.f.content -text $t(content)
label $w.f.comment -text $t(comment)
grid $w.f.use $w.f.name $w.f.fname $w.f.content $w.f.comment -sticky w
set totlist ""
foreach a $adrlist {if [string length $totlist] {set totlist "$totlist,\n[$a get mail]"} {set totlist [$a get mail]}
if [info exists present([$a get mail])] {continue}
incr idCnt
set hd($idCnt,use) 1
set name [string tolower [lindex [$a get name] 0]]
if {![string length $name] || [info exists alias($name)]} {set name2 [string tolower [lindex [split [$a get mail] @.] 0]]
if ![string length $name] {set name $name2}
if [info exist alias($name2)] {for {set i 2} {[info exists alias($name2)]} {incr i} {set name2 $name$i}}
set name $name2}
set alias($name) ""
set hd($idCnt,name) $name
set hd($idCnt,fname) [$a get name]
set hd($idCnt,content) [$a get mail]
checkbutton $w.f.c$idCnt -variable ${id}($idCnt,use)
entry $w.f.en$idCnt -textvariable ${id}($idCnt,name) -width 8
entry $w.f.ef$idCnt -textvariable ${id}($idCnt,fname) -width 20
entry $w.f.ec$idCnt -textvariable ${id}($idCnt,content) -width 35
entry $w.f.ek$idCnt -textvariable ${id}($idCnt,comment) -width 30
set b($w.f.c$idCnt) aliasadd_use
set b($w.f.en$idCnt) alias_alias
set b($w.f.ef$idCnt) alias_fullname
set b($w.f.ec$idCnt) alias_content
set b($w.f.ek$idCnt) alias_comment
grid $w.f.c$idCnt $w.f.en$idCnt $w.f.ef$idCnt $w.f.ec$idCnt $w.f.ek$idCnt -sticky we}
set height [llength $adrlist]
if {$height > 1} {incr idCnt
set hd($idCnt,use) 0
set hd($idCnt,content) $totlist
checkbutton $w.f.c$idCnt -variable ${id}($idCnt,use)
entry $w.f.en$idCnt -textvariable ${id}($idCnt,name) -width 8
entry $w.f.ef$idCnt -textvariable ${id}($idCnt,fname) -width 20
if {$height > 10} {frame $w.f.ec$idCnt
scrollbar $w.f.ec$idCnt.scroll -relief sunken -command "$w.f.ec$idCnt.text yview" -highlightthickness 0
text $w.f.ec$idCnt.text -width 35 -height 10 -wrap none -yscroll "$w.f.ec$idCnt.scroll set"
pack $w.f.ec$idCnt.scroll -side right -fill y
pack $w.f.ec$idCnt.text -expand yes -fill both
set hd(listcmd) $w.f.ec$idCnt.text} {text $w.f.ec$idCnt -width 35 -height $height -wrap none
set hd(listcmd) $w.f.ec$idCnt}
$hd(listcmd) insert 1.0 $totlist
set hd(listvar) $idCnt,content
entry $w.f.ek$idCnt -textvariable ${id}($idCnt,comment) -width 30
set b($w.f.c$idCnt) aliasadd_use
set b($w.f.en$idCnt) alias_alias
set b($w.f.ef$idCnt) alias_fullname
set b($w.f.ec$idCnt) alias_content
set b($w.f.ek$idCnt) alias_comment
grid $w.f.c$idCnt $w.f.en$idCnt $w.f.ef$idCnt $w.f.ec$idCnt $w.f.ek$idCnt -sticky wen}
grid columnconfigure $w.f 1 -weight 1
grid columnconfigure $w.f 2 -weight 1
grid columnconfigure $w.f 3 -weight 1
grid columnconfigure $w.f 4 -weight 1
pack $w.f -side top -fill both
OkButtons $w $t(add_aliases) $t(cancel) "AliasExtractDone $id"
pack $w.buttons -side bottom -pady 5 -fill x
Place $w extractAlias}
proc AliasExtractDone {handler action} {upvar #0 $handler hd
global aliasMod t b
set ids {}
foreach i [array names hd *,use] {if $hd($i) {lappend ids [lindex [split $i ,] 0]}}
if {1 == $action} {if [info exists hd(listcmd)] {set hd($hd(listvar)) [$hd(listcmd) get 1.0 end]}
foreach id $ids {if ![string length $hd($id,name)] {Popup $t(missing_alias_name)
continue}
RatAlias add $hd(book) $hd($id,name) $hd($id,fname) $hd($id,content) $hd($id,comment)
set aliasMod 1}
if {1 == $aliasMod} {AliasesPopulate}
AliasSave}
RecordPos $hd(w) extractAlias
foreach bn [array names b $hd(w)*] {unset b($bn)}
destroy $hd(w)
unset hd}
proc AliasChooser master {global idCnt t b defaultFont
set id al[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm transient $w [winfo toplevel $master]
wm title $w $t(alias_chooser)
set hd(w) $w
set hd(search) ""
set bbox [$master bbox insert]
set x [expr [winfo rootx $master]+[lindex $bbox 0]+5]
set y [expr [winfo rooty $master]+[lindex $bbox 1]-20]
wm geom $w +$x+$y
scrollbar $w.scroll -relief raised -bd 1 -highlightthickness 0 -command "$w.list yview"
listbox $w.list -yscroll "$w.scroll set" -relief raised -bd 1 -exportselection false -highlightthickness 0 -font $defaultFont -selectmode single
set b($w.list) alias_chooser
Size $w.list aliasChooser
pack $w.scroll -side right -fill y
pack $w.list -expand 1 -fill both
set hd(list) $w.list
bind $w <Control-c> "set ${id}(done) 0"
bind $w <Key-Escape> "set ${id}(done) 0"
bind $w <Key-Return> "set ${id}(done) 1"
bind $w <Key-Tab> "set ${id}(done) 1"
bind $w.list <ButtonRelease-1> "set ${id}(done) 1"
bind $w <Key-Up> "AliasChooserMoveSel $id up"
bind $w <Key-Down> "AliasChooserMoveSel $id down"
bind $w <Key> "AliasChooserSearch $id %A"
RatAlias list alias
set hd(aliasIds) [lsort [array names alias]]
foreach a $hd(aliasIds) {$hd(list) insert end [format "%-8s %-20s" $a [lindex $alias($a) 1]]}
$hd(list) selection set 0
set hd(oldFocus) [focus]
grab $w
focus $w
tkwait variable ${id}(done)
RecordSize $w.list aliasChooser
if {1 == $hd(done)} {set ret [lindex $hd(aliasIds) [$hd(list) curselection]]} {set ret ""}
unset b($w.list)
destroy $w
focus $hd(oldFocus)
unset hd
return $ret}
proc AliasChooserMoveSel {handler direction} {upvar #0 $handler hd
set cur [$hd(list) curselection]
$hd(list) selection clear $cur
if [string compare up $direction] {if {[incr cur] > [$hd(list) size]} {incr cur -1}
if {[expr $cur/[$hd(list) size].0] >= [lindex [$hd(list) yview] 1]} {$hd(list) yview $cur}} {if {$cur > 0} {incr cur -1
if {[expr $cur/[$hd(list) size].0] < [lindex [$hd(list) yview] 0]} {$hd(list) yview scroll -1 pages}}}
$hd(list) selection set $cur
set hd(search) ""}
proc AliasChooserSearch {handler key} {upvar #0 $handler hd
if {1 != [scan $key "%s" key2]} {return}
set hd(search) "$hd(search)$key2"
set i [lsearch -glob $hd(aliasIds) "$hd(search)*"]
if {-1 == $i} {bell
set hd(search) ""} {$hd(list) selection clear [$hd(list) curselection]
$hd(list) selection set $i
$hd(list) see $i}}
proc ElmGets {fh linevar} {upvar $linevar line
set haveline 0
set line ""
while {$haveline <= 0 && -1 != [gets $fh sline]} {set sline [string trim $sline]
if {[string match {#*} $sline] || 0==[string length $sline]} {continue}
set line "${line}${sline} "
if {![string match {?*=?*=?* } $line] || [string match {*, } $line]} {set haveline 0} {set haveline 1}}
if {$haveline <= 0} {return $haveline} {return [string length $line]}}
proc ReadElmAliases {file book} {set n 0
set fh [open $file r]
while {0 < [ElmGets $fh line]} {if {[string match {*=*=*} $line] && [string length [lindex $line 0]]} {set a [split $line =]
RatAlias add $book [string trim [lindex $a 0]] [string trim [lindex $a 1]] [string trim [lindex $a 2]] {}
incr n}}
close $fh
return $n}
proc ReadMailAliases {file book} {set n 0
set fh [open $file r]
while {-1 != [gets $fh line]} {while {1 == [regexp {\\$} $line]} {if {-1 == [gets $fh cont]} {break}
set line [join [list [string trimright $line \\] $cont] ""]}
if [string match {alias *} $line] {regsub -all {[ 	][ 	]} $line { } line
set a [split $line]
set content ""
foreach e [lrange $a 2 end] {set content "$content,[string trim $e]"}
if [string length [string trim [lindex $a 1]]] {RatAlias add $book [string trim [lindex $a 1]] [string trim [lindex $a 1]] [string trim $content] {}
incr n}}}
close $fh
return $n}
proc ReadPineAliases {file book} {set fh [open $file r]
set aliases {}
while {-1 != [gets $fh line]} {if [regsub {^ } $line "" cont] {set aliases [lreplace $aliases end end "[lindex $aliases end] $cont"]} {lappend aliases $line}}
close $fh
set n 0
foreach a $aliases {if [regexp {^#DELETED} $a] {continue}
set sa [split $a "\t"]
if [string length [lindex $sa 0]] {incr n
set content [lindex $sa 2]
regexp {^\((.+)\)$} $content notUsed content
RatAlias add $book [lindex $sa 0] [lindex $sa 1] $content {}}}
return $n}
