set composeWindowList {}
set composeHeaderList {to subject cc bcc keywords content_description
		       reply_to comments from}
set composeAdrHdrList {to cc bcc reply_to}
proc Compose {} {global idCnt
set handler composeM[incr idCnt]
return [DoCompose $handler 0 1]}
proc ComposeReply {msg to} {global t
set msg [ComposeChoose $msg $t(reply_to_which)]
if ![string length $msg] {return 0}
set handler [$msg reply $to]
return [DoCompose $handler 1 1]}
proc ComposeForwardInline msg {global idCnt option t
set handler composeM[incr idCnt]
upvar #0 $handler mh
set msg [ComposeChoose $msg $t(forward_which)]
if ![string length $msg] {return 0}
foreach header [$msg headers full] {set name [string tolower [lindex $header 0]]
switch $name {subject {set mh(subject) "Fwd: [lindex $header 1]"} description {set hd(description) [lindex $header 1]}}
if {-1 != [lsearch [string tolower $option(show_header_selection)] $name]} {regsub -all -- - $name _ name
set inline_header($name) [lindex $header 1]}}
set body [$msg body]
set type [string tolower [$body type]]
set inline {}
set attach $body
if {(![string compare text [lindex $type 0]] && ![string compare plain [lindex $type 1]]) ||(![string compare message [lindex $type 0]] && ![string compare rfc822 [lindex $type 1]])} {set inline $body
set attach {}} elseif {![string compare multipart [lindex $type 0]]} {set children [$body children]
set type [string tolower [[lindex $children 0] type]]
if {![string compare text [lindex $type 0]] && ![string compare plain [lindex $type 1]]} {set inline [lindex $children 0]
set attach [lrange $children 1 end]} {set inline {}
set attach $children}}
set bhandler composeM[incr idCnt]
upvar #0 $bhandler bh
set mh(body) $bhandler
set bh(type) text
set bh(subtype) plain
if [string length $inline] {set bh(encoding) [$inline encoding]
set bh(parameter) [$inline params]
set bh(id) [$inline id]
set bh(description) [$inline description]
set preface "\n\n$option(forwarded_message)\n"
set length 5
foreach f $option(show_header_selection) {if {$length < [string length $f]} {set length [string length $f]}}
foreach field $option(show_header_selection) {regsub -all -- - [string tolower $field] _ f
if [info exists inline_header($f)] {if [info exists t($f)] {set name $t($f)} {set name $field}
set preface [format "%s%${length}s: %s\n" $preface $name $inline_header($f)]}}
set mh(data) "${preface}\n[$inline data 0]"}
foreach child $attach {set chandler composeC[incr idCnt]
upvar #0 $chandler ch
lappend bh(children) $chandler
set type [string tolower [$child type]]
set ch(type) [lindex $type 0]
set ch(subtype) [lindex $type 1]
set ch(encoding) [$child encoding]
set ch(parameter) [$child params]
set ch(id) [$child id]
set ch(description) [$child description]
if {![info exists mh(data)] && ![string compare text $ch(type)]} {set mh(data) [$child data 0]} {set ch(filename) [RatTildeSubst $option(send_cache)/rat.[RatGenId]]
set fh [open $ch(filename) w 0600]
$child saveData $fh 1 0
close $fh
set ch(removeFile) 1
lappend mh(attachmentList) $chandler}}
return [DoCompose $handler 0 0]}
proc ComposeForwardAttachment msg {global option t idCnt
set msg [ComposeChoose $msg $t(forward_which)]
if ![string length $msg] {return 0}
set handler composeM[incr idCnt]
upvar #0 $handler mh
set id compose[incr idCnt]
upvar #0 $id hd
set hd(filename) [RatTildeSubst $option(send_cache)/rat.[RatGenId]]
set fh [open $hd(filename) w 0600]
set hd(description) $t(forwarded_message)
foreach header [$msg headers full] {puts $fh "[lindex $header 0]: [lindex $header 1]\r"
switch [string tolower [lindex $header 0]] {subject {set mh(subject) "Fwd: [lindex $header 1]"} description {set hd(description) [lindex $header 1]}}}
puts $fh "\r"
puts -nonewline $fh [$msg rawBody]
close $fh
set hd(type) message
set hd(subtype) rfc822
set hd(removeFile) 1
set mh(attachmentList) $id
return [DoCompose $handler 0 1]}
proc ComposeHeld {} {global idCnt t b defaultFont
if ![llength [set content [RatHold list]]] {Popup $t(no_held)
return 0}
set id gh[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
toplevel $w
wm title $w $t(getheld)
frame $w.list
scrollbar $w.list.scroll -relief sunken -command "$w.list.list yview" -highlightthickness 0
listbox $w.list.list -yscroll "$w.list.scroll set" -height 10 -width 80 -relief sunken -font $defaultFont -selectmode browse -exportselection false -highlightthickness 0
set b($w.list.list) compose_held_pick
bind $w.list.list <Double-1> "set ${id}(done) 1"
pack $w.list.scroll -side right -fill y
pack $w.list.list -side left -expand 1 -fill both
OkButtons $w $t(ok) $t(cancel) "set ${id}(done)"
pack $w.buttons -side bottom -pady 5 -fill x
pack $w.list -expand 1 -fill both -padx 5 -pady 5
foreach m $content {$w.list.list insert end $m}
Place $w composeHeld
grab $w
tkwait variable ${id}(done)
set index [$w.list.list curselection]
RecordPos $w composeHeld
destroy $w
if {1 == $hd(done)} {if [string length $index] {return [ComposeExtracted [RatHold extract $index]]} {Popup $t(must_select)}}
unset b($w.list.list)
unset hd}
proc ComposeExtracted mgh {upvar #0 $mgh mh
if [info exists mh(body)] {upvar #0 $mh(body) bh
if ![string compare "$bh(type)/$bh(subtype)" text/plain] {set edit bh
set children {}} elseif ![string compare "$bh(type)" multipart] {set children $bh(children)
upvar #0 [lindex $children 0] ch1
if ![string compare "$ch1(type)/$ch1(subtype)" text/plain] {set edit ch1
set children [lreplace $children 0 0]} {set edit {}}} {set edit {}
set children $mh(body)}
if [info exists bh(pgp_sign)] {set mh(pgp_sign) $bh(pgp_sign)
set mh(pgp_encrypt) $bh(pgp_encrypt)}
if [string length $edit] {set fh [open [set ${edit}(filename)] r]
set mh(data) [read $fh]
close $fh
if [set ${edit}(removeFile)] {catch "file delete -force -- [set ${edit}(filename)]"}}
set mh(attachmentList) $children}
return [DoCompose $mgh 0 0]}
proc DoCompose {handler edit_text add_sig} {global option t b composeHeaderList langCharset composeWindowList tk_strictMotif ratCurrentHost env
upvar #0 $handler mh
foreach i $composeHeaderList {set mh(O_$i) 0}
regsub -all -- - [string tolower $option(compose_headers)] _ vars
foreach i $vars {set mh(O_$i) 1}
set mh(request_dsn) $option(dsn_request)
if {![info exists mh(from)] || ![string length $mh(from)]} {set mh(from) $option(from)}
if {![info exists mh(reply_to)] || ![string length $mh(reply_to)]} {set mh(reply_to) $option(reply_to)}
set mh(redo) 0
set mh(save_to) ""
set mh(doWrap) 1
set mh(doIndent) 1
set mh(font) [GetFont $option(charset) 0 {}]
set mh(closing) 0
set mh(copy_attached) $option(copy_attached)
if ![info exists mh(pgp_sign)] {set mh(pgp_sign) $option(pgp_sign)
set mh(pgp_encrypt) $option(pgp_encrypt)}
set w .$handler
set mh(toplevel) $w
toplevel $w
wm title $w $t(compose_name)
wm iconname $w $t(compose_name)
FindAccelerators a {file edit headers extra admin}
frame $w.menu -relief raised -bd 1
set m $w.menu.file.m
menubutton $w.menu.file -menu $m -text $t(file) -underline $a(file)
menu $m
$m add command -label $t(insert_file)... -command "ComposeInsertFile $handler"
set b($m,[$m index end]) compose_insert_file
$m add separator
$m add checkbutton -label $t(automatic_wrap) -variable ${handler}(doWrap)
set b($m,[$m index end]) automatic_wrap
$m add checkbutton -label $t(automatic_indent) -variable ${handler}(doIndent)
set b($m,[$m index end]) automatic_indent
$m add separator
$m add command -label $t(abort) -command "ComposeBuildStruct $handler; DoCompose2 $w $handler abort"
set b($m,[$m index end]) abort_compose
set mh(abort_menu) [list $m [$m index end]]
lappend mh(eEditBlock) $w.menu.file
set m $w.menu.edit.m
menubutton $w.menu.edit -menu $m -text $t(edit) -underline $a(edit)
menu $m -postcommand "ComposePostEdit $handler $m"
$m add command -label $t(undo) -command "ComposeUndo $handler"
set b($m,[$m index end]) undo
set mh(undo_menu) [list $m [$m index end]]
$m add separator
$m add command -label $t(cut) -command "ComposeEditOP $handler cut"
set b($m,[$m index end]) cut
set mh(cut_menu) [list $m [$m index end]]
$m add command -label $t(copy) -command "ComposeEditOP $handler copy"
set b($m,[$m index end]) copy
$m add command -label $t(paste) -command "ComposePaste $handler"
set b($m,[$m index end]) paste
set mh(paste_menu) [list $m [$m index end]]
$m add command -label $t(cut_all) -command "ComposeEditOP $handler cut_all"
set b($m,[$m index end]) cut_all
set mh(cut_all_menu) [list $m [$m index end]]
$m add command -label $t(copy_all) -command "ComposeEditOP $handler copy_all"
set b($m,[$m index end]) copy_all
$m add separator
$m add command -label $t(wrap_lines) -command "ComposeWrapSelection $handler"
set b($m,[$m index end]) wrap_lines
$m add separator
$m add command -label $t(run_through_command)... -command "ComposeSpecifyCmd $handler"
set b($m,[$m index end]) run_through_command
menubutton $w.menu.headers -menu $w.menu.headers.m -text $t(headers) -underline $a(headers)
set b($w.menu.headers) headers_menu
menu $w.menu.headers.m
foreach header $composeHeaderList {$w.menu.headers.m add checkbutton -label $t($header) -variable ${handler}(O_$header) -onvalue 1 -offvalue 0 -command "ComposeBuildHeaderEntries $handler"}
set m $w.menu.extra.m
menubutton $w.menu.extra -menu $m -text $t(extra) -underline $a(extra)
menu $m
$m add checkbutton -label $t(copy_attached_files) -variable ${handler}(copy_attached) -onvalue 1 -offvalue 0
set b($m,[$m index end]) copy_attached_files
$m add checkbutton -label $t(request_notification) -variable ${handler}(request_dsn) -onvalue 1 -offvalue 0
set b($m,[$m index end]) request_notification
if $option(pgp_enable) {$m add checkbutton -label $t(sign) -variable ${handler}(pgp_sign) -onvalue 1 -offvalue 0
set b($m,[$m index end]) pgp_sign
$m add checkbutton -label $t(encrypt) -variable ${handler}(pgp_encrypt) -onvalue 1 -offvalue 0
set b($m,[$m index end]) pgp_encrypt}
set m $w.menu.admin.m
menubutton $w.menu.admin -menu $m -text $t(admin) -underline $a(admin)
menu $m
$m add command -label $t(define_keys)... -command {KeyDef compose}
set b($m,[$m index end]) define_keys
$m add command -label $t(command_list)... -command CmdList
set b($m,[$m index end]) command_list
pack $w.menu.file $w.menu.edit $w.menu.headers $w.menu.extra $w.menu.admin -side left -padx 5
set mh(headerFrame) $w.h
frame $mh(headerFrame)
frame $w.body
scrollbar $w.body.scroll -relief sunken -bd 1 -takefocus 0 -command "$w.body.text yview" -highlightthickness 0
text $w.body.text -relief sunken -bd 1 -setgrid true -yscrollcommand "$w.body.scroll set" -wrap none -font $mh(font)
set b($w.body.text) compose_body
Size $w.body.text compose
pack $w.body.scroll -side right -fill y
pack $w.body.text -side left -expand yes -fill both
set mh(composeBody) $w.body.text
if [info exists mh(data)] {$w.body.text insert end $mh(data) noWrap
if {1 == $edit_text} {$w.body.text mark set insert end} {$w.body.text mark set insert 1.0}} {$w.body.text mark set insert 1.0}
if {1 == $add_sig} {set pos [$w.body.text index insert]
if {1 == [llength [info commands RatUP_Signature]]} {if [catch {RatUP_Signature $handler} text] {Popup "$t(sig_cmd_failed): $text"} {$w.body.text insert end "\n" {} "-- \n$text" noWrap}} elseif {![file isdirectory $option(signature)] && [file readable $option(signature)]} {set fh [open $option(signature) r]
$w.body.text insert end "\n" {} "-- \n[read -nonewline $fh]" noWrap
close $fh}
$w.body.text mark set insert $pos}
if [info exists mh(tag_range)] {$w.body.text tag delete noWrap
if [string length $mh(tag_range)] {eval $w.body.text tag add noWrap $mh(tag_range)}}
$w.body.text see insert
bindtags $w.body.text [list $w.body.text . all]
foreach e [bind Text] {bind $w.body.text $e [bind Text $e]}
bind $w.body.text <BackSpace> "+ComposeWrap $handler \[expr int(\[$w.body.text index insert\])\]"
bind $w.body.text <Delete> "+ComposeWrap $handler \[expr int(\[$w.body.text index insert\])\]"
bind $w.body.text <KeyPress> "RatTextInsert %W $handler %A {}"
bind $w.body.text <Return> "RatTextInsert %W $handler {\n} noWrap"
bind $w.body.text <Delete> "RatTextDelete %W $handler"
bind $w.body.text <BackSpace> "RatTextBackSpace %W $handler"
bind $w.body.text <ButtonRelease-2> {if {!$tkPriv(mouseMoved) || $tk_strictMotif} {%W mark set insert [tkTextClosestGap %W %x %y]
catch {%W insert insert [selection get -displayof %W] noWrap}
if {[%W cget -state] == "normal"} {focus %W}
%W see insert}}
if !$tk_strictMotif {bind $w.body.text <Control-k> "RatTextKillLine %W $handler"}
$w.body.text mark set undoStart 1.0
$w.body.text mark set undoEnd 1.0
$w.body.text mark gravity undoStart left
$w.body.text mark gravity undoEnd right
frame $w.attach
frame $w.attach.b
label $w.attach.b.label -text $t(attachments)
button $w.attach.b.attachf -text $t(attach_file) -command "Attach $handler"
set b($w.attach.b.attachf) attach_file
menubutton $w.attach.b.attachs -text $t(attach_special) -indicatoron 1 -menu $w.attach.b.attachs.m -relief raised
set b($w.attach.b.attachs) attach_special
if $option(pgp_enable) {menu $w.attach.b.attachs.m
$w.attach.b.attachs.m add command -label $t(attach_pgp_keys)... -command "AttachKeys $handler"
set b($w.attach.b.attachs.m) attach_keys
set b($w.attach.b.attachs.m,[$w.attach.b.attachs.m index end]) attach_keys} {$w.attach.b.attachs configure -state disabled}
button $w.attach.b.detach -text $t(detach) -state disabled -command "Detach $handler $w.attach.b.detach"
set b($w.attach.b.detach) detach
pack $w.attach.b.label -side left -padx 10
pack $w.attach.b.attachf $w.attach.b.attachs $w.attach.b.detach -side left -padx 5
frame $w.attach.list
scrollbar $w.attach.list.scroll -relief sunken -takefocus 0 -command "$w.attach.list.list yview" -highlightthickness 0
listbox $w.attach.list.list -yscroll "$w.attach.list.scroll set" -height 3 -relief sunken -bd 1 -font $mh(font) -exportselection false -highlightthickness 0 -selectmode extended
set b($w.attach.list.list) attachments
bind $w.attach.list.list <ButtonRelease-1> "if { 1 == \[llength \[%W curselection\]\]} { $w.attach.b.detach configure -state normal}"
pack $w.attach.list.scroll -side right -fill y
pack $w.attach.list.list -side left -expand 1 -fill both
pack $w.attach.b $w.attach.list -side top -fill x
set mh(attachmentListWindow) $w.attach.list.list
if ![info exists mh(attachmentList)] {set mh(attachmentList) {}} {foreach attachment $mh(attachmentList) {upvar #0 $attachment bp
if {[info exists bp(description)] && "" != $bp(description)} {set desc $bp(description)} {set desc "$bp(type)/$bp(subtype) : $bp(filename)"}
$mh(attachmentListWindow) insert end $desc}
$w.attach.b.detach configure -state normal}
frame $w.buttons
button $w.buttons.send -text $t(send) -command "DoCompose2 $w $handler send"
set b($w.buttons.send) send
lappend mh(eEditBlock) $w.buttons.send
menubutton $w.buttons.sendsave -text $t(send_save) -indicatoron 1 -menu $w.buttons.sendsave.m -relief raised -underline 0
set b($w.buttons.sendsave) sendsave
menu $w.buttons.sendsave.m -tearoff 0 -postcommand "RatSendSavePostMenu $w $w.buttons.sendsave.m $handler"
lappend mh(eEditBlock) $w.buttons.sendsave
button $w.buttons.hold -text $t(hold)... -command "ComposeHold $w $handler"
set b($w.buttons.hold) hold
lappend mh(eEditBlock) $w.buttons.hold
button $w.buttons.edit -text $t(external_editor) -command "ComposeEEdit $handler"
set b($w.buttons.edit) eedit
lappend mh(eEditBlock) $w.buttons.abort
button $w.buttons.abort -text $t(abort) -command "ComposeBuildStruct $handler; DoCompose2 $w $handler abort"
set b($w.buttons.abort) abort_compose
lappend mh(eEditBlock) $w.buttons.edit
pack $w.buttons.send $w.buttons.sendsave $w.buttons.hold -side left -padx 5
pack $w.buttons.abort -side right -padx 5
pack $w.buttons.edit -expand 1 -padx 5
set first [ComposeBuildHeaderEntries $handler]
pack $w.menu -side top -fill x
pack $mh(headerFrame) -side top -fill x -padx 5 -pady 5
pack $w.buttons -side bottom -fill x
pack $w.attach -side bottom -fill x -padx 5 -pady 5
pack $w.body -expand yes -fill both
if {1 == $edit_text} {focus $w.body.text} elseif [string length $first] {focus $first}
Place $w compose
lappend composeWindowList $handler
ComposeBind $handler
bind $mh(composeBody) <Destroy> "DoCompose2 $w $handler abort"
if {1 >= [llength [split $ratCurrentHost .]] && 0 == $option(force_send)} {$w.buttons.send configure -state disabled
$w.buttons.sendsave configure -state disabled
Popup $t(no_send_bad_host)}
return $handler}
proc DoCompose2 {w handler do} {global composeWindowList option ratCurrentHost b
upvar #0 $handler mh
if {0 == [info exists mh(closing)] || 1 == $mh(closing)} {return}
if ![string length $mh(save_to)] {set save_to [VFolderGetSave]
if [string length $save_to] {set mh(save_to) $save_to}}
set mh(do) $do
if {"send" == $do} {set mh(closing) 1
focus $mh(composeBody)
update
if {1 >= [llength [split $ratCurrentHost .]] && 0 == $option(force_send)} {bell $mh(toplevel)
set mh(closing) 0
return}
wm withdraw $w
if ![ComposeSend $handler] {set sent 1
set doRemove 0} {wm deiconify $w
set mh(closing) 0
return}} elseif {"abort" == $do} {set sent 0
set doRemove 1} elseif {"hold" == $do} {set sent 0
set doRemove 0}
if [info exists mh(body)] {ComposeFreeBody $mh(body) $doRemove}
set index [lsearch $composeWindowList $handler]
set composeWindowList [lreplace $composeWindowList $index $index]
if [winfo exists $w] {RecordPos $w compose
RecordSize $mh(composeBody) compose
bind $mh(composeBody) <Destroy> {}
foreach bn [array names b $w.*] {unset b($bn)}
destroy $w}
unset mh}
proc RatTextInsert {w h s t} {upvar #0 ${h}(doIndent) doIndent
upvar #0 $h hd
if {($s == "") ||([$w cget -state] == "disabled")} {return}
catch {if {[$w compare sel.first <= insert] && [$w compare sel.last >= insert]} {$w mark set undoStart sel.first
$w mark set undoEnd sel.last
set hd(undoText) [$w get sel.first sel.last]
set hd(undoTags) [$w tag ranges noWrap]
set hd(undoInsert) [$w index insert]
$w delete sel.first sel.last}}
$w insert insert $s $t
if {$doIndent && ![string compare "\n" $s]} {set lp [expr int([$w index insert])-1]
set wl [$w search -regexp {[^ 	]} $lp.0 $lp.end]
if [string length $wl] {$w insert insert [$w get $lp.0 $wl]} {$w delete $lp.0 $lp.end}}
ComposeWrap $h [expr int([$w index insert])]
$w see insert}
proc RatTextDelete {w h} {if {[$w tag nextrange sel 1.0 end] != "" && -1 != [lsearch -exact [$w tag names insert-1c] sel]} {upvar #0 $h hd
$w mark set undoStart sel.first
$w mark set undoEnd sel.last
set hd(undoText) [$w get sel.first sel.last]
set hd(undoTags) [$w tag ranges noWrap]
set hd(undoInsert) [$w index insert]
$w delete sel.first sel.last
ComposeWrap $h [expr int([$w index undoStart])]} {$w delete insert
$w see insert
ComposeWrap $h [expr int([$w index insert])]}}
proc RatTextBackSpace {w h} {if {[$w tag nextrange sel 1.0 end] != "" && -1 != [lsearch -exact [$w tag names insert-1c] sel]} {upvar #0 $h hd
$w mark set undoStart sel.first
$w mark set undoEnd sel.last
set hd(undoText) [$w get sel.first sel.last]
set hd(undoTags) [$w tag ranges noWrap]
set hd(undoInsert) [$w index insert]
$w delete sel.first sel.last
ComposeWrap $h [expr int([$w index undoStart])]} {$w delete insert-1c
$w see insert
ComposeWrap $h [expr int([$w index insert])]}}
proc RatTextKillLine {w h} {upvar #0 $h hd
if [$w compare insert == {insert lineend}] {set end insert+1c} {set end {insert lineend}}
$w mark set undoStart insert
$w mark set undoEnd $end
set hd(undoText) [$w get undoStart undoEnd]
set hd(undoTags) [$w tag ranges noWrap]
set hd(undoInsert) [$w index insert]
$w delete insert $end
ComposeWrap $h [expr int([$w index undoStart])]}
proc ComposeWrap {handler line} {upvar #0 ${handler}(composeBody) w
upvar #0 ${handler}(doWrap) doWrap
upvar #0 ${handler}(doIndent) doIndent
if !$doWrap {return $line}
set len [RatLL [$w get $line.0 $line.end]]
if {$len > 72} {set p [$w search -backwards -regexp " |\t|\n" $line.72]
if {$line != [lindex [split $p .] 0] || -1 != [lsearch [$w tag names $p] noWrap]} {return $line}
$w delete $p
$w insert $p \n
incr line
set ln [expr $line+1]
if {-1 == [lsearch [$w tag names $line.end] noWrap] && -1 == [lsearch [$w tag names $ln.0] noWrap] && 1 < [lindex [split [$w index $ln.end] .] 1]} {set wl [$w search -regexp {[^ 	]} $ln.0 $ln.end]
if {$doIndent && [string length $wl] && [string compare $ln.0 $wl]} {$w insert $line.0 [$w get $ln.0 $wl]
$w delete $ln.0 $wl}
$w insert $line.end " "
$w delete $line.end
ComposeWrap $handler $line} {set lp [expr $line-1]
set wl [$w search -regexp {[^ 	]} $lp.0 $lp.end]
if {$doIndent && [string length $wl] && [string compare $lp.0 $wl]} {$w insert $line.0 [$w get $lp.0 $wl]}}} elseif {$len > 1 && $len < 70} {set ln [expr $line+1]
if {-1 != [lsearch [$w tag names $line.end] noWrap] || -1 != [lsearch [$w tag names $ln.0] noWrap] || 1 > [lindex [split [$w index $ln.end] .] 1]} {return $line}
set wl [$w search -regexp {[^ 	]} $ln.0 $ln.end]
if {$doIndent && [string length $wl] && [string compare $ln.0 $wl]} {set ws [$w get $ln.0 $wl]} {set ws ""}
set nc [$w search -regexp {[^  ]} $ln.0 $ln.end]
while {[string length $nc] && 72 > $len+[RatLL [$w get $nc $ln.end]]
&& -1 == [lsearch [$w tag names $ln.0] noWrap]} {$w delete $ln.0 $nc
$w insert $ln.0 " "
$w delete $ln.0-1c
if [$w compare $ln.0 >= end] {return $line}
set len [RatLL [$w get $line.0 $line.end]]
set nc [$w search -regexp {[^  ]} $ln.0 $ln.end]}
if [string length $nc] {set we [$w search -backwards -regexp " |\t|\n" $nc+[expr 72-$len]c]
if {[$w compare $we <= $nc] || -1 != [lsearch [$w tag names $we] noWrap]} {return $line}
$w delete $we
$w insert $we "\n$ws"
$w delete $ln.0 $nc
$w insert $ln.0 " "
$w delete $ln.0-1c}
ComposeWrap $handler $ln}
return $line}
proc ComposeBind handler {upvar #0 $handler mh
foreach w "$mh(toplevel) $mh(composeBody)" {RatBind $w compose_key_send "DoCompose2 $mh(toplevel) $handler send"
RatBind $w compose_key_abort "ComposeBuildStruct $handler;  DoCompose2 $mh(toplevel) $handler abort" $mh(abort_menu)
RatBind $w compose_key_editor "ComposeEEdit $handler"
RatBind $w compose_key_undo "ComposeUndo $handler" $mh(undo_menu)
RatBind $w compose_key_cut "ComposeEditOP $handler cut" $mh(cut_menu)
RatBind $w compose_key_cut_all "ComposeEditOP $handler cut_all" $mh(cut_all_menu)
RatBind $w compose_key_paste "ComposePaste $handler" $mh(paste_menu)}}
proc RatSendSavePostMenu {w m handler} {global t
$m delete 0 end
VFolderBuildMenu $m 0 "RatSendSaveDo $w $handler" 1
$m add separator
$m add command -label $t(to_file)... -command "RatSendSaveDo $w $handler \[InsertIntoFile\]"
$m add command -label $t(to_dbase)... -command "RatSendSaveDo $w $handler \[InsertIntoDBase\]"}
proc RatSendSaveDo {w handler save_to} {upvar #0 $handler hd
if [string length $save_to] {set hd(save_to) $save_to
DoCompose2 $w $handler send}}
proc ComposeBuildHeaderEntries handler {global composeHeaderList composeAdrHdrList t b
upvar #0 $handler mh
foreach slave [grid slaves $mh(headerFrame)] {destroy $slave}
set first {}
set row 0
grid columnconfigure $mh(headerFrame) 1 -weight 1
foreach header $composeHeaderList {if {0 == $mh(O_$header)} {continue}
label $mh(headerFrame).${header}_label -text $t($header):
grid $mh(headerFrame).${header}_label -row $row -column 0 -sticky en
set w $mh(headerFrame).${header}_entry
if {-1 != [lsearch $composeAdrHdrList $header]} {ComposeBuildHE $w $handler ${handler}($header)} {entry $w -textvariable ${handler}($header) -font $mh(font)}
set b($w) compose_$header
set b($w.t) compose_$header
grid $w -row $row -column 1 -sticky we
incr row
if {0 == [string length $first]} {set first $mh(headerFrame).${header}_entry}}
return $first}
proc ComposeBuildStruct handler {upvar #0 $handler mh
global idCnt t option langCharset
set id body[incr idCnt]
upvar #0 $id bh
set bh(type) text
set bh(subtype) plain
set bh(filename) [RatTildeSubst $option(send_cache)/rat.[RatGenId]]
set fh [open $bh(filename) w 0600]
puts -nonewline $fh [$mh(composeBody) get 0.0 end]
close $fh
set bh(encoding) [RatGetEncoding $bh(filename)]
if {"7bit" != $bh(encoding)} {set bh(parameter) [list "charset $option(charset)"]}
if [info exists mh(content-description)] {if {0 < [string length $mh(content-description)]} {set bh(description) $mh(content-description)}}
set bh(removeFile) 1
if {0 == [llength $mh(attachmentList)]} {set bh(pgp_sign) $mh(pgp_sign)
set bh(pgp_encrypt) $mh(pgp_encrypt)
set mh(body) $id} {set mid body[incr idCnt]
upvar #0 $mid ph
set mh(body) $mid
set ph(pgp_sign) $mh(pgp_sign)
set ph(pgp_encrypt) $mh(pgp_encrypt)
set ph(type) multipart
set ph(subtype) mixed
set ph(encoding) 7bit
set ph(children) [linsert $mh(attachmentList) 0 $id]
set ph(removeFile) 0}}
proc ComposeSend handler {global option t composeAdrHdrList
upvar #0 $handler mh
if ![info exists mh(to)] {set mh(to) ""}
if ![info exists mh(cc)] {set mh(cc) ""}
if ![info exists mh(bcc)] {set mh(bcc) ""}
if {0 == [string length "$mh(to)$mh(cc)$mh(bcc)"]} {Popup $t(need_to)
return 1}
ComposeBuildStruct $handler
foreach e $composeAdrHdrList {if [info exists mh($e)] {if ![catch {RatAlias expand2 $mh($e)} out] {set mh($e) $out}}}
if [catch "RatSend $option(delivery_mode) $handler" message] {RatLog 4 $message
return 1} {return 0}}
proc ComposeEEdit handler {upvar #0 $handler mh
global option t idCnt
set ehandler compose_E[incr idCnt]
upvar #0 $ehandler eh
foreach block $mh(eEditBlock) {$block configure -state disabled}
set fname $option(tmp)/rat.[RatGenId]
set fh [open $fname w 0600]
puts -nonewline $fh [$mh(composeBody) get 0.0 end]
close $fh
$mh(composeBody) delete 0.0 end
$mh(composeBody) insert end "\n\n\n   $t(running_ext_editor)"
if {0 == [regsub "%s" $option(editor) $fname cmd]} {set cmd "$option(editor) $fname"}
trace variable eh(status) w "ComposeEEdit2 $handler $fname"
RatBgExec ${ehandler}(status) $cmd}
proc ComposeEEdit2 {handler fname name1 name2 op} {upvar #0 $handler mh
if [info exists mh] {$mh(composeBody) delete 0.0 end
set fh [open $fname r]
while {-1 != [gets $fh line]} {$mh(composeBody) insert end "$line\n"}
close $fh
catch "file delete -force -- $fname"
foreach block $mh(eEditBlock) {$block configure -state normal}}
trace vdelete ${name1}($name2) w "ComposeEEdit2 $handler $fname"}
proc Attach handler {global idCnt t b valueFont option
upvar #0 $handler mh
set id attach[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
set oldFocus [focus]
toplevel $w
wm transient $w $mh(toplevel)
wm title $w $t(attach_file)
frame $w.chooser
set fh [FileSelectorCreate $w.chooser ${id}(filename) "set ${id}(done) 1" 0 1]
frame $w.buttons
button $w.buttons.ok -text $t(ok) -command "FileSelectorUpdate $fh 1"
button $w.buttons.cancel -text $t(cancel) -command "set ${id}(done) 0"
pack $w.buttons.ok $w.buttons.cancel -side left -expand 1
pack $w.buttons -side bottom -fill both
pack $w.chooser -fill both -expand 1
Place $w attach
grab $w
tkwait variable ${id}(done)
FileSelectorDone $fh
RecordPos $w attach
if {0 == $hd(done)} {destroy $w
focus $oldFocus
unset hd
return}
destroy $w
toplevel $w
wm transient $w $mh(toplevel)
wm title $w $t(attach_file)
set type [RatType $hd(filename)]
set hd(typestring) [lindex $type 0]
set hd(encoding) [lindex $type 1]
set hd(description) [file tail $hd(filename)]
frame $w.file
label $w.file.label -width 14 -anchor e -text $t(filename):
label $w.file.name -textvariable ${id}(filename) -anchor w -font $valueFont
pack $w.file.label $w.file.name -side left
frame $w.type
frame $w.type.r
label $w.type.typelabel -width 14 -anchor e -text $t(type):
menubutton $w.type.type -menu $w.type.type.m -anchor w -width 23 -textvariable ${id}(typestring) -relief raised -indicatoron 1
set b($w.type.type) type_menu
menu $w.type.type.m -tearoff 0
foreach type {{text {plain enriched}} {image {jpeg gif}} {audio {basic}} {video {mpeg}} {message {rfc822 partial external-body}} {application {octet-stream postscript}} {multipart {mixed alternative digest parallel}}} {set typename [lindex $type 0]
set submenu $w.type.type.m.$typename
$w.type.type.m add cascade -menu $submenu -label $typename
menu $submenu -tearoff 0
foreach s [lindex $type 1] {$submenu add command -label $s -command "set ${id}(typestring) $typename/$s"}
$submenu add command -label $t(other)... -command "SubtypeSpec ${id}(typestring) $typename $w"}
label $w.type.r.enclabel -anchor e -text $t(current_encoding):
menubutton $w.type.r.enc -menu $w.type.r.enc.m -anchor w -width 14 -textvariable ${id}(encoding) -relief raised -indicatoron 1
set b($w.type.r.enc) encoding_menu
menu $w.type.r.enc.m -tearoff 0
switch $hd(encoding) {8bit {set binary disabled
set bit7 disabled
set bit8 normal} binary {set binary normal
set bit7 disabled
set bit8 disabled} default {set binary normal
set bit7 normal
set bit8 normal}}
$w.type.r.enc.m add command -label 7bit -command "set ${id}(encoding) 7bit" -state $bit7
$w.type.r.enc.m add command -label 8bit -command "set ${id}(encoding) 8bit" -state $bit8
$w.type.r.enc.m add command -label binary -command "set ${id}(encoding) binary" -state $binary
$w.type.r.enc.m add command -label quoted-printable -command "set ${id}(encoding) quoted-printable" -state $bit7
$w.type.r.enc.m add command -label base64 -command "set ${id}(encoding) base64" -state $bit7
pack $w.type.typelabel $w.type.type -side left
pack $w.type.r.enclabel $w.type.r.enc -side left
pack $w.type.r -side right -padx 5
frame $w.desc
label $w.desc.label -width 14 -anchor e -text $t(description):
entry $w.desc.entry -width 65 -textvariable ${id}(description)
pack $w.desc.label $w.desc.entry -side left
set b($w.desc.entry) attach_description
frame $w.id
label $w.id.label -width 14 -anchor e -text $t(id):
entry $w.id.entry -width 65 -textvariable ${id}(id)
set b($w.id.entry) attach_id
pack $w.id.label $w.id.entry -side left
OkButtons $w $t(ok) $t(cancel) "set ${id}(done)"
pack $w.file $w.type $w.desc $w.id $w.buttons -side top -fill both -pady 2
Place $w attach2
grab $w
$w.desc.entry icursor 0
focus $w.desc.entry
tkwait variable ${id}(done)
if {1 == $hd(done)} {set type [split $hd(typestring) /]
set hd(type) [lindex $type 0]
set hd(subtype) [lindex $type 1]
set hd(removeFile) 0
if $mh(copy_attached) {set fname [RatTildeSubst $option(send_cache)/[RatGenId]]
if [catch {file copy -- $hd(filename) $fname} result] {Popup "$t(failed_to_make_copy): $result"} {set hd(filename) $fname
set hd(removeFile) 1}}
lappend mh(attachmentList) $id
if {"" != $hd(description)} {set desc $hd(description)} {set desc "$hd(typestring): $hd(filename)"}
$mh(attachmentListWindow) insert end $desc} {unset hd}
RecordPos $w attach2
foreach bn [array names b $w.*] {unset b($bn)}
destroy $w
focus $oldFocus}
proc SubtypeSpec {variable type topwin} {upvar #0 $variable var
global t idCnt valueFont
set id subtype[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
toplevel $w
wm transient $w $topwin
wm title $w $t(custom_type)
frame $w.type
label $w.type.label -width 10 -anchor e -text $t(type):
label $w.type.name -text $type -anchor w -font $valueFont
pack $w.type.label $w.type.name -side left
frame $w.subtype
label $w.subtype.label -width 10 -anchor e -text $t(subtype):
entry $w.subtype.entry -width 20 -textvariable ${id}(spec)
pack $w.subtype.label $w.subtype.entry -side left
frame $w.buttons
button $w.buttons.ok -text $t(ok) -command "set ${id}(done) 1"
button $w.buttons.cancel -text $t(cancel) -command "set ${id}(done) 0"
pack $w.buttons.ok $w.buttons.cancel -side left -expand 1
pack $w.type $w.subtype -side top -anchor w -padx 5
pack $w.buttons -side top -pady 10 -fill x
bind $w <Return> "set ${id}(done) 1"
bind $w.subtype.entry <Tab> "set ${id}(done) 1"
set oldFocus [focus]
Place $w subtypeSpec
grab $w
focus $w.subtype.entry
tkwait variable ${id}(done)
if {1 == $hd(done)} {set var $type/$hd(spec)}
RecordPos $w subtypeSpec
destroy $w
unset hd
focus $oldFocus}
proc AttachKeys handler {RatPGPGetIds AttachKeysDo $handler}
proc AttachKeysDo {handler ids} {global idCnt t option
upvar #0 $handler mh
foreach keyid $ids {set id attach[incr idCnt]
upvar #0 $id hd
set hd(type) application
set hd(subtype) pgp-keys
set hd(encoding) 7bit
set hd(description) "$t(pgp_key_for) $keyid"
set hd(filename) [RatTildeSubst $option(send_cache)/[RatGenId]]
set hd(removeFile) 1
set f [open $hd(filename) w]
puts $f [RatPGP extract $keyid]
close $f
lappend mh(attachmentList) $id
$mh(attachmentListWindow) insert end $hd(description)}}
proc Detach {handler button} {upvar #0 $handler mh
$button configure -state disabled
foreach element [lsort -integer -decreasing [$mh(attachmentListWindow) curselection]] {$mh(attachmentListWindow) delete $element
ComposeFreeBody [lindex $mh(attachmentList) $element] 1
set mh(attachmentList) [lreplace $mh(attachmentList) $element $element]}}
proc ComposeFreeBody {handler doRemove} {upvar #0 $handler bh
if {"multipart" == $bh(type)} {if [info exists bh(children)] {foreach body $bh(children) {ComposeFreeBody $body $doRemove}}}
if [info exists bh(removeFile)] {if {$doRemove && $bh(removeFile)} {catch {file delete -- $bh(filename)}}}
unset bh}
proc ComposeHold {mainW handler} {upvar #0 $handler mh
global idCnt t b
set id hold[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
set oldFocus [focus]
set hd(desc) ""
if [string length $mh(to)] {set hd(desc) "$t(to): $mh(to)   "}
if [string length $mh(subject)] {set hd(desc) "$hd(desc) $t(subject): $mh(subject)"}
toplevel $w
wm title $w $t(hold_message)
wm transient $w $mh(toplevel)
frame $w.desc
label $w.desc.label -width 10 -anchor e -text $t(description):
entry $w.desc.entry -width 80 -textvariable ${id}(desc)
pack $w.desc.label $w.desc.entry -side left
OkButtons $w $t(ok) $t(cancel) "set ${id}(done)"
pack $w.desc -side top -anchor w -padx 5 -pady 5
pack $w.buttons -side top -pady 5 -fill x
set b($w.desc.entry) hold_description
Place $w composeHold
grab $w
focus $w.desc.entry
tkwait variable ${id}(done)
if {1 == $hd(done)} {ComposeBuildStruct $handler
if ![catch [list RatHold insert $handler $hd(desc)] message] {DoCompose2 $mainW $handler hold} {Popup "$t(hold_failed); $message"}}
RecordPos $w composeHold
catch {focus $oldFocus}
unset b($w.desc.entry)
destroy $w
unset hd}
proc ComposeChoose {msg info} {global idCnt t b option defaultFont langCharset
set msgs [ComposeChooseDig [$msg body] $msg]
while {-1 != [set i [lsearch -exact $msgs {}]]} {set msgs [lreplace $msgs $i $i]}
if {1 == [llength $msgs]} {return $msgs}
set id cc[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
toplevel $w
wm title $w $t(reply_to)?
wm transient $w .
set mnum 0
set hd(choosed) $msg
label $w.label -text $info
pack $w.label -side top -fill x
frame $w.l -relief sunken -bd 1
canvas $w.l.canvas -yscrollcommand "$w.l.scroll set" -highlightthickness 0
scrollbar $w.l.scroll -relief sunken -bd 1 -command "$w.l.canvas yview" -highlightthickness 0
pack $w.l.scroll -side right -fill y
Size $w.l.canvas msgList
pack $w.l.canvas -expand 1 -fill both
frame $w.l.canvas.f
set elemId [$w.l.canvas create window 0 0 -anchor nw -window $w.l.canvas.f]
foreach m $msgs {set f $w.l.canvas.f.f$mnum
incr mnum
frame $f
radiobutton $f.r -value $m -variable ${id}(choosed)
text $f.t -relief flat -font $defaultFont
set width 0
set height 0
$f.t tag configure HeaderName -font [GetFont $langCharset 0 bold]
foreach h [$m headers full] {set header([string tolower [lindex $h 0]]) [lindex $h 1]}
foreach field [string tolower $option(show_header_selection)] {if [info exists header($field)] {regsub -all -- - $field _ n
if [info exists t($n)] {set name $t($n)} {set name $field}
$f.t insert end "$name: " HeaderName "$header($field)"
set length [lindex [split [$f.t index insert] .] 1]
if {$length >$width} {set width $length}
$f.t insert end "\n"
incr height}}
$f.t configure -width $width -height $height -state disabled
pack $f.r -side left -anchor n
pack $f.t
pack $f -side top -anchor w
set b($f.r) choose_msg
set b($f.t) choose_msg}
pack $w.l -side top -expand 1 -fill both
OkButtons $w $t(ok) $t(cancel) "set ${id}(done)"
pack $w.buttons -fill both -pady 5
Place $w composeChoose
set bbox [$w.l.canvas bbox $elemId]
eval {$w.l.canvas configure -scrollregion $bbox}
grab $w
tkwait variable ${id}(done)
RecordSize $w.l.canvas msgList
RecordPos $w composeChoose
destroy $w
if {1 == $hd(done)} {set r $hd(choosed)} {set r {}}
unset hd
return $r}
proc ComposeChooseDig {body msgs} {set type [$body type]
if ![string compare message/rfc822 [lindex $type 0]/[lindex $type 1]] {return [concat $msgs [$body message]]}
foreach child [$body children] {set type [$child type]
switch -glob [string tolower [lindex $type 0]/[lindex $type 1]] {message/rfc822 {set msg [$child message]
set msgs [concat $msgs $msg]
set msgs [ComposeChooseDig [$msg body] $msgs]} multipart/* {set msgs [ComposeChooseDig $child $msgs]}}}
return $msgs}
proc ComposeBuildHE {w handler textvariable} {global idCnt defaultFontWidth
upvar #0 $textvariable textvar
upvar #0 $handler mh
set handler compHE[incr idCnt]
upvar #0 $handler hd
frame $w
text $w.t -relief sunken -font $mh(font) -yscroll "$w.s set" -width 1 -height 1 -tabs [list [expr $defaultFontWidth*24] [expr $defaultFontWidth*48]]
scrollbar $w.s -relief sunken -command "$w.t yview" -highlightthickness 0
pack $w.t -side left -expand yes -fill x
set hd(scrollbar) $w.s
set hd(column) 1
set hd(lines) 1
set hd(varname) $textvariable
set hd(scroll) 0
set hd(width) 0
bind $w <FocusIn> "focus $w.t"
bind $w.t <Return> {focus [tk_focusNext %W]
break}
bind $w.t <Tab> {focus [tk_focusNext %W]
break}
bind $w.t <Shift-Tab> {focus [tk_focusPrev %W]
break}
bind $w.t <Shift-space> {}
bind $w.t <KeyRelease-comma> "ComposeHandleHE %W $handler"
bind $w.t <FocusOut> "ComposeHandleHE %W $handler"
bind $w.t <Destroy> "unset $handler"
bind $w.t <ButtonRelease-2> "ComposeHandleHE %W $handler"
bind $w.t <Control-l> "ComposeHandleHEAlias %W $handler"
bind $w.t <Configure> "ComposeHandleHEConfigure %W $handler %w"
if {[winfo cells $w.t] > 2} {$w.t tag configure error -foreground red} {$w.t tag configure error -underline 1}
if ![info exists textvar] {set textvar {}} {$w.t insert end $textvar}}
proc ComposeHandleHEConfigure {w handler pixwidth} {global defaultFontWidth
upvar #0 $handler hd
if ![info exists hd(borders)] {set hd(borders) [expr 2*([$w cget -borderwidth] +[$w cget -highlightthickness])]}
set width [expr ($pixwidth-$hd(borders))/$defaultFontWidth]
if {$width == $hd(width)} {return}
set hd(width) $width
if {$width > 60} {set cw [expr $width/3]
set hd(col1) $cw
set hd(col2) [expr $cw*2]
set hd(cols) 3} elseif {$width > 40} {set cw [expr $width/2]
set hd(col1) $cw
set hd(col2) $width
set hd(cols) 2} {set hd(col1) $width
set hd(col2) $width
set hd(cols) 1}
$w configure -tabs [list [expr $defaultFontWidth*$hd(col1)] [expr $defaultFontWidth*$hd(col2)]]
ComposeHandleHE $w $handler}
proc ComposeHandleHE {w handler} {upvar #0 $handler hd
upvar #0 $hd(varname) var
set var [string trim [$w get 1.0 end]]
if {$hd(col1) < 1} {return}
$w delete 1.0 end
set hd(column) 1
set hd(lines) 1
foreach adr [RatSplitAdr $var] {if ![string length $adr] {continue}
if [catch {RatAlias expand1 $adr} adr2] {set tag error} {set tag {}
set adr $adr2}
if {(2==$hd(column) && [expr $hd(width)-$hd(col1)] <= [string length $adr]) ||(3==$hd(column) && [expr $hd(width)-$hd(col2)] <= [string length $adr])} {$w insert end \n
incr hd(lines)
set hd(column) 1}
$w insert end $adr $tag , {}
set i [expr [string length $adr]/$hd(col1)+1]
incr hd(column) $i
if {$hd(cols) < $hd(column)} {$w insert end \n
incr hd(lines)
set hd(column) 1} {while {$i} {$w insert end \t
incr i -1}}}
if {[string length $var] && ![regexp {,$} $var]} {if {1 == $hd(column) && $hd(lines) > 1} {incr hd(lines) -1}
$w delete [$w search -backwards , end] end}
if {$hd(lines) > 4 && !$hd(scroll)} {pack $hd(scrollbar) -side right -fill y
$w configure -height 4
set hd(scroll) 1} elseif {$hd(lines) <= 4} {pack forget $hd(scrollbar)
$w configure -height $hd(lines)
set hd(scroll) 0}
$w see insert}
proc ComposeHandleHEAlias {w handler} {set alias [AliasChooser $w]
if [string length $alias] {if [string length [string trim [$w get 1.0 end]]] {$w insert end ,}
$w insert end $alias
ComposeHandleHE $w $handler}}
proc SendDeferred {} {global t ratDeferred deferred langCharset valueFont ratSenderSending
set w .deferred
if [winfo exists $w] {incr deferred(to_send) [RatSend sendDeferred]
return}
set deferred(w) $w
set deferred(sent) 0
set deferred(oldDeferred) $ratDeferred
toplevel $w
wm title $w $t(send_deferred)
frame $w.f
message $w.f.message -aspect 500 -text $t(sending_deferred)...
grid $w.f.message -columnspan 2
label $w.f.to_label -text $t(to_send): -anchor e
label $w.f.to_num -textvariable deferred(to_send) -font $valueFont
grid $w.f.to_label $w.f.to_num -sticky ew
label $w.f.sent_label -text $t(sent): -anchor e
label $w.f.sent_num -textvariable deferred(sent) -font $valueFont
grid $w.f.sent_label $w.f.sent_num -sticky ew
pack $w.f -padx 10 -pady 10
Place $w sendDeferred
trace variable ratDeferred w SendDeferredUpdate
trace variable ratSenderSending w SendDeferredUpdate
set deferred(to_send) [RatSend sendDeferred]
return $w}
proc SendDeferredUpdate {name1 name2 op} {global t ratDeferred deferred ratSenderSending
if ![string compare $name1 ratSenderSending] {if {1 == $ratSenderSending} {return}
RatSend init
return}
if {$ratDeferred < $deferred(oldDeferred)} {incr deferred(sent) 1
incr deferred(to_send) -1}
set deferred(oldDeferred) $ratDeferred
if {0 == $deferred(to_send) || 0 == $ratSenderSending} {RecordPos $deferred(w) sendDeferred
destroy $deferred(w)
trace vdelete ratDeferred w SendDeferredUpdate
trace vdelete ratSenderSending w SendDeferredUpdate}}
proc ComposeInsertFile handler {global idCnt t
upvar #0 $handler mh
set id insert[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
set oldFocus [focus]
toplevel $w
wm transient $w $mh(toplevel)
wm title $w $t(insert_file)
frame $w.chooser
set fh [FileSelectorCreate $w.chooser ${id}(filename) "set ${id}(done) 1" 0 1]
frame $w.buttons
button $w.buttons.ok -text $t(ok) -command "FileSelectorUpdate $fh 1"
button $w.buttons.cancel -text $t(cancel) -command "set ${id}(done) 0"
pack $w.buttons.ok $w.buttons.cancel -side left -expand 1
pack $w.buttons -side bottom -fill both
pack $w.chooser -fill both -expand 1
Place $w insert
grab $w
tkwait variable ${id}(done)
FileSelectorDone $fh
RecordPos $w insert
if $hd(done) {if [catch {open $hd(filename)} fh] {Popup "$t(failed_to_open_file): $fh"} {set mh(undoText) {}
$mh(composeBody) mark set undoStart insert
$mh(composeBody) mark set undoEnd insert
$mh(composeBody) insert insert [read $fh]
close $fh}}
destroy $w}
proc ComposePostEdit {handler m} {global cmdList cmdName cmdCmd t
upvar #0 $handler hd
if [info exists hd(undoText)] {set undo normal} {set undo disabled}
if $hd(redo) {set undoText $t(redo)} {set undoText $t(undo)}
set r [$hd(composeBody) tag ranges sel]
if {2 == [llength $r]} {set cutcopy normal} {set cutcopy disabled}
if [info exists hd(pasteText)] {set paste normal} {set paste disabled}
$m entryconfigure 1 -state $undo -label $undoText
$m entryconfigure 3 -state $cutcopy
$m entryconfigure 4 -state $cutcopy
$m entryconfigure 5 -state $paste
$m entryconfigure 9 -state $cutcopy
if ![info exist cmdList] {CmdRead} elseif {11 < [$m index end]} {$m delete 12 end}
foreach i $cmdList {$m add command -label $cmdName($i) -command "ComposeRunCmd $handler [list $cmdCmd($i)]"}}
proc ComposeUndo handler {upvar #0 $handler hd
if ![info exists hd(undoText)] {bell
return}
set hd(redoText) [$hd(composeBody) get undoStart undoEnd]
set hd(redoInsert) [$hd(composeBody) index insert]
set hd(redoTags) [$hd(composeBody) tag ranges noWrap]
$hd(composeBody) delete undoStart undoEnd
$hd(composeBody) insert undoStart $hd(undoText)
$hd(composeBody) mark set insert $hd(undoInsert)
if [info exists hd(undoTags)] {for {set i 0} {$i < [llength $hd(undoTags)]} {incr i 2} {$hd(composeBody) tag add noWrap [lindex $hd(undoTags) $i] [lindex $hd(undoTags) [expr $i+1]]}
set hd(undoTags) $hd(redoTags)}
set hd(undoText) $hd(redoText)
set hd(undoInsert) $hd(redoInsert)
if $hd(redo) {set hd(redo) 0} {set hd(redo) 1}}
proc ComposeEditOP {handler op} {upvar #0 $handler hd
global t
if {![string compare cut_all $op] || ![string compare copy_all $op]} {set start 1.0
set end end} {if {0 == [llength [$hd(composeBody) tag ranges sel]]} {bell
return}
set start sel.first
set end sel.last}
set hd(pasteText) [$hd(composeBody) get $start $end]
if {![string compare cut_all $op] || ![string compare cut $op]} {$hd(composeBody) mark set undoStart $start
$hd(composeBody) mark set undoEnd $end
set hd(undoText) $hd(pasteText)
set hd(undoInsert) [$hd(composeBody) index insert]
set hd(undoTags) [$hd(composeBody) tag ranges noWrap]
$hd(composeBody) delete $start $end}}
proc ComposePaste handler {upvar #0 $handler hd
if ![info exists hd(pasteText)] {bell
return}
$hd(composeBody) mark set undoStart insert
$hd(composeBody) mark set undoEnd insert
set hd(undoInsert) [$hd(composeBody) index insert]
set hd(undoText) {}
$hd(composeBody) insert insert $hd(pasteText)
$hd(composeBody) see insert}
proc ComposeWrapSelection handler {upvar #0 $handler hd
if {0 != [llength [$hd(composeBody) tag ranges sel]]} {set start "sel.first linestart"
set end "sel.last lineend"} {set start 1.0
set end end}
set hd(undoText) [$hd(composeBody) get $start $end]
set hd(undoTags) [$hd(composeBody) tag ranges noWrap]
set hd(undoInsert) [$hd(composeBody) index insert]
$hd(composeBody) mark set undoStart $start
$hd(composeBody) mark set undoEnd $end
$hd(composeBody) tag remove noWrap $start $end
set line [lindex [split [$hd(composeBody) index $start] .] 0]
while {[$hd(composeBody) compare $line.0 < $end]} {set line [ComposeWrap $handler $line]
incr line}}
proc ComposeSpecifyCmd handler {global idCnt t b defaultFont cmdArrayId cmdList cmdName cmdCmd
upvar #0 $handler mh
set id insert[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
set oldFocus [focus]
toplevel $w
wm transient $w $mh(toplevel)
wm title $w $t(run_through_command)
frame $w.s
checkbutton $w.s.but -text $t(save_as) -variable ${id}(doSave)
entry $w.s.entry -width 20 -textvariable ${id}(saveAs) -font $defaultFont
bind $w.s.entry <KeyRelease> "if {0 < \[string length ${id}(saveAs)\]} {  set ${id}(doSave) 1  } else {  set ${id}(doSave) 0  }"
label $w.s.label -text $t(command)
pack $w.s.label -side left -padx 5 -anchor s
pack $w.s.entry $w.s.but -side right -pady 5
set b($w.s.but) save_cmd_as
set b($w.s.entry) save_cmd_as
text $w.t -relief sunken -bd 1 -wrap word -setgrid 1 -font $defaultFont
Size $w.t giveCmd
set b($w.t) command_to_run_through
OkButtons $w $t(ok) $t(cancel) "set ${id}(done)"
pack $w.s -side top -anchor w -fill x
pack $w.t -side top -expand 1 -padx 5
pack $w.buttons -fill both -pady 5
Place $w giveCmd
focus $w.s.entry
grab $w
tkwait variable ${id}(done)
RecordPos $w giveCmd
if {1 == $hd(done)} {if $hd(doSave) {if [string length $hd(saveAs)] {lappend cmdList $cmdArrayId
set cmdName($cmdArrayId) $hd(saveAs)
set cmdCmd($cmdArrayId) [string trim [$w.t get 1.0 end]]
incr cmdArrayId
CmdWrite} {Popup $t(need_name)}}
ComposeRunCmd $handler [string trim [$w.t get 1.0 end]]}
destroy $w
unset hd}
proc ComposeRunCmd {handler cmd} {upvar #0 $handler hd
global option t
if {0 != [llength [$hd(composeBody) tag ranges sel]]} {set start sel.first
set end sel.last} {set start 1.0
set end end-1c}
set hd(undoText) [$hd(composeBody) get $start $end]
set hd(undoTags) [$hd(composeBody) tag ranges noWrap]
set hd(undoInsert) [$hd(composeBody) index insert]
set hd(cmdStart) [$hd(composeBody) index $start]
set hd(cmdEnd) [$hd(composeBody) index $end]
set hd(text) [$hd(composeBody) get 1.0 end-1c]
set name $option(tmp)/rat.[RatGenId]
set fh [open $name.in w]
puts $fh [$hd(composeBody) get $start $end]
close $fh
if [regexp {%s} $cmd] {regsub -all {%s} $cmd $name.in cmd} {set cmd "cat $name.in | $cmd >$name.out"}
$hd(composeBody) delete 1.0 end
$hd(composeBody) insert end "\n\n\n\t$t(command_is_running)..."
foreach block $hd(eEditBlock) {$block configure -state disabled}
$hd(composeBody) configure -state disabled
trace variable hd(status) w "ComposeRunCmdDone $handler $name"
if [catch {RatBgExec ${handler}(status) $cmd} result] {Popup "$t(command_failed): $result"}}
proc ComposeRunCmdDone {handler name name1 name2 op} {upvar #0 $handler hd
if [info exists hd] {foreach block $hd(eEditBlock) {$block configure -state normal}
$hd(composeBody) configure -state normal
$hd(composeBody) delete 1.0 end
$hd(composeBody) insert 1.0 $hd(text)
$hd(composeBody) mark set undoStart $hd(cmdStart)
$hd(composeBody) mark set undoEnd $hd(cmdEnd)
if {0 == $hd(status)} {$hd(composeBody) delete undoStart undoEnd
if [file readable $name.out] {set outfile $name.out} {set outfile $name.in}
set fh [open $outfile r]
$hd(composeBody) insert undoStart [read -nonewline $fh]
close $fh}}
catch {file delete -force -- $name.in $name.out}
trace vdelete $name1($name2) w "ComposeRunCmdDone $handler $name"}
proc CmdWrite {} {global option cmdArrayId cmdList cmdName cmdCmd
set f [open $option(ratatosk_dir)/commands w]
puts $f "set cmdArrayId $cmdArrayId"
puts $f "set cmdList [list $cmdList]"
foreach c $cmdList {puts $f "set cmdName($c) [list $cmdName($c)]"
puts $f "set cmdCmd($c) [list $cmdCmd($c)]"}
close $f}
proc CmdRead {} {global option cmdArrayId cmdList cmdName cmdCmd
if [file readable $option(ratatosk_dir)/commands] {source $option(ratatosk_dir)/commands} {set cmdArrayId 0
set cmdList {}}}
proc CmdList {} {global cmdList cmdName idCnt t b defaultFont
set id ccmd[incr idCnt]
upvar #0 $id hd
set w .$id
set oldFocus [focus]
set hd 0
toplevel $w
wm title $w $t(command_list)
frame $w.l
listbox $w.l.list -yscroll "$w.l.scroll set" -font $defaultFont -exportselection false -highlightthickness 0 -selectmode single -setgrid 1
scrollbar $w.l.scroll -command "$w.l.list yscroll" -highlightthickness 0
pack $w.l.scroll -side right -fill y
pack $w.l.list -expand 1 -fill both
Size $w.l.list cmdList
set b($w.l.list) saved_commands
frame $w.b
button $w.b.apply -text $t(apply) -command "CmdApply $w $id" -state disabled
button $w.b.delete -text $t(delete) -command "CmdDelete $w $id" -state disabled
button $w.b.close -text $t(close) -command "CmdClose $w $id"
pack $w.b.apply $w.b.delete $w.b.close -side top -pady 5 -padx 5
set b($w.b.apply) apply_changes_to_cmd
set b($w.b.delete) delete_command
set b($w.b.close) dismiss
text $w.t -relief sunken -bd 1 -wrap word -font $defaultFont -width 40 -height 4 -state disabled
set b($w.t) command_content
pack $w.t -side bottom
pack $w.b -side right -padx 5 -pady 5
pack $w.l -fill both -expand 1 -padx 5 -pady 5
if ![info exist cmdList] {CmdRead}
foreach c $cmdList {$w.l.list insert end $cmdName($c)}
bind $w.l.list <ButtonRelease-1> " $w.b.apply configure -state disabled;  $w.b.delete configure -state normal;  $w.t configure -state normal;  $w.t delete 1.0 end;  $w.t insert 1.0 \$cmdCmd(\[lindex \$cmdList \[%W index @%x,%y\]\])"
bind $w.t <KeyRelease> "CmdTextCheck $w"
Place $w cmdList}
proc CmdDelete {w handler} {global cmdList cmdName
upvar #0 $handler hd
set index [$w.l.list curselection]
unset cmdName([lindex $cmdList $index])
set cmdList [lreplace $cmdList $index $index]
set hd 1
$w.l.list delete 0 end
foreach c $cmdList {$w.l.list insert end $cmdName($c)}
$w.t delete 1.0 end
$w.t configure -state disabled
$w.b.apply configure -state disabled
$w.b.delete configure -state disabled}
proc CmdTextCheck w {global cmdList cmdCmd
if [string compare [$w.t get 1.0 end-1c] $cmdCmd([lindex $cmdList [$w.l.list curselection]])] {$w.b.apply configure -state normal} {$w.b.apply configure -state disabled}}
proc CmdApply {w handler} {global cmdList cmdCmd
upvar #0 $handler hd
set cmdCmd([lindex $cmdList [$w.l.list curselection]]) [$w.t get 1.0 end-1c]
$w.b.apply configure -state disabled
set hd 1}
proc CmdClose {w handler} {upvar #0 $handler hd
if {1 == $hd} {CmdWrite}
unset hd
destroy $w}
proc CheckHostName {} {global ratCurrentHost composeWindowList option
if {1 >= [llength [split $ratCurrentHost .]] && 0 == $option(force_send)} {set state disabled} {set state normal}
foreach hd $composeWindowList {upvar #0 ${hd}(toplevel) w
$w.buttons.send configure -state $state
$w.buttons.sendsave configure -state $state}}
