proc FixDbase {} {global fix_scale option t
if {0 != [RatDialog $t(upgrade_dbase) $t(old_dbase) {} 0 $t(continue) $t(abort)]} {exit 1}
wm withdraw .
set dir [RatTildeSubst $option(dbase_dir)]
FixOldDbase dir
set w .upgdbase
toplevel $w
wm title $w "Upgrade dbase"
scale $w.scale -length 6c -showvalue 0 -sliderlength 5 -variable fix_scale -orient horiz
pack $w.scale -side top -padx 5 -pady 5
Place $w fixDbase
set fh [open $dir/index.ver r]
gets $fh version
gets $fh entries
close $fh
set fix_scale 0
$w.scale configure -to $entries
set lock [open $dir/lock w]
puts $lock "Updating"
close $lock
set newIndex [open $dir/index.new w]
set oldIndex [open $dir/index r]
for {set fix_scale 0} {$fix_scale < $entries} {incr fix_scale} {update idletasks
for {set i 0} {$i < 14} {incr i} {gets $oldIndex line($i)}
set result $line(0)
regsub {@.+$} $result {} name
while {[regexp {[a-zA-Z][ 	]+[a-zA-Z]} $result match]} {regsub {[ 	]+} $match {,} subst
regsub $match $result $subst result}
puts -nonewline $newIndex $result
regsub {(, )+} $line(1) {} result
if [string length $result] {puts -nonewline $newIndex " ($result)"}
puts $newIndex ""
set result $line(2)
while {[regexp {[a-zA-Z][ 	]+[a-zA-Z]} $result match]} {regsub {[ 	]+} $match {,} subst
regsub $match $result $subst result}
puts -nonewline $newIndex $result
regsub {(, )+} $line(3) {} result
if [string length $result] {puts -nonewline $newIndex " ($result)"}
puts $newIndex ""
puts $newIndex $line(4)
puts $newIndex $line(5)
puts $newIndex $line(6)
puts $newIndex $line(7)
puts $newIndex [file size $dir/dbase/$line(13)]
set status ""
set msgFh [open $dir/dbase/$line(13) r]
while {[string length [gets $msgFh hline]]} {if {0 == [string length $hline]} {break}
if ![string compare status: [string tolower [lindex $hline 0]]] {set status [lindex $hline 1]
break}}
close $msgFh
puts $newIndex $status
if [string length $line(11)] {puts $newIndex [RatTime +100]} {puts $newIndex ""}
puts $newIndex $line(12)
regsub {[%,].+} $name {} fdir
if [file exists $dir/dbase/$fdir/.seq] {set seqFh [open $dir/dbase/$fdir/.seq r+]
set sequence [expr 1+[gets $seqFh]]
seek $seqFh 0
puts $seqFh $sequence
close $seqFh} {set sequence 0
if ![file isdirectory $dir/dbase/$fdir] {exec mkdir $dir/dbase/$fdir}
set seqFh [open $dir/dbase/$fdir/.seq w]
puts $seqFh $sequence
close $seqFh}
set modSequence ""
for {set i [expr [string length $sequence]-1]} {$i >= 0} {incr i -1} {set modSequence $modSequence[string index $sequence $i]}
set filename $fdir/$modSequence
puts $newIndex $filename
exec mv $dir/dbase/$line(13) $dir/dbase/$filename}
close $newIndex
close $oldIndex
set infoFH [open $dir/index.info w]
puts $infoFH "3 $entries"
close $infoFH
file delete -force -- $dir/index.ver
file delete -force -- $dir/index.changes
file delete -force -- $dir/index.read
exec mv $dir/index.new $dir/index
file delete -force -- $dir/lock
pack forget $w.scale
label $w.message -text "Looking for unlinked entries"
pack $w.message
update
set unlinkedList [exec find $dir/dbase -name *@* -print]
if [llength $unlinkedList] {global vFolderDef vFolderDefIdent vFolderStruct
foreach file $unlinkedList {exec cat $file >>[RatTildeSubst ~/UnlinkedMessages]
file delete -force -- $file}
destroy $w
RatDialog $t(unlinked_messages) "$t(unl_m1) [llength $unlinkedList] $t(unl_m2)" {} 0 $t(continue)
set vFolderDef($vFolderDefIdent) [list UnlinkedMessages file [RatTildeSubst ~/UnlinkedMessages]]
set vFolderStruct(0) [linsert $vFolderStruct(0) 0 [list vfolder $vFolderDefIdent UnlinkedMessages]]
incr vFolderDefIdent
VFolderWrite} {destroy $w}
wm withdraw .}
proc FixOldDbase dir {global option
if {0 == [file exists $dir/index]} {return}
set good 1
if {1 == [file exists $dir/index.read]} {if {0 < [file size $dir/index.read]} {set result [RatDialog "Dbase in use?" "I find a lock on the database. Are you running another copy of tkrat somewhere?" {} 1 Yes No]
if {$result == 0} {return} {set good 0
catch "file delete -force -- $dir/index.read"}}}
if {1 == [file exists $dir/index.lock]} {set good 0
catch "file delete -force -- $dir/index.lock"}
if {1 == [file exists $dir/index.changes]} {set good 0
catch "file delete -force -- $dir/index.changes"}
if {0 == [file exists $dir/index.ver]} {set good 0} {set fh [open $dir/index.ver r]
gets $fh version
gets $fh orig_entries
close $fh}
if {1 == $good} {scan [exec wc -l $dir/index] "%d" lines
if {[expr ($lines/14)*14] != $lines} {set good 0} {if {[expr $lines/14] != $orig_entries} {set good 0}}}
if {1 == $good} {return}
set w .dbc
toplevel $w
wm title $w Dbase
wm iconname $w Dbase
message $w.msg -text "Database corrupt. Fixing it..." -aspect 800
pack $w.msg -padx 10 -pady 10
Place $w fixDbase2
update
DoFixDbase $dir
destroy $w}
proc DoFixDbase dir {set entries 0
set in [open $dir/index r]
set out [open $dir/nindex w]
while {0 < [gets $in line(0)] && 0 == [eof $in]} {for {set i 1} {$i < 14} {incr i} {gets $in line($i)}
while {0 == [regexp /< $line(13)]} {for {set i 1} {$i < 14} {incr i} {if {1 == [regexp {^ |^	} $line($i)]} {set p [expr $i-1]
set line($p) "$line($p)$line($i)"
for {set j $i} {$j < 13} {incr j} {set line($j) $line([expr $j+1])}
gets $in line(13)}}
if {1 == [eof $in]} {tk_Dialog Error "Can't fix database, giving up" {} 0 Ok
exit}}
for {set i 0} {$i < 14} {incr i} {puts $out $line($i)}
incr entries
if {1 == [eof $in]} {tk_Dialog Error "Can't fix database, giving up" {} 0 Ok
exit}}
close $in
close $out
exec mv $dir/nindex $dir/index
set fh [open $dir/index.ver w]
puts $fh 2
puts $fh $entries
close $fh}
proc FixVFolderList {} {global vfolder_list vfolder_def vFolderStructIdent vFolderStruct vFolderDef vFolderDefIdent vFolderVersion option
set vFolderStructIdent 0
set vFolderStruct(0) {}
if ![info exists vfolder_list] {return}
FixVFolderStruct $vfolder_list
unset vfolder_list
set vFolderDefIdent 1
set vFolderDef(0) $option(default_folder)
set vFolderStruct(0) [linsert $vFolderStruct(0) 0 {vfolder 0 INBOX}]
foreach vf [array names vfolder_def] {if ![info exists vFolderDef($vf)] {continue}
if {$vf > $vFolderDefIdent} {set vFolderDefIdent $vf}
set l $vfolder_def($vf)
set n $vFolderDef($vf)
if ![string compare [lindex $l 0] file] {set vFolderDef($vf) [list $n file {} [lindex $l 1]]} {set l2 [lindex $l 2]
set vFolderDef($vf) [list $n dbase {} [lindex $l2 0] [lindex $l2 1] [string trimleft [lindex $l2 3] +]]}}
incr vFolderDefIdent
set vFolderVersion 4
VFolderWrite}
proc FixVFolderStruct content {global vFolderStructIdent vFolderStruct vFolderDef
set ident $vFolderStructIdent
incr vFolderStructIdent
foreach elem $content {if ![string compare [lindex $elem 1] dir] {lappend vFolderStruct($ident) [list struct [FixVFolderStruct [lindex $elem 2]] [lindex $elem 0]]} {set vFolderDef([lindex $elem 2]) [lindex $elem 0]
lappend vFolderStruct($ident) [list vfolder [lindex $elem 2] [lindex $elem 0]]}}
return $ident}
proc FixOldOptions {} {upvar #0 option newOption
source $newOption(ratatosk_dir)/ratatoskrc.gen
set changed 0
if [info exists option(show_header)] {set newOption(show_header_selection) $option(show_header)
set changed 1}
if [info exists option(reply_lead)] {set newOption(reply_lead) $option(reply_lead)
set changed 1}
if [info exists option(signature)] {set newOption(signature) $option(signature)
set changed 1}
if [info exists option(xeditor)] {set newOption(editor) $option(xeditor)
set changed 1}
if [info exists option(watcher_geom)] {set newOption(watcher_geometry) $option(watcher_geom)
set changed 1}
if [info exists option(printcmd)] {set newOption(print_command) $option(printcmd)
set changed 1}
if $changed {SaveOptions}
file delete -force [RatTildeSubst $newOption(ratatosk_dir)/ratatoskrc.gen]}
proc ScanAliases {} {global option t
set n 0
if [file readable ~/.mailrc] {incr n [ReadMailAliases ~/.mailrc $option(default_book)]}
if [file readable ~/.elm/aliases.text] {incr n [ReadElmAliases ~/.elm/aliases.text $option(default_book)]}
if [file readable ~/.addressbook] {incr n [ReadPineAliases ~/.addressbook $option(default_book)]}
if $n {Popup "$t(found_aliases) $n $t(num_aliases)."
foreach book $option(addrbooks) {if {$option(default_book) == [lindex $book 0]} {set file [lindex $book 2]
break}}
RatAlias save $option(default_book) $file}
set option(scan_aliases) 3
SaveOptions
AliasesPopulate}
proc AddImapPorts {} {global option vFolderDef
VFolderRead
foreach id [array names vFolderDef] {if [string compare imap [lindex $vFolderDef($id) 1]] {continue}
set spec [lindex $vFolderDef($id) 2]
regsub {(\{[^\{\}:]*)\}} $spec "\\1:$option(imap_port)\}" spec
set vFolderDef($id) [lreplace $vFolderDef($id) 2 2 $spec]}
VFolderWrite}
