proc AddFont {encoding size attributes name} {global fontList fontEncoding
set encoding [string tolower $encoding]
set def [list $encoding $size $attributes]
set fontList($def) $name
set fontEncoding($encoding) 1
if [regexp iso-8859- $encoding] {set def [list us-ascii $size $attributes]
set fontList($def) $name
set fontEncoding(us-ascii) 1
return 1}}
proc RemoveFonts name {global fontList
foreach f [array names fontList] {if [regexp -- $name $fontList($f)] {unset FontList($f)}}}
proc GetFont {encoding size attributes} {global fontList option
if [info exists fontList([list $encoding $size $attributes])] {return $fontList([list $encoding $size $attributes])}
set name {}
set equivalence 100
incr size $option(fontsize)
foreach font [array names fontList] {if ![RatEncodingCompat $encoding [lindex $font 0]] {continue}
set e [expr 4*abs([lindex $font 1]-$size)]
set attr [lindex $font 2]
foreach a $attributes {set i [lsearch -exact $attr $a]
if {-1 == $i} {incr e 2} {set attr [lreplace $attr $i $i]}}
incr e [llength $attr]
if {$e < $equivalence} {set equivalence $e
set name $fontList($font)
if {0 == $e} {return $name}}}
return $name}
proc RatSelectEncoding encoding {global fontEncoding option
if [info exists fontEncoding($encoding)] {return $encoding}
foreach e [array names fontEncoding] {if [RatEncodingCompat $encoding $e] {return $e}}
return $option(charset)}
