proc OptionsInit {} {global env option tkrat_version
set option(last_version) ""
set option(last_version_date) 0
set option(info_changes) 1
set option(language) en
set option(global_config_path) $env(CONFIG_DIR)
set option(ratatosk_dir) ~/.ratatosk
set option(dbase_dir) ~/.ratatosk/db
set option(dbase_backup) ~/.ratatosk/backup
set option(send_cache) ~/.ratatosk/send
set option(delivery_mode) direct
set option(expire_interval) 7
set option(hold_dir) ~/.ratatosk/hold
set option(userproc) ~/.ratatosk/userproc
set option(main_window_name) "TkRat v$tkrat_version"
set option(main_geometry) +0+50
set option(icon_name) "TkRat v$tkrat_version"
set option(default_folder) "INBOX file {} /var/spool/mail/$env(USER)"
set option(list_format) "%4S %6d  %-24n %4B %s"
set option(show_header) selected
set option(show_header_selection) {From Subject Date To CC Reply-To}
set option(prev_dir) 10
set option(permissions) 0600
set option(compose_geometry) +0+50
set option(compose_headers) {To Subject Cc}
set option(editor) "emacs %s"
set option(masquerade_as) {}
set option(domain) {}
set option(smtp_hosts) {localhost}
set option(sendprot) smtp
set option(sendprog) /usr/lib/sendmail
set option(sendprog_8bit) false
set option(charset) iso-8859-1
set option(reply_lead) {>}
set option(vfoldername_width) 15
set option(watcher_enable) 1
set option(watcher_time) {{std 30} {dbase 0}}
set option(watcher_geometry) -140+0
set option(watcher_name) Watcher
set option(watcher_max_height) 10
set option(watcher_font) 5x7
set option(watcher_show) new
set option(watcher_bell) 2
set option(watcher_format) "%4S %-24n %s"
set option(print_command) "lpr %s"
set option(print_header) selected
set option(tmp) /tmp
set option(no_subject) "Re: (no subject)"
set option(signature) ~/.signature
set option(folder_sort) folder
set option(attribution) "On %d, %n wrote:"
set option(forwarded_message) "------ Forwarded message ------"
set option(typetable) { {*text* text/plain}
			    {*GIF* image/gif}
			    {*JPEG* image/jpeg}
			    {*JPG* image/jpeg}
			    {"*8-bit u-law*" audio/basic}
			    {*PostScript* application/postscript}
			    {*data* application/octet-stream}}
set option(see_bable) 0
set option(scan_aliases) 0
set option(num_messages) 10
set option(lookup_name) true
set option(def_extype) remove
set option(def_exdate) +365
set option(chunksize) 100
set option(dsn_directory) ~/.ratatosk/DSN
set option(dsn_request) 0
set option(dsn_snarf_reports) 0
set option(dsn_expiration) 7
set option(dsn_verbose) {{failed notify} {delayed status} {delivered status} {relayed status} {expanded none}}
set option(start_selection) first_new
set option(log_timeout) 3
set option(reply_to) ""
set option(fontsize) 12
set option(folder_key_compose) <Key-m>
set option(folder_key_quit) <Control-Key-c>
set option(folder_key_nextu) <Key-Tab>
set option(folder_key_sync) <Control-Key-s>
set option(folder_key_update) <Control-Key-u>
set option(folder_key_delete) <Key-d>
set option(folder_key_undelete) <Key-u>
set option(folder_key_flag) <Key-g>
set option(folder_key_next) {<Key-Right> <Shift-Key-Down> <Key-n>}
set option(folder_key_prev) {<Key-Left> <Shift-Key-Up> <Key-p>}
set option(folder_key_replya) <Key-R>
set option(folder_key_replys) <Key-r>
set option(folder_key_forward_i) <Key-f>
set option(folder_key_forward_a) <Key-F>
set option(folder_key_home) {<Key-0> <Key-F27>}
set option(folder_key_bottom) {<Key-F33> <Key-End>}
set option(folder_key_pagedown) {<Key-space> <Key-F35> <Key-z>}
set option(folder_key_pageup) {<Key-BackSpace> <Key-F29> <Control-b>}
set option(folder_key_linedown) {<Key-Down>}
set option(folder_key_lineup) {<Key-Up>}
set option(folder_key_cycle_header) <Key-h>
set option(folder_key_find) <Key-l>
set option(compose_key_send) <Control-s>
set option(compose_key_abort) <Control-c>
set option(compose_key_editor) <Control-o>
set option(compose_key_undo) <Control-u>
set option(compose_key_cut) <Control-w>
set option(compose_key_cut_all) <Control-Shift-w>
set option(compose_key_paste) <Control-y>
set option(mail_steal) 1
set option(ms_netscape_pref_file) $env(HOME)/.netscape/preferences
set option(ms_netscape_mtime) 0
set option(keep_pos) 1
set option(from) {}
set option(use_from) 1
set option(smtp_verbose) 1
set option(smtp_reuse) 1
set option(color_set) {gray85 black}
set option(icon) normal
set option(expression_mode) basic
set option(iconic) 0
set option(compose_warn) 1
set option(message_llength) 14
set option(mailcap_path) {~/.mailcap:/etc/mailcap:/usr/etc/mailcap:/usr/local/etc/mailcap}
set option(terminal) "xterm -e sh -c"
set option(imap_port) 143
set option(smtp_timeout) 120
set option(force_send) 0
set option(skip_sig) true
if [info exists env(PGPPATH)] {set pgpdir $env(PGPPATH)} {set pgpdir ~/.pgp}
if {0 < [string length "$env(PGP)"] && 1 == [file readable $pgpdir/pubring.pgp] && 1 == [file readable $pgpdir/secring.pgp]} {set option(pgp_enable) 1} {set option(pgp_enable) 0}
set option(pgp_prog) $env(PGP)
set option(pgp_args) {}
set option(copy_attached) 1
set option(pgp_sign) 0
set option(pgp_encrypt) 0
set option(url_viewer) netscape
set option(netscape) netscape
set option(netscape_args) -install
set option(url_color) blue
set option(system_aliases) "System tkrat $env(CONFIG_DIR)/aliases"
set option(use_system_aliases) 1
set option(addrbooks) {{Personal tkrat ~/.ratatosk/aliases}}
set option(default_book) Personal
set option(browse) folder
set option(cache_pgp) 1
set option(cache_pgp_timeout) 300
set option(cache_passwd) 1
set option(cache_passwd_timeout) 300
set option(cache_conn) 1
set option(cache_conn_timeout) 10
set option(urlprot) {http shttp ftp news telnet}
set option(show_balhelp) 1
set option(balhelp_delay) 500
set option(msgfind_format) "%s%n%b%D"
set option(warn_tk80) 1
set option(expunge_on_close) 1}
proc OptionsRead {} {global option globalOption env
foreach dir $option(global_config_path) {if [file readable $dir/ratatoskrc] {source $dir/ratatoskrc}}
foreach name [array names option] {set globalOption($name) $option($name)}
if [file readable $option(ratatosk_dir)/ratatoskrc] {source $option(ratatosk_dir)/ratatoskrc}}
proc SaveOptions {} {global option globalOption
set message {#
# BEWARE of making changes to this file. It is automatically generated.
# You can change the values in this file via the preferences window. 
# This file can only contain "set option(<optname>) <value>" lines,
# everything else will be destroyed when the file is regenerated.
}
set fh [open $option(ratatosk_dir)/ratatoskrc w]
puts $fh $message
foreach name [array names globalOption] {if [string compare $option($name) $globalOption($name)] {puts $fh "set option($name) [list $option($name)]"}}
close $fh}
proc ReadUserproc {} {global option t
if [file readable $option(userproc)] {if [catch "source $option(userproc)" message] {Popup "$t(error_in_userproc): $message"}}}
proc InitFonts {} {AddFont iso-8859-1 8 {} *-courier-medium-r-normal-*-8-*-iso8859-1
AddFont iso-8859-1 8 {bold} *-courier-bold-r-normal-*-8-*-iso8859-1
AddFont iso-8859-1 8 {italic} *-courier-medium-o-normal-*-8-*-iso8859-1
AddFont iso-8859-1 8 {bold italic} *-courier-bold-o-normal-*-8-*-iso8859-1
AddFont iso-8859-1 10 {} *-courier-medium-r-normal-*-10-*-iso8859-1
AddFont iso-8859-1 10 {bold} *-courier-bold-r-normal-*-10-*-iso8859-1
AddFont iso-8859-1 10 {italic} *-courier-medium-o-normal-*-10-*-iso8859-1
AddFont iso-8859-1 10 {bold italic} *-courier-bold-o-normal-*-10-*-iso8859-1
AddFont iso-8859-1 12 {} *-courier-medium-r-normal-*-12-*-iso8859-1
AddFont iso-8859-1 12 {bold} *-courier-bold-r-normal-*-12-*-iso8859-1
AddFont iso-8859-1 12 {italic} *-courier-medium-o-normal-*-12-*-iso8859-1
AddFont iso-8859-1 12 {bold italic} *-courier-bold-o-normal-*-12-*-iso8859-1
AddFont iso-8859-1 14 {} *-courier-medium-r-normal-*-14-*-iso8859-1
AddFont iso-8859-1 14 {bold} *-courier-bold-r-normal-*-14-*-iso8859-1
AddFont iso-8859-1 14 {italic} *-courier-medium-o-normal-*-14-*-iso8859-1
AddFont iso-8859-1 14 {bold italic} *-courier-bold-o-normal-*-14-*-iso8859-1
AddFont iso-8859-1 18 {} *-courier-medium-r-normal-*-18-*-iso8859-1
AddFont iso-8859-1 18 {bold} *-courier-bold-r-normal-*-18-*-iso8859-1
AddFont iso-8859-1 18 {italic} *-courier-medium-o-normal-*-18-*-iso8859-1
AddFont iso-8859-1 18 {bold italic} *-courier-bold-o-normal-*-18-*-iso8859-1
AddFont iso-8859-1 24 {} *-courier-medium-r-normal-*-24-*-iso8859-1
AddFont iso-8859-1 24 {bold} *-courier-bold-r-normal-*-24-*-iso8859-1
AddFont iso-8859-1 24 {italic} *-courier-medium-o-normal-*-24-*-iso8859-1
AddFont iso-8859-1 24 {bold italic} *-courier-bold-o-normal-*-24-*-iso8859-1}
proc InitCharsetAliases {} {global charsetAlias option
set charsetAlias(bar) iso-8859-1
foreach dir $option(global_config_path) {if [file readable $dir/charsetAliases] {source $dir/charsetAliases}}
if [file readable $option(ratatosk_dir)/charsetAliases] {source $option(ratatosk_dir)/charsetAliases}}
