proc RatGetPGPPassPhrase {} {global idCnt t
set id pgpPass[incr idCnt]
set w .$id
upvar #0 $id hd
set oldFocus [focus]
toplevel $w
wm transient $w .
wm title $w $t(pgp_pass_phrase)
label $w.label -text "$t(pgp_pass_phrase):"
entry $w.entry -textvariable ${id}(phrase) -width 32 -show -
button $w.button_ok -text $t(ok) -command "set ${id}(done) ok"
button $w.button_cancel -text $t(abort) -command "set ${id}(done) abort"
grid $w.label $w.entry -pady 5 -padx 5
grid $w.button_ok $w.button_cancel
bind $w.entry <Return> "set ${id}(done) ok"
Place $w pgpPhrase
focus $w.entry
grab $w
tkwait variable ${id}(done)
RecordPos $w pgpPhrase
catch {focus $oldFocus}
destroy $w
set ret [list $hd(done) $hd(phrase)]
unset hd
return $ret}
proc RatPGPError error {global idCnt t
set id pgpProblem[incr idCnt]
set w .$id
upvar #0 $id hd
toplevel $w
wm transient $w .
wm title $w $t(pgp_problem)
frame $w.f
pack $w.f -padx 5 -pady 5 -fill both -expand 1
label $w.f.label -text "$t(pgp_problem):"
pack $w.f.label -side top -anchor w
frame $w.f.t -relief sunken -bd 1
scrollbar $w.f.t.scroll -relief sunken -command "$w.f.t.text yview" -highlightthickness 0
text $w.f.t.text -yscroll "$w.f.t.scroll set" -setgrid 1 -relief raised -bd 0 -highlightthickness 0
Size $w.f.t.text pgpError
pack $w.f.t.scroll -side right -fill y
pack $w.f.t.text -side left -expand yes -fill both
regsub -all "\a" $error {} errmsg
$w.f.t.text insert 1.0 $errmsg
$w.f.t.text configure -state disabled
pack $w.f.t -expand 1 -fill both
frame $w.f.b
button $w.f.b.retry -text $t(retry) -command "set ${id}(done) RETRY"
button $w.f.b.abort -text $t(abort) -command "set ${id}(done) ABORT"
pack $w.f.b.retry $w.f.b.abort -side left -expand 1 -pady 5
pack $w.f.b -side bottom -fill x
Place $w pgpError
tkwait variable ${id}(done)
RecordSize $w.f.t.text pgpError
RecordPos $w pgpError
destroy $w
set action $hd(done)
unset hd
return $action}
proc RatPGPGetIds {proc arg} {global idCnt t defaultFont
set id pgpGet[incr idCnt]
set w .$id
upvar #0 $id hd
set oldFocus [focus]
toplevel $w
wm title $w $t(select_keys)
set form "%4s %5s %8s  %10s   %s"
set l [format $form $t(type) $t(bits) $t(keyid) $t(date) $t(user_id)]
label $w.label -text $l -font $defaultFont
grid $w.label -sticky w
scrollbar $w.scroll -relief sunken -command "$w.list yview" -highlightthickness 0 -bd 1
listbox $w.list -yscroll "$w.scroll set" -font $defaultFont -exportselection false -highlightthickness 0 -selectmode multiple -setgrid true -bd 1
Size $w.list pgpGet
grid $w.list $w.scroll -sticky nsew
frame $w.buttons
button $w.buttons.ok -text $t(ok) -command "RatPGPGetIdsDone $w $id 1 [list $proc $arg]"
button $w.buttons.sel -text $t(select_all) -command "$w.list selection set 0 end"
button $w.buttons.unsel -text $t(deselect_all) -command "$w.list selection clear 0 end"
button $w.buttons.cancel -text $t(cancel) -command "RatPGPGetIdsDone $w $id 0 [list $proc $arg]"
pack $w.buttons.ok $w.buttons.sel $w.buttons.unsel $w.buttons.cancel -side left -expand 1
grid $w.buttons -columnspan 2 -sticky ew -pady 5
grid columnconfigure $w 0 -weight 1
grid rowconfigure $w 1 -weight 1
foreach key [RatPGP listkeys] {set l [format $form [lindex $key 0] [lindex $key 1] [lindex $key 2] [lindex $key 3] [lindex $key 4]]
$w.list insert end $l
lappend hd(ids) [lindex $key 4]}
Place $w pgpGet}
proc RatPGPGetIdsDone {w handler done proc arg} {upvar #0 $handler hd
global option
if $done {foreach s [$w.list curselection] {lappend ids [lindex $hd(ids) $s]}
$proc $arg $ids}
RecordPos $w pgpGet
RecordSize $w.list pgpGet
destroy $w
unset hd}
proc RatPGPAddKeys {keys {keyring ""}} {global idCnt option t
set id pgpInt[incr idCnt]
upvar #0 $id hd
set hd(fileName) $option(tmp)/rat.[RatGenId]
set f [open $hd(fileName) w]
puts $f $keys
close $f
set cmd "$option(pgp_prog) $option(pgp_args) -ka $hd(fileName) $keyring"
set cmd "$cmd; echo '$t(press_return_to_dismiss)'; read FOO"
RatBgExec ${id}(existStatus) "$option(terminal) \"$cmd\""
trace variable hd(existStatus) w RatPGPAddKeysDone}
proc RatPGPAddKeysDone {name1 name2 op} {upvar #0 $name1 hd
file delete -force -- $hd(fileName) &
unset hd}
