set GoodTypes {text/plain message/rfc822 image/gif}
set showParams(text/plain) {charset}
set showParams(message/external-body) {access-type site server name directory}
proc ShowNothing handler {$handler configure -state normal
$handler delete 0.0 end
$handler configure -state disabled}
proc Show {handler msg browse} {global option b langCharset
upvar #0 $handler fh msgInfo_$msg msgInfo
set fh(id) 0
set fh(current) $msg
set fh(sigstatus) pgp_none
set fh(pgpOutput) ""
set fh(browse) $browse
$handler configure -state normal
$handler delete 0.0 end
eval "$handler tag delete [$handler tag names]"
$handler tag configure HeaderName -font [GetFont $langCharset 0 bold]
$handler tag configure Center -justify center -spacing1 5m -spacing3 5m
if {4 < [winfo cells $handler]} {$handler tag configure URL -foreground $option(url_color) -underline 1
$handler tag configure Found -background #ffff80} {$handler tag configure URL -underline 1
$handler tag configure Found -borderwidth 2 -relief raised}
$handler tag bind URL <Enter> "$handler config -cursor hand2"
$handler tag bind URL <Leave> "$handler config -cursor xterm"
foreach slave [winfo children $handler] {destroy $slave}
if [info exists fh(show_cleanup_cmds)] {foreach clear $fh(show_cleanup_cmds) {eval $clear}
set fh(show_cleanup_cmds) {}}
foreach n [array names fh charset_*] {unset fh($n)}
set fh(lastType) ""
foreach bn [array names b $handler.*] {unset b($bn)}
ShowMessage 1 $handler $msg
BuildStructMenu $handler $msg
$handler mark set searched 1.0
$handler configure -state disabled
set msgInfo(pgp,signed_parts) $fh(signed_parts)
return [list $fh(sigstatus) $fh(pgpOutput)]}
proc InsertHeader {gtag w header {width 1}} {global t
upvar #0 $w fh
set hn [lindex $header 0]
regsub -all -- - [string tolower $hn] _ hni
if [info exists t($hni)] {set hn $t($hni)}
$w insert insert [format "%${width}s: " $hn] "HeaderName $gtag"
foreach h [lindex $header 1] {set charset [lindex $h 0]
if [info exists fh(charset_$charset)] {set tag $fh(charset_$charset)} {set font [GetFont $charset 0 {}]
if [string length $font] {set tag t[incr fh(id)]
set fh(charset_$charset) $tag
$w tag configure $tag -font $font}}
if [info exists tag] {$w insert insert [lindex $h 1] "$tag $gtag"
unset tag} {$w insert insert " ??? "}}
$w insert insert "\n" $gtag}
proc ShowMessage {first handler msg} {global option t
upvar #0 $handler fh msgInfo_$msg msgInfo
set tag t[incr fh(id)]
if ![info exists msgInfo(show,$msg)] {set msgInfo(show,$msg) 1}
if {0 == $first} {$handler tag bind $tag <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $msg\]"} {set fh(signed_parts) {}}
if ![string length $msg] {$handler insert insert "\[$t(empty_message)\]" $tag
return}
if {0 == $first} {$handler insert insert "\n" $tag}
switch $fh(show_header) {all {foreach h [$msg headers split] {InsertHeader $tag $handler $h}} selected {foreach h [$msg headers split] {set header([string tolower [lindex $h 0]]) [lindex $h 1]}
set length 5
foreach f $option(show_header_selection) {if {$length < [string length $f]} {set length [string length $f]}}
foreach f $option(show_header_selection) {set n [string tolower $f]
if [info exists header($n)] {InsertHeader $tag $handler [list $f $header($n)] $length}}} default {}}
if $fh(browse) {if ![info exists fh(browse,$msg)] {if {1 == $first} {set fh(browse,$msg) $fh(browse)} {set fh(browse,$msg) 0}}} {set fh(browse,$msg) 0}
if $fh(browse,$msg) {button $handler.download -text $t(show_body) -command "Show $handler $msg 0" -cursor top_left_arrow
$handler window create end -window $handler.download -padx 20 -pady 20
set fh(sigstatus) pgp_none
return}
set body [$msg body]
if ![info exists msgInfo(show,$body)] {set msgInfo(show,$body) 1}
if $msgInfo(show,$msg) {$handler insert insert "\n"
if ![info exists msgInfo(show,$body)] {set msgInfo(show,$body) 1}} {set msgInfo(show,$body) 0}
ShowBody $handler $body $msg
if {1 == $first && ![string compare pgp_good $fh(sigstatus)] && [string compare pgp_good [$body sigstatus]]} {set fh(sigstatus) pgp_part}}
proc ShowBody {handler body msg} {global option
upvar #0 $handler fh msgInfo_$msg msgInfo
if !$msgInfo(show,$body) {return}
if [string compare pgp_none [set sigstatus [$body sigstatus]]] {set fh(sigstatus) $sigstatus
lappend fh(signed_parts) $body
if [string length $fh(pgpOutput)] {set fh(pgpOutput) "$fh(pgpOutput)\n\n[$body getPGPOutput]"} {set fh(pgpOutput) [$body getPGPOutput]}}
set type [string tolower [$body type]]
set mtype [lindex $type 0]
if [string compare $mtype multipart] {if ![string compare $mtype $fh(lastType)] {frame $handler.f[incr fh(id)] -width 12c -height 2 -relief sunken -bd 2
$handler window create insert -window $handler.f$fh(id) -pady 10
$handler insert insert "\n"}
set fh(lastType) $mtype}
switch -glob [lindex $type 0]/[lindex $type 1] {text/plain {ShowTextPlain $handler $body $msg} text/* {ShowTextOther $handler $body $msg} multipart/alternative {ShowMultiAlt $handler $body $msg} multipart/* {ShowMultiMixed $handler $body $msg} message/rfc822 {ShowMessage 0 $handler [$body message]} message/delivery-status {ShowDSN $handler $body} image/gif {ShowImage $handler $body gif} application/pgp-keys {ShowPGPKeys $handler $body} application/pgp {ShowTextPlain $handler $body $msg} default {ShowDefault $handler $body}}}
proc ShowTextPlain {handler body msg} {global option b defaultFont
upvar #0 $handler fh msgInfo_$msg msgInfo
set tag t[incr fh(id)]
$handler tag bind $tag <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"
set action [$body getShowCharset]
if ![string compare good [lindex $action 0]] {$handler tag configure $tag -font [GetFont [lindex $action 1] 0 {}]
$handler insert insert [$body data false [lindex $action 1]] $tag} {global t
set w $handler.w[incr fh(id)]
frame $w -relief raised -bd 2 -cursor top_left_arrow
if [string length [$body description]] {label $w.desc -text "$t(description): [$body description]" -font $defaultFont
pack $w.desc -side top -anchor nw}
set charset [$body parameter charset]
label $w.type -text "$t(here_is_text) '$charset' $t(which_cant_be_shown)"
label $w.modlab -text $t(mode):
menubutton $w.mode -menu $w.mode.m -indicatoron 1 -relief raised -textvariable ${handler}(mode,$body)
set b($w.mode) howto_display
button $w.save -text $t(save_to_file) -command "SaveBody $body"
set b($w.save) save_bodypart
pack $w.type -side top -anchor w
pack $w.modlab $w.mode -side left
pack $w.save -side left -padx 20
set l 0
menu $w.mode.m -tearoff 0
foreach s {dont_show show_sevenbit show_all} {$w.mode.m add command -label $t($s) -command "ShowTextCharset $body $msg $handler $handler  $tag $s"
if {[string length $t($s)] > $l} {set l [string length $t($s)]
$w.mode configure -width $l}}
if ![info exists msgInfo(show,$body,how)] {set msgInfo(show,$body,how) show_sevenbit}
$handler window create insert -window $w -pady 5
foreach win [concat $w [pack slaves $w]] {bind $win <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"}
$handler insert insert "\n" $tag
$handler mark set ${body}_s insert
$handler mark set ${body}_e insert
$handler mark gravity ${body}_s left
$handler mark gravity ${body}_e right
ShowTextCharset $body $msg $handler $handler $tag $msgInfo(show,$body,how)}}
proc ShowTextCharset {body msg hd w tag mode} {upvar #0 $hd fh msgInfo_$msg msgInfo
global t
set oldState [$w cget -state]
$w configure -state normal
$w mark set oldInsert insert
$w delete ${body}_s ${body}_e
$w mark set insert ${body}_s
set fh(mode,$body) $t($mode)
set msgInfo(show,$body,how) $mode
switch $mode {show_sevenbit {$w insert insert [$body data false 7bit] $tag} show_all {$w insert insert [$body data false [$body parameter charset]] $tag}}
$w mark set insert oldInsert
$w configure -state $oldState}
proc ShowTextOther {handler body msg} {global t b defaultFont langCharset
upvar #0 $handler fh msgInfo_$msg msgInfo
set type [$body type]
set typename [string tolower [lindex $type 0]/[lindex $type 1]]
set mailcap [$body findShowCommand]
set width 0
set w $handler.w[incr fh(id)]
frame $w -relief raised -bd 2 -cursor top_left_arrow
if [string length [lindex $mailcap 4]] {if ![catch {image create bitmap $body.icon -file [lindex $mailcap 4]}] {label $w.icon -image $body.icon
pack $w.icon -side left}}
text $w.text -relief flat -cursor top_left_arrow
$w.text tag configure Bold -font [GetFont $langCharset 0 bold]
if [string length [$body description]] {set width [string length "$t(description): [$body description]"]
$w.text insert insert "$t(description): " Bold [$body description]\n}
if [string length [lindex $mailcap 3]] {set l [string length "$t(type_description): [lindex $mailcap 3]"]
if {$l > $width} {set width $l}
$w.text insert insert "$t(type_description): " Bold [lindex $mailcap 3]\n}
set typestring [string tolower [lindex $type 0]/[lindex $type 1]]
set size [RatMangleNumber [$body size]]
set l [string length "$t(here_is): $typestring ($size bytes)"]
if {$l > $width} {set width $l}
$w.text insert insert "$t(here_is): " Bold "$typestring  ($size bytes)" {}
$w.text configure -height [lindex [split [$w.text index end-1c] .] 0] -width $width -state disabled
pack $w.text -side top -anchor w
if [string length [lindex $mailcap 0]] {button $w.view_ext -text $t(view) -command "RunMailcap $body [list $mailcap]"
pack $w.view_ext -side left -padx 10}
if ![info exists msgInfo(show,$body,tp)] {if [string length [lindex $mailcap 0]] {set msgInfo(show,$body,tp) 0} {set msgInfo(show,$body,tp) 1}}
checkbutton $w.tp -text $t(view_as_text) -relief raised -variable msgInfo_${msg}(show,$body,tp) -command "ShowTextOtherDo $handler $body $msg" -padx 4 -pady 4
button $w.save -text $t(save_to_file) -command "SaveBody $body"
button $w.view_int -text $t(view_source) -command "ShowSource $body"
pack $w.tp $w.save $w.view_int -side left -padx 5
set b($w.tp) view_as_text
set b($w.save) save_bodypart
set b($w.view_int) view_source
$handler window create insert -window $w -padx 5 -pady 5
foreach win [concat $w [pack slaves $w]] {bind $win <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"}
$handler insert insert "\n"
$handler mark set ${body}_s insert
$handler mark set ${body}_e insert
$handler mark gravity ${body}_s left
$handler mark gravity ${body}_e right
ShowTextOtherDo $handler $body $msg}
proc ShowTextOtherDo {handler body msg} {upvar #0 $handler fh msgInfo_$msg msgInfo
$handler configure -state normal
$handler delete ${body}_s ${body}_e
$handler mark set insert ${body}_s
if $msgInfo(show,$body,tp) {ShowTextPlain $handler $body $msg}
$handler configure -state disabled}
proc ShowMultiAlt {handler body msg} {global GoodTypes
upvar #0 $handler fh msgInfo_$msg msgInfo
set found 0
if ![info exists msgInfo(alternated,$body)] {set msgInfo(alternated,$body) 1
set children [$body children]
foreach c $children {set msgInfo(show,$c) 0}
for {set i [expr [llength $children]-1]} {$i >= 0} {incr i -1} {set child [lindex $children $i]
set tc $child
set typelist [$child type]
while {1 == [regexp -nocase multipart [lindex $typelist 0]]} {set tc [lindex [$tc children] 0]
set typelist [$tc type]}
set type [string tolower [lindex $typelist 0]/[lindex $typelist 1]]
if {-1 != [lsearch $GoodTypes $type]} {set msgInfo(show,$child) 1
set found 1
break}}}
foreach child [$body children] {if !$found {set msgInfo(show,$child) 1}
ShowBody $handler $child $msg}}
proc ShowMultiMixed {handler body msg} {global option t
upvar #0 $handler fh msgInfo_$msg msgInfo
foreach child [$body children] {if ![info exists msgInfo(show,$child)] {set msgInfo(show,$child) $msgInfo(show,$msg)}
ShowBody $handler $child $msg}}
proc ShowImage {handler body subtype} {global option
upvar #0 $handler fh
set tag t[incr fh(id)]
set filename $option(tmp)/rat.[RatGenId]
set fid [open $filename w 0600]
$body saveData $fid 0 0
close $fid
switch $subtype {gif {if [catch {image create photo -format gif -file $filename} img] {Popup $img
ShowDefault $handler $body
return}}}
file delete -force -- $filename
set c [canvas $handler.c[incr fh(id)] -width [image width $img] -height [image height $img]]
$c create image 0 0 -image $img -anchor nw
$handler insert insert " " "Center $tag"
$handler window create insert -window $c
$handler insert insert "\n" $tag
lappend fh(show_cleanup_cmds) "image delete $img"
$handler tag bind $tag <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"
bind $c <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"}
proc ShowDSN {handler body} {global t
upvar #0 $handler fh
set tag t[incr fh(id)]
$handler tag bind $tag <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"
$handler insert insert \n $tag
set dsn [$body dsn]
foreach h [lindex $dsn 0] {set hn [lindex $h 0]
if [info exists t([string tolower $hn])] {set hn $t([string tolower $hn])}
$handler insert insert [format "%21s: " $hn] "$tag HeaderName"
$handler insert insert [lindex $h 1]\n $tag}
foreach r [lindex $dsn 1] {$handler insert insert \n $tag
foreach h $r {set hn [lindex $h 0]
if [info exists t([string tolower $hn])] {set hn $t([string tolower $hn])}
$handler insert insert [format "%21s: " $hn] "$tag HeaderName"
$handler insert insert [lindex $h 1]\n $tag}}
$handler insert insert \n $tag}
proc ShowPGPKeys {handler body} {global t b
upvar #0 $handler fh
set mailcap [$body findShowCommand]
set w $handler.w[incr fh(id)]
frame $w -relief raised -bd 2 -cursor top_left_arrow
if [string length [lindex $mailcap 4]] {if ![catch {image create bitmap $body.icon -file [lindex $mailcap 4]}] {label $w.icon -image $body.icon
pack $w.icon -side left}}
label $w.label -relief flat -text $t(embedded_pgp_keys)
pack $w.label -side top -anchor w
button $w.add -text $t(add_to_keyring) -command "RatPGP add \[$body data 0\]"
button $w.save -text $t(save_to_file) -command "SaveBody $body"
button $w.view_int -text $t(view_source) -command "ShowSource $body"
set b($w.add) add_to_keyring
set b($w.save) save_bodypart
set b($w.view_int) view_source
pack $w.add $w.save $w.view_int -side left -padx 5
$handler window create insert -window $w -padx 5 -pady 5
foreach win [concat $w [pack slaves $w]] {bind $win <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"}
$handler insert insert "\n"}
proc ShowDefault {handler body} {global t defaultFont langCharset
upvar #0 $handler fh
set type [$body type]
set typename [string tolower [lindex $type 0]/[lindex $type 1]]
set mailcap [$body findShowCommand]
set width 0
set w $handler.w[incr fh(id)]
frame $w -relief raised -bd 2 -cursor top_left_arrow
if [string length [lindex $mailcap 4]] {if ![catch {image create bitmap $body.icon -file [lindex $mailcap 4]}] {label $w.icon -image $body.icon
pack $w.icon -side left}}
text $w.text -relief flat -cursor top_left_arrow
$w.text tag configure Bold -font [GetFont $langCharset 0 bold]
if [string length [$body description]] {set width [string length "$t(description): [$body description]"]
$w.text insert insert "$t(description): " Bold [$body description]\n}
if [string length [lindex $mailcap 3]] {set l [string length "$t(type_description): [lindex $mailcap 3]"]
if {$l > $width} {set width $l}
$w.text insert insert "$t(type_description): " Bold [lindex $mailcap 3]\n}
set l [string length "$t(here_is): [string tolower [lindex $type 0]/[lindex $type 1]] ([RatMangleNumber [$body size]] bytes)"]
if {$l > $width} {set width $l}
$w.text insert insert "$t(here_is): " Bold "[string tolower [lindex $type 0]/[lindex $type 1]]" {} " ([RatMangleNumber [$body size]] bytes)"
$w.text configure -height [lindex [split [$w.text index end-1c] .] 0] -width $width -state disabled
pack $w.text -side top -anchor w
if [string length [lindex $mailcap 0]] {button $w.view_ext -text $t(view) -command "RunMailcap $body {$mailcap}"
set b($w.view_ext) run_mailcap
pack $w.view_ext -side left -padx 10}
button $w.save -text $t(save_to_file) -command "SaveBody $body"
button $w.view_int -text $t(view_source) -command "ShowSource $body"
set b($w.save) save_bodypart
set b($w.view_int) view_source
pack $w.save $w.view_int -side left -padx 5
$handler window create insert -window $w -padx 5 -pady 5
foreach win [concat $w [pack slaves $w]] {bind $win <3> "tk_popup $fh(struct_menu) %X %Y  \[lsearch \[set ${handler}(struct_list)\]  $body\]"}
$handler insert insert "\n"}
proc ShowHome handler {$handler yview moveto 0}
proc ShowBottom handler {$handler yview moveto 1}
proc ShowPageDown handler {$handler yview scroll 1 pages}
proc ShowPageUp handler {$handler yview scroll -1 pages}
proc ShowLineDown handler {$handler yview scroll 1 units}
proc ShowLineUp handler {$handler yview scroll -1 units}
proc SaveBody body {global idCnt t option
set id showSave[incr idCnt]
set w .$id
upvar #0 $id hd
set hd(done) 0
set oldFocus [focus]
if [regexp -nocase text [lindex [$body type] 0]] {set hd(convertNL) 1} {set hd(convertNL) 0}
toplevel $w
wm title $w $t(save_to_file)
set hd(name) [$body filename]
frame $w.chooser
set fh [FileSelectorCreate $w.chooser ${id}(name) "set ${id}(done) 1" 0 0]
checkbutton $w.localnl -text $t(convert_to_local_nl) -variable ${id}(convertNL)
frame $w.buttons
button $w.buttons.ok -text $t(ok) -command "FileSelectorUpdate $fh 1"
CreateModeMenu $w.buttons.mode $id $option(permissions)
button $w.buttons.cancel -text $t(cancel) -command "set ${id}(done) 0"
pack $w.buttons.ok $w.buttons.mode $w.buttons.cancel -side left -expand 1
pack $w.buttons -side bottom -fill x
pack $w.localnl -side bottom -anchor w -pady 5 -padx 5
pack $w.chooser -fill both -expand 1
Place $w saveBody
grab $w
tkwait variable ${id}(done)
if {1 == $hd(done)} {FileSelectorDone $fh
if [file exists $hd(name)] {set action [RatDialog $t(file_exists) "$hd(name) $t(already_exists)." {} 1 $t(overwrite) $t(cancel)]} {set action 0}
if {0 == $action} {set mode [GetMode $id]
if {0 == [catch [list open $hd(name) w $mode] fh]} {$body saveData $fh false $hd(convertNL)
close $fh
catch {exec chmod [format %#o $perm] $hd(name)}} {RatLog 4 "$t(save_failed): $fh"}}}
RecordPos $w saveBody
destroy $w
unset hd
focus $oldFocus}
proc BuildStructMenu {handler msg} {upvar #0 $handler fh
$fh(struct_menu) delete 0 end
foreach slave [winfo children $fh(struct_menu)] {destroy $slave}
set fh(struct_list) {}
if ![string length $msg] {return}
if $fh(browse,$msg) {return}
BuildStructEntry $handler $fh(struct_menu) $msg [$msg body] ""}
proc BuildStructEntry {handler m msg body preamble} {global b
upvar #0 $handler fh msgInfo_$msg msgInfo
if ![string length $body] {return}
lappend fh(struct_list) $body
set sm $m.m[incr fh(id)]
set typepair [$body type]
set type [string tolower [lindex $typepair 0]/[lindex $typepair 1]]
$m add cascade -label $preamble$type -menu $sm
set b($m,[$m index end]) bodypart_entry
menu $sm -tearoff 0 -disabledforeground [$m cget -activeforeground] -postcommand "PopulateStructEntry $handler $sm $msg $body $type"
switch -glob $type {message/rfc822 {set message [$body message]
set fh(struct_list) [lreplace $fh(struct_list) end end $message]
if [string length $message] {BuildStructEntry $handler $m $message [$message body] "$preamble  "}} multipart/* {foreach c [$body children] {BuildStructEntry $handler $m $msg $c "$preamble  "}}}}
proc PopulateStructEntry {handler m msg body type} {global t b showParams
upvar #0 $handler fh msgInfo_$msg msgInfo
$m delete 0 end
if [string length [$body description]] {$m add command -label [$body description] -state disabled}
set sigstatus [$body sigstatus]
if [string compare pgp_none $sigstatus] {$m add command -label "$t(signature): $t($sigstatus)" -state disabled}
if [$body encoded] {$m add command -label "$t(decoded)" -state disabled}
if [info exists showParams($type)] {set sp $showParams($type)
foreach param $sp {set value [$body parameter $param]
if [string length $param] {$m add command -label "$t($param): $value" -state disabled}}} {set sp {{}}}
$m add command -label "$t(size): [RatMangleNumber [$body size]]" -state disabled
$m add separator
if ![info exists msgInfo(show,$body)] {set msgInfo(show,$body) 1}
$m add checkbutton -label $t(show) -onvalue 1 -offvalue 0 -variable msgInfo_${msg}(show,$body) -command "Show $handler $fh(current) 0"
set b($m,[$m index end]) bodypart_show
$m add command -label $t(save_to_file)... -command "SaveBody $body"
set b($m,[$m index end]) bodypart_save
$m add command -label $t(view_source)... -command "ShowSource $body"
set b($m,[$m index end]) view_source}
proc RunMailcap {body mailcap} {global option t idCnt defaultFont
set id id[incr idCnt]
upvar #0 $id rm
set cmd [lindex $mailcap 0]
set rm(fileName) $option(tmp)/rat.[RatGenId]
if [regexp %s $cmd] {regsub -all %s $cmd $rm(fileName) cmd} {if [lindex $mailcap 1] {Popup "$t(cant_pipe): \"$cmd\""
unset rm
return}
set cmd "cat $rm(fileName) | $cmd"}
set f [open $rm(fileName) w]
$body saveData $f 0 0
close $f
if [lindex $mailcap 1] {RatBgExec ${id}(existStatus) "$option(terminal) $cmd"} elseif [lindex $mailcap 2] {set w .$id
toplevel $w
wm title $w $t(external_viewer)
text $w.text -yscroll "$w.scroll set" -relief sunken -bd 1 -setgrid 1 -font $defaultFont -highlightthickness 0
Size $w.text extView
scrollbar $w.scroll -relief sunken -bd 1 -command "$w.text yview" -highlightthickness 0
button $w.button -text $t(dismiss) -command "RecordPos $w extView;  RecordSize $w.text extView; destroy $w"
pack $w.button -side bottom -pady 5
pack $w.scroll -side right -fill y
pack $w.text -expand 1 -fill both
Place $w extView
$w.text insert insert [eval "exec $cmd"]
$w.text configure -state disabled
file delete -force -- $rm(fileName) &
unset rm
return} {RatBgExec ${id}(existStatus) $cmd}
trace variable rm(existStatus) w RunMailcapDone}
proc RunMailcapDone {name1 name2 op} {upvar #0 $name1 rm
file delete -force -- $rm(fileName) &
unset rm}
proc RatShowURL {url win tag x y} {global option
$win tag configure $tag -underline 1
update idletasks
if {-1 == [lsearch -exact [$win tag names @$x,$y] $tag]} {return}
switch $option(url_viewer) {RatUP {if [catch {RatUP_ShowURL $url} error] {Popup error}} netscape {if [catch {eval {exec $option(netscape)} $option(netscape_args) {-remote "openURL($url)"} >&/dev/null}] {if [catch {eval {exec $option(netscape)} $option(netscape_args) {$url} &} error] {Popup $error}}}}}
proc RatFindURL {t start end} {global option
set exp "([join $option(urlprot) |]):/+\[^ \n\t\"\>]+\[^ \n\t,\.\)>\'\"\]"
set found [$t search -nocase -regexp -count len $exp $start $end]
if [string length $found] {return [list $found $found+${len}c]} {return {}}}
proc RatScrollShow {t scrollw sfrac efrac} {$scrollw set $sfrac $efrac
if [$t compare searched >= @0,20000] {return}
upvar #0 $t fh
set start searched
set end [$t index @0,20000+1c+20l]
set result [RatFindURL $t $start $end]
while {[llength $result] == 2} {set tag t[incr fh(id)]
set s [lindex $result 0]
set e [lindex $result 1]
$t tag add URL $s $e
$t tag add $tag $s $e
regsub % [$t get $s $e] %% url
$t tag bind $tag <ButtonRelease-1> [list RatShowURL $url %W $tag %x %y]
$t tag bind $tag <1> "$t tag configure $tag -underline 0; update idletasks"
set result [RatFindURL $t $e $end]}
$t mark set searched $end}
