proc ShowSource body {global idCnt t showParams option defaultFont
set id sourceWin[incr idCnt]
set w .$id
toplevel $w
wm title $w $t(source)
set normal $defaultFont
set type [$body type]
set tstring [string tolower [lindex $type 0]/[lindex $type 1]]
frame $w.type
label $w.type.label -width 15 -anchor e -text $t(type):
label $w.type.value -text $tstring -font $normal
pack $w.type.label $w.type.value -side left
pack $w.type -side top -anchor w
if [string length [$body description]] {frame $w.desc
label $w.desc.label -width 15 -anchor e -text $t(description):
label $w.desc.value -text [$body description] -font $normal
pack $w.desc.label $w.desc.value -side left
pack $w.desc -side top -anchor w}
frame $w.size
label $w.size.label -width 15 -anchor e -text $t(size):
label $w.size.value -text [RatMangleNumber [$body size]] -font $normal
pack $w.size.label $w.size.value -side left
pack $w.size -side top -anchor w
set typepair [$body type]
set type [string tolower [lindex $typepair 0]/[lindex $typepair 1]]
if [info exists showParams($type)] {foreach p $showParams($type) {frame $w.p_$p
label $w.p_$p.label -width 15 -anchor e -text $t($p):
label $w.p_$p.value -text [$body paramete $p] -font $normal
pack $w.p_$p.label $w.p_$p.value -side left
pack $w.p_$p -side top -anchor w}}
frame $w.enc
label $w.enc.label -width 15 -anchor e -text $t(encoding):
label $w.enc.value -text [$body encoding] -font $normal
pack $w.enc.label $w.enc.value -side left
pack $w.enc -side top -anchor w
frame $w.text -relief sunken -bd 1
scrollbar $w.text.scroll -relief sunken -command "$w.text.text yview" -highlightthickness 0
text $w.text.text -yscroll "$w.text.scroll set" -setgrid true -wrap char -font $defaultFont -bd 0 -highlightthickness 0
Size $w.text.text source
pack $w.text.scroll -side right -fill y
pack $w.text.text -expand yes -fill both
pack $w.text -side top -expand yes -fill both
button $w.dismiss -text $t(dismiss) -command "RecordPos $w showSource;  RecordSize $w.text.text source; destroy $w"
button $w.save -text $t(save_to_file)... -command "SaveBody $body"
pack $w.save $w.dismiss -side left -expand 1 -pady 5
regsub -all "\r\n" [$body data true] "\n" data
$w.text.text insert end $data
Place $w showSource}
