proc WatcherInit handler {global b idCnt option
upvar #0 $handler fh
set w .w[incr idCnt]
set fh(watcher_w) $w
set fh(watcher_list) $w.list
toplevel $w
wm title $w $option(watcher_name)
frame $w.info
label $w.info.name -textvariable ${handler}(folder_name) -font $option(watcher_font) -relief raised -bd 1 -anchor w
label $w.info.size -textvariable ${handler}(watcher_size) -font $option(watcher_font) -width 11 -relief raised -bd 1
pack $w.info.size -side right
pack $w.info.name -fill x -expand 1
pack $w.info -side top -fill x -expand 1
scrollbar $w.scroll -relief raised -bd 1 -highlightthickness 0 -command "$w.list yview"
listbox $fh(watcher_list) -yscroll "$w.scroll set" -relief raised -bd 1 -font $option(watcher_font) -exportselection false -highlightthickness 0
set b($fh(watcher_list) watcher
Size $fh(watcher_list) watcher
pack $w.scroll -side right -fill y
pack $w.list -side left -expand 1 -fill both
set fh(watcher_list) $w.list
Place $w watcher
foreach but {<1> <B1-Motion> <ButtonRelease-1> <Shift-1> <Control-1> <B1-Leave> <B1-Enter> <space> <Select> <Control-Shift-space> <Shift-Select> <Control-slash> <Control-backslash>} {bind $w.list $but {break}}
bind $w.list <ButtonRelease-1> "WatcherWakeMaster $handler"
bind $w.info.name <ButtonRelease-1> "WatcherWakeMaster $handler"
bind $w.info.size <ButtonRelease-1> "WatcherWakeMaster $handler"
bind $w.list <ButtonRelease-3> "WatcherSleep $handler"
bind $w.info.name <ButtonRelease-3> "WatcherSleep $handler"
bind $w.info.size <ButtonRelease-3> "WatcherSleep $handler"
bind $w.info.name <Destroy> "unset ${handler}(watcher_w)"
wm withdraw $w}
proc WatcherSleep handler {upvar #0 $handler fh
if {[info exists fh(watcher_w)] && [winfo ismapped $fh(watcher_w)]} {wm withdraw $fh(watcher_w)
regsub {[0-9]+x[0-9]+} [wm geom $fh(watcher_w)] {} fh(watcher_geom)}}
proc WatcherDoRound {handler type} {global option t
upvar #0 $handler fh
if {[info exists fh(folder_handler)] && [$fh(folder_handler) update 0]} {if {1 == [llength [info commands RatUP_Bell]]} {if [catch {RatUP_Bell} text] {Popup "$t(bell_cmd_failed): $text"}} {for {set i 0} {$i < $option(watcher_bell)} {incr i} {after 200
bell}}
if {$option(watcher_enable) && ![winfo ismapped $fh(toplevel)]} {WatcherPopup $handler}
Sync $handler 0}
foreach timePair $option(watcher_time) {if ![string compare [lindex $timePair 0] $type] {set time [expr 1000*[lindex $timePair 1]]
set fh(after_id) [after $time WatcherDoRound $handler $type]}}}
proc WatcherPopup handler {global option
upvar #0 $handler fh
if ![info exists fh(watcher_w)] {WatcherInit $handler}
if [info exists fh(watcher_geom)] {wm geometry $fh(watcher_w) $fh(watcher_geom)}
$fh(watcher_list) delete 0 end
switch $option(watcher_show) {new {set fullList [$fh(folder_handler) list $option(watcher_format)]
set i 0
foreach elem [$fh(folder_handler) list %S] {if [regexp N $elem] {$fh(watcher_list) insert end [lindex $fullList $i]}
incr i}} default {eval "$fh(watcher_list) insert 0  [$fh(folder_handler) list $option(watcher_format)]"}}
set lines [$fh(watcher_list) size]
set height $option(watcher_max_height)
if {$lines > $height} {set lines $height
if {-1 == [lsearch -exact [pack slaves $fh(watcher_w)] $fh(watcher_w).scroll]} {pack $fh(watcher_w).scroll -side right -fill y}} elseif {-1 != [lsearch -exact [pack slaves $fh(watcher_w)] $fh(watcher_w).scroll]} {pack forget $fh(watcher_w).scroll}
if !$lines {set lines 1}
$fh(watcher_list) configure -height $lines
$fh(watcher_list) see [expr [$fh(watcher_list) size]-1]
set info [$fh(folder_handler) info]
set fh(watcher_size) "[lindex $info 1]/[RatMangleNumber [lindex $info 2]]"
wm deiconify $fh(watcher_w)}
proc WatcherWakeMaster handler {upvar #0 $handler fh
FolderSelectUnread $handler
wm deiconify $fh(toplevel)}
