#! /bin/sh
#
# Sample smtp-policy-db builder script.
#
# This merges following files from $MAILVAR/db/ directory:
#	smtp-policy.src
#	localnames	        ('= _localnames')
#	smtp-policy.relay       ('= _full_rights')
#	smtp-policy.mx	        ('= _relaytarget')
#	smtp-policy.spam        ('= _bulk_mail')
#	smtp-policy.spam.manual ('= _bulk_mail')
#
# These all together are used to produce files:  smtp-policy.$DBEXT
# The produced database retains the first instance of any given key.
#

#FLAG=
#while getopts n c; do
#  case $c in
#    n)       FLAG=$c;;
#    ?)       exit 2;;
#  esac
#done
#shift `expr $OPTIND - 1`

if [ "x$1" = "x-n" ]; then
    FLAG=n
    shift
fi
if [ "x$1" = "x?" ]; then
    exit 2
fi


ZCONFIG=/usr/local/etc/zmailer/zmailer.conf
. $ZCONFIG

umask 022

cd $MAILVAR/db

if [ ! -f smtp-policy.src ] ; then
	echo "No $MAILVAR/db/smtp-policy.src input file"
	exit 64 # EX_USAGE
fi

if [ f$FLAG != fn ]; then
    if [ -x $MAILBIN/smtp-policy-retrieve.pl ] ; then
	$MAILBIN/smtp-policy-retrieve.pl
    else
	if [ -x $MAILBIN/spamlist.py ] ; then
	    $MAILBIN/spamlist.py spamlist_sources > smtp-policy.spam.new && \
		mv  smtp-policy.spam.new smtp-policy.spam
	else
	    #
	    # Following IS NOT SAFE, if either produces errors, those
	    # go (usually) to the result file, and in the end the result
	    # OVERWRITES the "running"  smtp-policy.spam  file.
	    #
	    > smtp-policy.spam.new
	    lynx -source http://www.webeasy.com:8080/spam/spam_download_table \
		| sed -e '1,$s/^@/./' \
		>> smtp-policy.spam.new
	    lynx -source http://www.sprocket.com/Security/SpamDomains | \
		awk 'NF > 0 {printf ".%s\n",$1}' >> smtp-policy.spam.new
	    cat smtp-policy.spam.new | sed 's/^@//g' | tr "[A-Z]" "[a-z]" | \
		    sort | uniq > smtp-policy.spam.new2
	    if [ `grep -c cyberpromo smtp-policy.spam.new` -gt "0" ]; then
		mv smtp-policy.spam smtp-policy.spam.old
		mv smtp-policy.spam.new2 smtp-policy.spam
		rm -f smtp-policy.spam.new
	    else
	        echo "Hmm....something went wrong while updating the spam policy."
		echo "Please try again."
 		exit 1
	    fi
	fi
    fi
fi

# Fork off a subshell to do it all...
(
  # The basic boilerplate
  cat smtp-policy.src

  # Localnames
  cat localnames | \
  awk '/^#/{next;} NF >= 1 {printf "%s = _localnames\n",$1;}'

  # smtp-policy.relay
  # (Lists NETWORKS (NO DOMAINS!) that are allowed to use us as relay)
  # (well, actually it could also list e.g.: ".our.domain" if it would
  #  be fine to allow relaying from anybody whose IP address reverses to
  #  domain suffix ".our.domain")
  if [ -f smtp-policy.relay ] ; then
    cat smtp-policy.relay | \
    awk '/^#/{next;}
	{printf "%s  %s %s %s %s %s %s %s %s = _full_rights\n",$1,$2,$3,$4,$5,$6,$7,$8,$9;next;}'
  fi

  # smtp-policy.mx
  # (Lists domains that are allowed to use us as inbound MX relay for them)
  if [ -f smtp-policy.mx ] ; then
    cat smtp-policy.mx | \
    awk '/^#/{next;} NF >= 1 {printf "%s = _relaytarget\n",$1;}'
  fi

  # smtp-policy.spam
  # (Lists users, and domains that are known spam sources)
  # (We use file from "http://www.webeasy.com:8080/spam/spam_download_table"
  #  which is intended for QMAIL, and thus needs to be edited..)
  if [ -f smtp-policy.spam -o -f smtp-policy.spam.manual ] ; then
    ( if [ -f smtp-policy.spam ] ; then
	cat smtp-policy.spam
      fi
      if [ -f smtp-policy.spam.manual ] ; then
	cat smtp-policy.spam.manual
      fi ) | tr "[A-Z]" "[a-z]" | sed 's/^@//g' | sort | uniq | \
    awk '/^\[/{ # an address block to reject
	    printf "%s rejectnet +\n", $1;
	    next;
	}
	NF > 0 { # All other cases are usernames with their domains
	  printf "%s = _bulk_mail\n", $1;
	}'
  fi

# --------- end of subshell
) > smtp-policy.dat

umask 022 # Make sure the resulting db file(s) are readable by all

# Build the actual binary policy database (-p), and if the input
# has same key repeating, append latter data instances to the first
# one (-A):

$MAILBIN/makedb -A -p $DBTYPE smtp-policy-new smtp-policy.dat || exit $?

case $DBTYPE in
dbm)
	mv smtp-policy-new.dir  smtp-policy.dir
	mv smtp-policy-new.pag  smtp-policy.pag
	;;
ndbm)
	mv smtp-policy-new.dir  smtp-policy.dir
	mv smtp-policy-new.pag  smtp-policy.pag
	;;
gdbm)
	mv smtp-policy-new.gdbm smtp-policy.gdbm
	;;
btree)
	mv smtp-policy-new.db   smtp-policy.db
	;;
esac

exit 0
