
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Image2D;

@EXPORT_OK  = qw( conv2d med2d patch2d max2d_ind centroid2d cc8compt polyfill polyfillv rotnewsz rot2d bilin2d rescale2d );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   @ISA    = ( 'PDL::Exporter','DynaLoader' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Image2D ;





=head1 NAME

PDL::Image2D - Miscellaneous 2D image processing functions

=head1 DESCRIPTION

Miscellaneous 2D image processing functions - for want
of anywhere else to put them

=head1 SYNOPSIS

 use PDL::Image2D;

=cut







=head1 FUNCTIONS



=cut






=head2 conv2d

=for sig

  Signature: (a(m,n); kern(p,q); [o]b(m,n); int opt)

=for ref

2D convolution of an array with a kernel (smoothing)

For large kernels, using a FFT routine,
such as L<PDL::FFT::fftconvolve()|PDL::FFT/fftconvolve>,
will be quicker.

=for usage

 $new = conv2d $old, $kernel, {OPTIONS}

=for example

 $smoothed = conv2d $image, ones(3,3), {Boundary => Reflect}

=for options

 Boundary - controls what values are assumed for the image when kernel
            crosses its edge:
 	    => Default  - periodic boundary conditions 
                          (i.e. wrap around axis)
 	    => Reflect  - reflect at boundary
 	    => Truncate - truncate at boundary



=cut






sub PDL::conv2d {
   my $opt; $opt = pop @_ if ref($_[$#_]) eq 'HASH';
   die 'Usage: conv2d( a(m,n), kern(p,q), [o]b(m,n), {Options} )'
      if $#_<1 || $#_>2;
   my($a,$kern) = @_;
   my $c = $#_ == 2 ? $_[2] : PDL->null;
   &PDL::_conv2d_int($a,$kern,$c,
	(!(defined $opt && exists $$opt{Boundary}))?0:
	(($$opt{Boundary} eq "Reflect") +
	2*($$opt{Boundary} eq "Truncate")));
   return $c;
}



*conv2d = \&PDL::conv2d;




=head2 med2d

=for sig

  Signature: (a(m,n); kern(p,q); [o]b(m,n); int opt)

=for ref

2D median-convolution of an array with a kernel (smoothing)

Note: only points in the kernel E<gt>0 are included in the median, other
points are weighted by the kernel value (medianing lots of zeroes
is rather pointless)

=for usage

 $new = med2d $old, $kernel, {OPTIONS}

=for example

 $smoothed = med2d $image, ones(3,3), {Boundary => Reflect}

=for options

 Boundary - controls what values are assumed for the image when kernel
            crosses its edge:
 	    => Default  - periodic boundary conditions (i.e. wrap around axis)
 	    => Reflect  - reflect at boundary
 	    => Truncate - truncate at boundary



=cut






sub PDL::med2d {
   my $opt; $opt = pop @_ if ref($_[$#_]) eq 'HASH';
   die 'Usage: med2d( a(m,n), kern(p,q), [o]b(m,n), {Options} )'
      if $#_<1 || $#_>2;
   my($a,$kern) = @_;
   my $c = $#_ == 2 ? $_[2] : PDL->null;
   &PDL::_med2d_int($a,$kern,$c,
	(!(defined $opt && exists $opt->{Boundary}))?0:
	(($$opt{Boundary} eq "Reflect") +
	2*($$opt{Boundary} eq "Truncate")));
   return $c;
}



*med2d = \&PDL::med2d;




=head2 patch2d

=for sig

  Signature: (a(m,n); int bad(m,n); [o]b(m,n))

=for ref

patch bad pixels out of 2D images,

=for usage

 $patched = patch2d $data, $bad;

C<$bad> is a 2D mask array where 1=bad pixel 0=good pixel. Pixels are replaced by the average
of their non-bad neighbours.



=cut






*patch2d = \&PDL::patch2d;




=head2 max2d_ind

=for sig

  Signature: (a(m,n); [o]val(); int [o]x(); int[o]y())

=for ref

Return value/position of maximum value in 2D image

Contributed by Tim Jeness



=cut






*max2d_ind = \&PDL::max2d_ind;




=head2 centroid2d

=for sig

  Signature: (im(m,n); x(); y(); box(); [o]xcen(); [o]ycen())

=for ref

Refine a list of object positions in 2D image by centroiding in a box

C<$box> is the full-width of the box, i.e. the window
is C<+/- $box/2>.



=cut






*centroid2d = \&PDL::centroid2d;




=head2 cc8compt

=for sig

  Signature: (a(m,n); [o]b(m,n))


=for ref

Connected 8-component labeling of a binary image.

Connected 8-component labeling of 0,1 image - i.e. find seperate
segmented objects and fill object pixels with object number

=for example

 $segmented = cc8compt( $image > $threshold );



=cut






*cc8compt = \&PDL::cc8compt;




=head2 polyfill

=for sig

  Signature: (int [o,nc] im(m,n); float ps(two=2,np); int col())

=for ref

fill the area inside the given polygon with a given colour

This function works inplace, i.e. modifies C<im>.



=cut






*polyfill = \&PDL::polyfill;



=head2 polyfillv

=for ref

return the (dataflown) area of an image within a polygon

=for example

  # increment intensity in area bounded by $poly
  $im->polyfillv($pol)++; # legal in perl >= 5.6
  # compute average intensity within area bounded by $poly
  $av = $im->polyfillv($poly)->avg;

=cut

sub PDL::polyfillv {
  my ($im, $ps) = @_;
  my $msk = zeroes(long,$im->dims);
  polyfill($msk, $ps, 1);
  return $im->where($msk == 1);
}
*polyfillv = \&PDL::polyfillv;





=head2 rot2d

=for sig

  Signature: (im(m,n); float angle(); bg(); int aa(); [o] om(p,q))

=for ref

rotate an image by given C<angle>

=for example

  # rotate by 10.5 degrees with antialiasing, set missing values to 7
  $rot = $im->rot2d(10.5,7,1);

This function rotates an image through an C<angle> between -90 and + 90
degrees. Uses/doesn't use antialiasing depending on the C<aa> flag.
Pixels outside the rotated image are set to C<bg>.

Code modified from pnmrotate (Copyright Jef Poskanzer) with an algorithm based
on "A Fast Algorithm for General  Raster  Rotation"  by  Alan Paeth,
Graphics Interface '86, pp. 77-81.

Use the C<rotnewsz> function to find out about the dimension of the
newly created image

  ($newcols,$newrows) = rotnewsz $oldn, $oldm, $angle;



=cut






*rot2d = \&PDL::rot2d;




=head2 bilin2d

=for sig

  Signature: (I(n,m); O(q,p))

=for ref

Bilineary maps the first piddle in the second. The
interpolated values are actually added to the second
piddle which is supposed to be larger than the first one.



=cut






*bilin2d = \&PDL::bilin2d;




=head2 rescale2d

=for sig

  Signature: (I(n,m); O(q,p))

=for ref

The first piddle is rescaled to the dimensions of the second
(expandind or meaning values as needed) and then added to it.



=cut






*rescale2d = \&PDL::rescale2d;


;


=head1 AUTHORS

Copyright (C) Karl Glazebrook 1997 with additions by Robin Williams
(rjrw@ast.leeds.ac.uk) and Tim Jeness (timj@jach.hawaii.edu).
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL
distribution. If this file is separated from the PDL distribution,
the copyright notice should be included in the file.

=cut





# Exit with OK status

1;

