
=head1 NAME

PDL::PP::Dump -- dump pp_xxx calls to stdout

=head1 SYNOPSIS

   perl -MPDL::PP::Dump Basic/Ops/ops.pd

=head1 DESCRIPTION

The most basic PP script debugger thinkable.

=head1 AUTHOR

Christian Soeller <c.soeller@auckland.ac.nz> .

=cut

package PDL::PP::Dump;

use Exporter;
@ISA = Exporter;

@EXPORT = qw(pp_addhdr pp_addpm pp_bless pp_def pp_done pp_add_boot
                      pp_add_exported pp_addxs pp_add_isa pp_export_nothing
		      pp_core_importList pp_beginwrap pp_setversion pp_addbegin);

for (@EXPORT) {
  if ($_ !~ /pp_def/) {
    my $def = "sub $_ { print '".$_.q/('.(join ',',map("'$_'",@_)).");\n" }/;
#    print "defining =>\n$def\n";
    eval($def);
  }
}

sub pp_def {
   my($name,%hash) = @_;

   print "pp_def('$name',\n";
     foreach (keys(%hash)) {
       if ($_ =~ /(Generic)*Types/) {
        print "$_ => [" . join(',',@{$hash{$_}}) . "]\n";
       } else {
        print "$_ =>\n'".$hash{$_}."',\n";
       }
     }
  print ");\n";
}

1;
