
#
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Primitive;

@EXPORT_OK  = qw( sumover zcover andover bandover orover borover intover cumusumover prodover cumuprodover average medover oddmedover avg sum zcheck and band or bor min max median oddmedian any all minmax qsort qsorti axisvalues inner outer matmult innerwt inner2 inner2d inner2t minimum minimum_ind minimum_n_ind maximum maximum_ind maximum_n_ind minmaximum hclip lclip clip wtstat random randsym grandom assgn vsearch interpolate interpol one2nd which which_both where append histogram whistogram histogram2d whistogram2d crossp norm stats whichND fibonacci indadd );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;



   
   @ISA    = ( 'PDL::Exporter','DynaLoader' );
   push @PDL::Core::PP, __PACKAGE__;
   bootstrap PDL::Primitive ;





use PDL::Slices;
use Carp;

=head1 NAME

PDL::Primitive - primitive operations for pdl

=head1 DESCRIPTION

This module provides some primitive and useful functions defined
using PDL::PP and able to use the new indexing tricks.

See L<PDL::Indexing|PDL::Indexing> for how to use indices creatively.
For explanation of the signature format, see L<PDL::PP|PDL::PP>.

=head1 SYNOPSIS

 use PDL::Primitive;

=cut







=head1 FUNCTIONS



=cut






=head2 sumover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via sum to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the sum along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = sumover($b);

=for example

 $spectrum = sumover $image->xchg(0,1)




=cut






*sumover = \&PDL::sumover;




=head2 zcover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via != 0 to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the != 0 along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = zcover($b);

=for example

 $spectrum = zcover $image->xchg(0,1)




=cut






*zcover = \&PDL::zcover;




=head2 andover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via and to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the and along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = andover($b);

=for example

 $spectrum = andover $image->xchg(0,1)




=cut






*andover = \&PDL::andover;




=head2 bandover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via bitwise and to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the bitwise and along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = bandover($b);

=for example

 $spectrum = bandover $image->xchg(0,1)




=cut






*bandover = \&PDL::bandover;




=head2 orover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via or to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the or along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = orover($b);

=for example

 $spectrum = orover $image->xchg(0,1)




=cut






*orover = \&PDL::orover;




=head2 borover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via bitwise or to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the bitwise or along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = borover($b);

=for example

 $spectrum = borover $image->xchg(0,1)




=cut






*borover = \&PDL::borover;




=head2 intover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via integral to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the integral along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = intover($b);

=for example

 $spectrum = intover $image->xchg(0,1)

Notes:

For C<n E<gt> 3>, these are all C<O(h^4)> (like Simpson's rule), but are
integrals between the end points assuming the pdl gives values just at
these centres: for such `functions', sumover is correct to C<O(h)>, but
is the natural (and correct) choice for binned data, of course.



=cut






*intover = \&PDL::intover;




=head2 cumusumover

=for sig

  Signature: (a(n); int+ [o]b(n))


=for ref

Cumulative sum

This function calculates the cumulative sum
along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

The sum is started so that the first element in the cumulative sum
is the first element of the parameter.

=for usage

 $a = cumusumover($b);

=for example

 $spectrum = cumusumover $image->xchg(0,1)




=cut






*cumusumover = \&PDL::cumusumover;




=head2 prodover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via product to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the product along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = prodover($b);

=for example

 $spectrum = prodover $image->xchg(0,1)




=cut






*prodover = \&PDL::prodover;




=head2 cumuprodover

=for sig

  Signature: (a(n); int+ [o]b(n))


=for ref

Cumulative product

This function calculates the cumulative product
along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

The sum is started so that the first element in the cumulative product
is the first element of the parameter.

=for usage

 $a = cumuprodover($b);

=for example

 $spectrum = cumuprodover $image->xchg(0,1)




=cut






*cumuprodover = \&PDL::cumuprodover;




=head2 average

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via average to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the average along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = average($b);

=for example

 $spectrum = average $image->xchg(0,1)




=cut






*average = \&PDL::average;




=head2 medover

=for sig

  Signature: (a(n); [o]b(); [t]tmp(n))


=for ref

Project via median to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the median along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = medover($b);

=for example

 $spectrum = medover $image->xchg(0,1)




=cut






*medover = \&PDL::medover;




=head2 oddmedover

=for sig

  Signature: (a(n); [o]b(); [t]tmp(n))


=for ref

Project via oddmedian to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the oddmedian along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = oddmedover($b);

=for example

 $spectrum = oddmedover $image->xchg(0,1)



The median is sometimes not a good choice as if the array has
an even number of elements it lies half-way between the two
middle values - thus it does not always correspond to a data
value. The lower-odd median is just the lower of these two values
and so it ALWAYS sits on an actual data value which is useful in
some circumstances.
	


=cut






*oddmedover = \&PDL::oddmedover;



=head2 avg

=for ref

Return the average of all elements in a piddle

=for usage

 $x = avg($data);

=cut

*avg = \&PDL::avg;
sub PDL::avg {
	my($x) = @_; my $tmp;
	$x->clump(-1)->average($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 sum

=for ref

Return the sum of all elements in a piddle

=for usage

 $x = sum($data);

=cut

*sum = \&PDL::sum;
sub PDL::sum {
	my($x) = @_; my $tmp;
	$x->clump(-1)->sumover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 zcheck

=for ref

Return the check for zero of all elements in a piddle

=for usage

 $x = zcheck($data);

=cut

*zcheck = \&PDL::zcheck;
sub PDL::zcheck {
	my($x) = @_; my $tmp;
	$x->clump(-1)->zcover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 and

=for ref

Return the logical and of all elements in a piddle

=for usage

 $x = and($data);

=cut

*and = \&PDL::and;
sub PDL::and {
	my($x) = @_; my $tmp;
	$x->clump(-1)->andover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 band

=for ref

Return the bitwise and of all elements in a piddle

=for usage

 $x = band($data);

=cut

*band = \&PDL::band;
sub PDL::band {
	my($x) = @_; my $tmp;
	$x->clump(-1)->bandover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 or

=for ref

Return the logical or of all elements in a piddle

=for usage

 $x = or($data);

=cut

*or = \&PDL::or;
sub PDL::or {
	my($x) = @_; my $tmp;
	$x->clump(-1)->orover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 bor

=for ref

Return the bitwise or of all elements in a piddle

=for usage

 $x = bor($data);

=cut

*bor = \&PDL::bor;
sub PDL::bor {
	my($x) = @_; my $tmp;
	$x->clump(-1)->borover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 min

=for ref

Return the minimum of all elements in a piddle

=for usage

 $x = min($data);

=cut

*min = \&PDL::min;
sub PDL::min {
	my($x) = @_; my $tmp;
	$x->clump(-1)->minimum($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 max

=for ref

Return the maximum of all elements in a piddle

=for usage

 $x = max($data);

=cut

*max = \&PDL::max;
sub PDL::max {
	my($x) = @_; my $tmp;
	$x->clump(-1)->maximum($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 median

=for ref

Return the median of all elements in a piddle

=for usage

 $x = median($data);

=cut

*median = \&PDL::median;
sub PDL::median {
	my($x) = @_; my $tmp;
	$x->clump(-1)->medover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 oddmedian

=for ref

Return the oddmedian of all elements in a piddle

=for usage

 $x = oddmedian($data);

=cut

*oddmedian = \&PDL::oddmedian;
sub PDL::oddmedian {
	my($x) = @_; my $tmp;
	$x->clump(-1)->oddmedover($tmp=PDL->nullcreate($x) );
	return $tmp->at();
}



=head2 any

=for ref

Return true if any element in piddle set

Useful in conditional expressions:

=for example

 if (any $a>15) { print "some values are greater than 15\n" }

=cut

*any = \&or;
*PDL::any = \&PDL::or;

=head2 all

=for ref

Return true if all elements in piddle set

Useful in conditional expressions:

=for example

 if (all $a>15) { print "all values are greater than 15\n" }

=cut

*all = \&and;
*PDL::all = \&PDL::and;




=head2 minmax

=for ref

Returns an array with minimum, maximum of a piddle.

=for usage

 ($mn, $mx) = minmax($pdl);

Return C<$mn> as minimum, C<$mx> as maximum, C<$mn_ind> as the index of minimum and
C<$mx_ind> as the index of the maximum.

=for example

 perldl> $x = pdl [1,-2,3,5,0]
 perldl> ($min, $max) = minmax($x);
 perldl> p "$min $max\n";
 -2 5

=cut

*minmax = \&PDL::minmax;
sub PDL::minmax {
  my ($x)=@_; my $tmp;
  my @arr = $x->clump(-1)->minmaximum;
  return @arr[0,1];
}





=head2 qsort

=for sig

  Signature: (a(n); [o]b(n))


=for ref

Quicksort a vector into ascending order.

=for example

 print qsort random(10);



=cut






*qsort = \&PDL::qsort;




=head2 qsorti

=for sig

  Signature: (a(n); int [o]indx(n))


=for ref

Quicksort a vector and return index of elements in ascending order.

=for example

 $ix = qsorti $a;
 print $a->index($ix); # Sorted list



=cut






*qsorti = \&PDL::qsorti;




=head2 axisvalues

=for sig

  Signature: ([o,nc]a(n))


=for ref

Internal routine

C<axisvalues> is the internal primitive that implements 
L<axisvals|PDL::Basic/axisvals> 
and alters its argument.



=cut






*axisvalues = \&PDL::axisvalues;




=head2 inner

=for sig

  Signature: (a(n); b(n); [o]c(); )


=for ref

Inner product over one dimension

 c = sum_i a_i * b_i



=cut






*inner = \&PDL::inner;




=head2 outer

=for sig

  Signature: (a(n); b(m); [o]c(n,m); )

=for ref

outer product over one dimension

Naturally, it is possible to achieve the effects of outer
product simply by threading over the "C<*>"
operator but this function is provided for convenience.



=cut






*outer = \&PDL::outer;


=head2 matmult

=for sig

 Signature: (a(x,y),b(y,z),[o]c(x,z))

=for ref

Matrix multiplication

We peruse the inner product to define matrix multiplication
via a threaded inner product

=cut

  sub PDL::matmult {
    barf "Invalid number of arguments for matmult" if $#_ < 1;
    my ($a,$b,$c) = @_;
    while ($a->getndims < 2) {$a = $a->dummy(-1)} # promote if necessary
    while ($b->getndims < 2) {$b = $b->dummy(-1)}
    if(!defined $c) {$c = PDL->nullcreate($a)}
    $a->dummy(1)->inner($b->xchg(0,1)->dummy(2),$c);
    return $c;
  }

  *matmult = \&PDL::matmult;





=head2 innerwt

=for sig

  Signature: (a(n); b(n); c(n); [o]d(); )


=for ref

Weighted (i.e. triple) inner product

 d = sum_i a(i) b(i) c(i)



=cut






*innerwt = \&PDL::innerwt;




=head2 inner2

=for sig

  Signature: (a(n); b(n,m); c(m); [o]d())


=for ref

Inner product of two vectors and a matrix

 d = sum_ij a(i) b(i,j) c(j)

Note that you should probably not thread over C<a> and C<c> since that would be  
very wasteful. Instead, you should use a temporary for C<b*c>.



=cut






*inner2 = \&PDL::inner2;




=head2 inner2d

=for sig

  Signature: (a(n,m); b(n,m); [o]c())


=for ref

Inner product over 2 dimensions.

Equivalent to

 $c = inner($a->clump(2), $b->clump(2))



=cut






*inner2d = \&PDL::inner2d;




=head2 inner2t

=for sig

  Signature: (a(j,n); b(n,m); c(m,k); [t]tmp(n,k); [o]d(j,k)))

=for ref

Efficient Triple matrix product C<a*b*c>

Efficiency comes from by using the temporary C<tmp>. This operation only scales as
C<N**3> whereas threading using L<inner2|/inner2> would scale as C<N**4>.

The reason for having this routine is that you do not need to
have the same thread-dimensions for C<tmp> as for the other arguments,
which in case of large numbers of matrices makes this much more
memory-efficient.

It is hoped that things like this could be taken care of as a kind of
closures at some point.



=cut






*inner2t = \&PDL::inner2t;




=head2 minimum

=for sig

  Signature: (a(n); [o]c())


=for ref

Project via minimum to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the minimum along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = minimum($b);

=for example

 $spectrum = minimum $image->xchg(0,1)




=cut






*minimum = \&PDL::minimum;




=head2 minimum_ind

=for sig

  Signature: (a(n); int[o]c())

=for ref

Like minimum but returns the index rather than the value

=cut






*minimum_ind = \&PDL::minimum_ind;




=head2 minimum_n_ind

=for sig

  Signature: (a(n); int[o]c(m))

=for ref

Returns the index of C<m> minimum elements

=cut






*minimum_n_ind = \&PDL::minimum_n_ind;




=head2 maximum

=for sig

  Signature: (a(n); [o]c())


=for ref

Project via maximum to N-1 dimensions

This function reduces the dimensionality of a piddle
by one by taking the maximum along the 1st dimension.

By using L<xchg|PDL::Slices/xchg> etc. it is possible to use
I<any> dimension.

=for usage

 $a = maximum($b);

=for example

 $spectrum = maximum $image->xchg(0,1)




=cut






*maximum = \&PDL::maximum;




=head2 maximum_ind

=for sig

  Signature: (a(n); int[o]c())

=for ref

Like maximum but returns the index rather than the value

=cut






*maximum_ind = \&PDL::maximum_ind;




=head2 maximum_n_ind

=for sig

  Signature: (a(n); int[o]c(m))

=for ref

Returns the index of C<m> maximum elements

=cut






*maximum_n_ind = \&PDL::maximum_n_ind;



=cut
=head2 minmaximum

=for ref

Find minimum and maximum and their indices for a given piddle;

=for usage

 perldl> $a=pdl [[-2,3,4],[1,0,3]]
 perldl> ($min, $max, $min_ind, $max_ind)=minmaximum($a)
 perldl> p $min, $max, $min_ind, $max_ind
 [-2 0] [4 3] [0 1] [2 2]

See also L<minmax|/minmax>, which clumps the piddle together.

=cut




=head2 minmaximum

=for sig

  Signature: (a(n); [o]cmin(); [o] cmax(); int [o]cmin_ind(); int [o]cmax_ind())


=for ref

info not available


=cut






*minmaximum = \&PDL::minmaximum;




=head2 hclip

=for sig

  Signature: (a(); b(); [o] c())

=for ref

clip C<$a> by C<$b> (C<$b> is upper bound)

=cut




sub PDL::hclip {
   my ($a,$b) = @_;
   my $c;
   if ($a->is_inplace) {
       $a->set_inplace(0); $c = $a;
   } elsif ($#_ > 1) {$c=$_[2]} else {$c=PDL->nullcreate($a)}
   &PDL::_hclip_int($a,$b,$c);
   return $c;
}


*hclip = \&PDL::hclip;




=head2 lclip

=for sig

  Signature: (a(); b(); [o] c())

=for ref

clip C<$a> by C<$b> (C<$b> is lower bound)

=cut




sub PDL::lclip {
   my ($a,$b) = @_;
   my $c;
   if ($a->is_inplace) {
       $a->set_inplace(0); $c = $a;
   } elsif ($#_ > 1) {$c=$_[2]} else {$c=PDL->nullcreate($a)}
   &PDL::_lclip_int($a,$b,$c);
   return $c;
}


*lclip = \&PDL::lclip;



=head2 clip

=for ref

Clip a piddle by (optional) upper or lower bounds.

=for usage

 $b = $a->clip(0,3);
 $c = $a->clip(undef, $x);

=cut

*clip = \&PDL::clip;
sub PDL::clip {
  my($a, $b, $c) = @_;
  my $d; if($a->is_inplace) {$a->set_inplace(0); $d = $a} 
  elsif($#_ > 2) {$d=$_[3]} else {$d = PDL->nullcreate($a)}
 if(defined $b) {
  	&PDL::_lclip_int($a,$b,$d);
	if(defined $c) {
		&PDL::_hclip_int($d,$c,$d);
	}
  } elsif(defined $c) {
	&PDL::_hclip_int($a,$c,$d);
  }
  return $d;
}





=head2 wtstat

=for sig

  Signature: (a(n); wt(n); avg(); [o]b(); int deg)

=for ref

Weighted statistical moment of given degree

This calculates a weighted statistic over the vector C<a>.
The formula is

 b() = (sum_i wt_i * (a_i ** degree - avg)) / (sum_i wt_i)



=cut






*wtstat = \&PDL::wtstat;



=head2 random

=for ref

Constructor which returns piddle of random numbers

=for usage

 $a = random([type], $nx, $ny, $nz,...);
 $a = random $b;

etc (see L<zeroes|PDL::Core/zeroes>).

This is the uniform distribution between 0 and 1 (assumedly
excluding 1 itself). The arguments are the same as C<zeroes>
(q.v.) - i.e. one can specify dimensions, types or give
a template.

=head2 randsym

=for ref

Constructor which returns piddle of random numbers

=for usage

 $a = randsym([type], $nx, $ny, $nz,...);
 $a = randsym $b;

etc (see L<zeroes|PDL::Core/zeroes>).

This is the uniform distribution between 0 and 1 (excluding both 0 and
1, cf L<random|/random>). The arguments are the same as C<zeroes> (q.v.) -
i.e. one can specify dimensions, types or give a template.

=cut


sub random { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->random : PDL->random(@_) }
sub PDL::random {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_random_int($x);
   return $x;
}





sub randsym { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->randsym : PDL->randsym(@_) }
sub PDL::randsym {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_randsym_int($x);
   return $x;
}






=head2 grandom

=for ref

Constructor which returns piddle of Gaussian random numbers

=for usage

 $a = grandom([type], $nx, $ny, $nz,...);
 $a = grandom $b;

etc (see L<zeroes|PDL::Core/zeroes>).

This is generated using the math library routine C<ndtri>.

Mean = 0, Stddev = 1

=cut

sub grandom { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->grandom : PDL->grandom(@_) }
sub PDL::grandom {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   use PDL::Math 'ndtri';
   $x .= ndtri(randsym($x));
   return $x;
}





=head2 assgn

=for sig

  Signature: (a(); [o]b())

=for ref

Plain numerical assignment. This is used to implement the ".=" operator

=cut






*assgn = \&PDL::assgn;




=head2 vsearch

=for sig

  Signature: (i(); x(n); int [o]ip())


=for ref

routine for searching 1D values i.e. step-function interpolation.

=for usage

 $inds = vsearch($vals, $xs);

Returns for each value of C<$val> the index of the least larger member
of C<$xs> (which need to be in increasing order). If the value is larger
than any member of C<$xs>, the index to the last element of C<$xs> is 
returned.

=for example

This function is useful e.g. when you have a list of probabilities
for events and want to generate indices to events:

 $a = pdl(.01,.86,.93,1); # Barnsley IFS probabilities cumulatively
 $b = random 20;
 $c = vsearch($b, $a); # Now, $c will have the appropriate distr.

It is possible to use the L<cumusumover|/cumusumover> function to obtain
cumulative probabilities from absolute probabilities.



=cut






*vsearch = \&PDL::vsearch;




=head2 interpolate

=for sig

  Signature: (xi(); x(n); y(n); [o] yi(); int [o] err())


=for ref

routine for 1D linear interpolation

=for usage

 ( $yi, $err ) = interpolate($xi, $x, $y)

Given a set of points C<($x,$y)>, use linear interpolation
to find the values C<$yi> at a set of points C<$xi>.

C<interpolate> uses a binary search to find the suspects, er...,
interpolation indices and therefore abscissas (ie C<$x>)
have to be I<strictly> ordered (increasing or decreasing). 
For interpolation at lots of
closely spaced abscissas an approach that uses the last index found as
a start for the next search can be faster (compare Numerical Recipes
C<hunt> routine). Feel free to implement that on top of the binary
search if you like. For out of bounds values it just does a linear
extrapolation and sets the corresponding element of C<$err> to 1,
which is otherwise 0.

See also L<interpol|/interpol>, which uses the same routine,
differing only in the handling of extrapolation - an error message
is printed rather than returning an error piddle.



=cut






*interpolate = \&PDL::interpolate;



=head2 interpol

=for sig

 Signature: (xi(); x(n); y(n); [o] yi())

=for ref

routine for 1D linear interpolation

=for usage

 $yi = interpol($xi, $x, $y)

C<interpol> uses the same search method as L<interpolate|/interpolate>,
hence C<$x> must be I<strictly> ordered (either increasing or decreasing).
The difference occurs in the handling of out-of-bounds values; here
an error message is printed.

=cut

# kept in for backwards compatability
sub interpol ($$$;$) {
    my $xi = shift;
    my $x  = shift;
    my $y  = shift;

    my $yi;
    if ( $#_ == 0 ) { $yi = $_[0]; }
    else            { $yi = PDL->null; }

    interpolate( $xi, $x, $y, $yi, my $err = PDL->null );
    print "some values had to be extrapolated\n"
	if any $err;

    return $yi if $#_ == -1;

} # sub: interpol()




=head2 one2nd

=for ref

Converts a one dimensional index piddle to a set of ND coordinates

=for usage

 @coords=one2nd($a, $indices)

returns an array of piddles containing the ND indexes corresponding to
the one dimensional list indices. The indices are assumed to correspond
to array C<$a> clumped using C<clump(-1)>. This routine is used in 
L<whichND|/whichND>,
but is useful on its own occasionally.

=for example

 perldl> $a=pdl [[[1,2],[-1,1]], [[0,-3],[3,2]]]; $c=$a->clump(-1)
 perldl> $maxind=maximum_ind($c); p $maxind;
 6
 perldl> print one2nd($a, maximum_ind($c))
 0 1 1
 perldl> p $a->at(0,1,1)
 3

=cut


*one2nd = \&PDL::one2nd;
sub PDL::one2nd {
  barf "Usage: one2nd $array $indices\n" if $#_ != 1;
  my ($a, $ind)=@_;
  my @dimension=$a->dims;
  my(@index);
  my $count=0;
  foreach (@dimension) {
    $index[$count++]=$ind % $_;
    $ind=long($ind/$_);
  }
  return @index;
}






=head2 which

=for sig

  Signature: (mask(n); int [o] inds(m))


=for ref

Returns piddle of indices of non-zero values.

=for usage

 $i = which($mask);

returns a pdl with indices for all those elements that are
nonzero in the mask. Note that mask really has to be 1-D (use C<clump(-1)>
if you need to work with ND-images)

If you want to return both the indices of non-zero values and the
complement, use the function L<which_both|/which_both>.

=for example

 perldl> $x = sequence(10); p $x
 [0 1 2 3 4 5 6 7 8 9]
 perldl> $indx = which($x>6); p $indx
 [7 8 9]



=cut






*which = \&PDL::which;




=head2 which_both

=for sig

  Signature: (mask(n); int [o] inds(m); int [o]notinds(q))


=for ref

Returns piddle of indices of non-zero values and their complement

=for usage

 ($i, $c_i) = which_both($mask);

This works just as which, but the complement of C<$i> will be in C<$c_i>.

=for example

 perldl> $x = sequence(10); p $x
 [0 1 2 3 4 5 6 7 8 9]
 perldl> ($small, $big) = which_both ($x >= 5); p "$small\n $big"
 [5 6 7 8 9]
 [0 1 2 3 4]



=cut






*which_both = \&PDL::which_both;


=head2 where

=for ref

Returns indices to non-zero values or those values from another piddle.

=for usage

 $i = $x->where($x+5 > 0); # $i contains elements of $x
                           # where mask ($x+5 > 0) is 1

Note: C<$i> is always 1-D, even if C<$x> is >1-D. The first argument
(the values) and the second argument (the mask) currently have to have
the same initial dimensions (or horrible things happen).

It is also possible to use the same mask for several piddles with
the same call:

 ($i,$j,$k) = where($x,$y,$z, $x+5>0);

There is also the following syntax, retained only for compatibility
with PDL versions < 1.99.
This use is deprecated, and will be removed
in the future.  Use L<which|/which> instead.

 $i = where($x > 0);       # indices to $x, equivalent to 'which()'

Note: the mask has to be 1-D. See the documentation for L<which|/which>

=cut

sub PDL::where {
	if($#_ == 0) {
	        warn "WARNING: one argument form of where() is now deprecated - use which()\n";
		return $_[0]->which();
	} elsif($#_ == 1) {
	        my($data,$mask) = @_;
		$data = $_[0]->clump(-1) if $_[0]->getndims>1;
		$mask = $_[1]->clump(-1) if $_[0]->getndims>1;
		return $data->index($mask->which());
	} else {
		if($_[-1]->getndims > 1) {
			my $mask = $_[-1]->clump(-1)->which;
			return map {$_->clump(-1)->index($mask)}
                               @_[0..$#_-1];
		} else {
			my $mask = $_[-1]->which;
                       return map {$_->index($mask)} @_[0..$#_-1];
		}
	}
}
*where = \&PDL::where;





=head2 append

=for sig

  Signature: (a(n); b(m); [o] c(mn))

=for ref

append two piddles by concantening along their respective first dimensions

=for example

 $a = ones(2,4,7);
 $b = sequence 5;
 $c = $a->append($b);  # size of $c is now (7,4,7) (a jumbo-piddle ;)

C<append> appends two piddles along their first dims. Rest of the dimensions
must be compatible in the threading sense. Resulting size of first dim is
sum of sizes of the two argument piddles' first dims.



=cut






*append = \&PDL::append;




=head2 histogram

=for sig

  Signature: (in(n); int+[o] hist(m); double step; double min; int msize => m)


=for ref

Calculates a histogram for given stepsize and minimum.

=for usage

 $h = histogram($data, $step, $min, $numbins);
 $hist = zeroes $numbins;  # Put histogram in existing piddle.
 histogram($data, $hist, $step, $min, $numbins);

The histogram will contain C<$numbins> bins starting from C<$min>, each
C<$step> wide. The value in each bin is the number of
values in C<$data> that lie within the bin limits.

Data below the lower limit is put in the first bin, and data above the
upper limit is put in the last bin.

The output is reset in a different threadloop so that you
can take a histogram of C<$a(10,12)> into C<$b(15)> and get the result
you want.

Use L<hist|PDL::Basic/hist> instead for a high-level interface.

=for example

 perldl> p histogram(pdl(1,1,2),1,0,3)
 [0 2 1]



=cut






*histogram = \&PDL::histogram;




=head2 whistogram

=for sig

  Signature: (in(n); float+ wt(n);float+[o] hist(m); double step; double min; int msize => m)


=for ref

Calculates a histogram from weighted data for given stepsize and minimum.

=for usage

 $h = whistogram($data, $weights, $step, $min, $numbins);
 $hist = zeroes $numbins;  # Put histogram in existing piddle.
 whistogram($data, $weights, $hist, $step, $min, $numbins);

The histogram will contain C<$numbins> bins starting from C<$min>, each
C<$step> wide. The value in each bin is the sum of the values in C<$weights>
that correspond to values in C<$data> that lie within the bin limits.

Data below the lower limit is put in the first bin, and data above the
upper limit is put in the last bin.

The output is reset in a different threadloop so that you
can take a histogram of C<$a(10,12)> into C<$b(15)> and get the result
you want.

=for example

 perldl> p whistogram(pdl(1,1,2), pdl(0.1,0.1,0.5), 1, 0, 4)
 [0 0.2 0.5 0]



=cut






*whistogram = \&PDL::whistogram;




=head2 histogram2d

=for sig

  Signature: (ina(n); inb(n); int+[o] hist(ma,mb); double stepa; double mina; int masize => ma;
	              double stepb; double minb; int mbsize => mb;)


=for ref

Calculates a 2d histogram.

=for usage

 $h = histogram2d($datax, $datay,
       $stepx, $minx, $nbinx, $stepy, $miny, $nbiny);
 $hist = zeroes $nbinx, $nbiny;  # Put histogram in existing piddle.
 histogram2d($datax, $datay, $hist,
       $stepx, $minx, $nbinx, $stepy, $miny, $nbiny);

The histogram will contain C<$nbinx> x C<$nbiny> bins, with the lower
limits of the first one at C<($minx, $miny)>, and with bin size
C<($stepx, $stepy)>. 
The value in each bin is the number of
values in C<$datax> and C<$datay> that lie within the bin limits.

Data below the lower limit is put in the first bin, and data above the
upper limit is put in the last bin.

=for example

 perldl> p histogram2d(pdl(1,1,1,2,2),pdl(2,1,1,1,1),1,0,3,1,0,3)
 [
  [0 0 0]
  [0 2 2]
  [0 1 0]
 ]





=cut






*histogram2d = \&PDL::histogram2d;




=head2 whistogram2d

=for sig

  Signature: (ina(n); inb(n); float+ wt(n);float+[o] hist(ma,mb); double stepa; double mina; int masize => ma;
	              double stepb; double minb; int mbsize => mb;)


=for ref

Calculates a 2d histogram from weighted data.

=for usage

 $h = whistogram2d($datax, $datay, $weights,
       $stepx, $minx, $nbinx, $stepy, $miny, $nbiny);
 $hist = zeroes $nbinx, $nbiny;  # Put histogram in existing piddle.
 whistogram2d($datax, $datay, $weights, $hist,
       $stepx, $minx, $nbinx, $stepy, $miny, $nbiny);

The histogram will contain C<$nbinx> x C<$nbiny> bins, with the lower
limits of the first one at C<($minx, $miny)>, and with bin size
C<($stepx, $stepy)>. 
The value in each bin is the sum of the values in
C<$weights> that correspond to values in C<$datax> and C<$datay> that lie within the bin limits.

Data below the lower limit is put in the first bin, and data above the
upper limit is put in the last bin.

=for example

 perldl> p whistogram2d(pdl(1,1,1,2,2),pdl(2,1,1,1,1),pdl(0.1,0.2,0.3,0.4,0.5),1,0,3,1,0,3)
 [
  [  0   0   0]
  [  0 0.5 0.9]
  [  0 0.1   0]
 ]





=cut






*whistogram2d = \&PDL::whistogram2d;




=head2 crossp

=for sig

  Signature: (a(tri=3); b(tri); [o] c(tri))

=for ref

Cross product of two 3D vectors

After

=for example

 $c = crossp $a, $b

the inner product C<$c*$a> and C<$c*$b> will be zero, i.e. C<$c> is
orthogonal to C<$a> and C<$b>



=cut






*crossp = \&PDL::crossp;




=head2 norm

=for sig

  Signature: (vec(n); [o] norm(n))

=for ref

Normalises a vector to unit Euclidean length

=cut






*norm = \&PDL::norm;



=head2 stats

=for ref

Calculates useful statistics on a piddle

=for usage

 ($mean,$rms,$median,$min,$max) = stats($piddle,[$weights]);

This utility calculates all the most useful
quantities in one call.

B<Note:> The RMS value that this function returns in the RMS 
deviation from the mean, also known as the population standard-
deviation.

=cut


*stats	  = \&PDL::stats;
sub PDL::stats {
    barf('Usage: ($mean,[$rms]) = stats($data,[$weights])') if $#_>1;
    my ($data,$weights) = @_;
    my ($mean,$rms);
    if ($#_==0) {
       $mean = ($data->sum)/($data->nelem);
       $rms = sqrt(  ((($data-$mean)**2 )->sum) / ($data->nelem) );
    }
    else {
       $mean = (($weights*$data)->sum) / (($weights)->sum);
       $rms = sqrt(  ( ( $weights*(($data-$mean)**2) )->sum )  / ($weights->sum) );
    }
    my ($median,$min,$max) = ($data->median,$data->min,$data->max);
    print "Mean = $mean, RMS = $rms, Median = $median\n".
          "Min  = $min, Max = $max\n" if $PDL::verbose;
    return $mean unless wantarray;
    return ($mean,$rms,$median,$min,$max);
}


=head2 whichND

=for ref

Returns the coordinates for non-zero values

=for usage

 @coords=whichND($mask);

returns an array of piddles containing the coordinates of the elements
that are non-zero in C<$mask>.

=for example

 perldl> $a=sequence(10,10,3,4)
 perldl> ($x, $y, $z, $w)=whichND($a == 203); p $x, $y, $z, $w
 [3] [0] [2] [0]
 perldl> print $a->at(list(cat($x,$y,$z,$w)))
 203

=cut

*whichND = \&PDL::whichND;
sub PDL::whichND {
  my $mask = shift;
  my $ind=($mask->clump(-1))->which;

  return $mask->one2nd($ind);
}





=head2 fibonacci

=for sig

  Signature: ([o]x(n))

=for ref

Constructor - a vector with Fibonacci's sequence

=cut




sub fibonacci { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->fibonacci : PDL->fibonacci(@_) }
sub PDL::fibonacci{
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_fibonacci_int($x->clump(-1));
   return $x;
}







=head2 indadd

=for sig

  Signature: (a(); int ind(); [o] sum(m))


=for ref

Threaded Index Add: Add C<a> to the C<ind> element of C<sum>, i.e:

 sum(ind) += a

=for example

Simple Example:

  $a = 2;
  $ind = 3;
  $sum = zeroes(10);
  indadd($a,$ind, $sum);
  print $sum
  #Result: ( 2 added to element 3 of $sum)
  # [0 0 0 2 0 0 0 0 0 0]

Threaded Example:

  $a = pdl( 1,2,3);
  $ind = pdl( 1,4,6);
  $sum = zeroes(10);
  indadd($a,$ind, $sum);
  print $sum."\n";
  #Result: ( 1, 2, and 3 added to elements 1,4,6 $sum)
  # [0 1 0 0 2 0 3 0 0 0]



=cut






*indadd = \&PDL::indadd;


;


=head1 AUTHOR

Copyright (C) Tuomas J. Lukka 1997 (lukka@husc.harvard.edu). Contributions
by Christian Soeller (c.soeller@auckland.ac.nz) and Karl Glazebrook
(kgb@aaoepp.aao.gov.au).
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL
distribution. If this file is separated from the PDL distribution,
the copyright notice should be included in the file.


=cut





# Exit with OK status

1;

