################################################################
# AutoDIAL - Automatic Dia XML.   (C)Copyright 2001 A Trevena  #
#                                                              #
# AutoDIAL comes with ABSOLUTELY NO WARRANTY; see COPYING file #
# This is free software, and you are welcome to redistribute   #
# it under certain conditions; see COPYING file for details    #
################################################################
package DiagramObject;

use strict;

require Exporter;
use vars qw($VERSION @ISA @EXPORT);

@ISA = qw(Exporter);


#---------------------------------------------------------------

#####################
# Constructor Methods

sub new
{
  my $class = shift;
  my $self = {};

  bless ($self, ref($class) || $class);
  $self->_initialise();

  return $self;
}

#------------------------------------------------------------------------
# Access Methods

sub set_location
{
  my $self = shift;
  my $new_x = shift;
  my $new_y = shift;

  if (defined $new_x )
  {
      $self->{"left_x"} = $new_x;
      $self->{"top_y"} = $new_y;
  }
  my @bottom_right_xy = split(",",$self->BottomRightPos);

  return \@bottom_right_xy;
}

sub TopLeftPos
{
    my $self = shift;
    my $return = $self->{"left_x"} . "," . $self->{"top_y"};
    return $return;
}

sub BottomRightPos
{
    my $self = shift;
    my $return = ($self->{"left_x"} + $self->{"width"}) . "," .
		  ($self->{"top_y"} + $self->{"height"});
    return $return;
}

sub Width
  {
    my $self = shift;
    return $self->{"width"};
  }

sub Height
  {
    my $self = shift;
    return $self->{"height"};
  }

sub Id
{
  my $self = shift;
  return $self->{"Id"};
}

sub Set_Id
{
  my $self = shift;
  $self->{"Id"} = shift;
  return 1;
}

sub Type
  {
    my $self = shift;
    my $return_val = "-";
    my $type = $self->{"type"} || 0;
    if ($type) { $return_val = $type; }
    return $return_val;
  }

sub Name
{
  my $self = shift;
  my $name = shift;
  if ($name)
    {
      $self->{"name"} = $name;
      return 1;
    }
  else
    {
     return $self->{"name"};
    }
}

sub LocalId
{
  my $self = shift;
  my $new_id = shift;
  my $return = 1;

  if (defined $new_id)
    { $self->{"local_id"} = $new_id; }
  else
    { $return = $self->{"local_id"}; }

  return $return;
}

#-----------------------------------------------------------------------------
# Internal Methods

sub _initialise
{
  return 1;
}

sub _update
  {
    return 1;
  }

sub _width
  {
    my $self = shift;
    $self->{"Width"} = 0.5 + (0.6 * length($self->{"Name"}));
    return 1;
  }

sub _height
  {
    my $self = shift;
    $self->{"Height"} = 2.5;
    return 1;
  }

sub _set_updated
  {
    my $self = shift;
    my $field = shift;

    ${$self->{"_updated"}}{$field} = 1;

    return 1;
  }

1;

###############################################################################

=head1

=cut
