################################################################
# AutoDIA - Automatic Dia XML.   (C)Copyright 2001 A Trevena   #
#                                                              #
# AutoDIA comes with ABSOLUTELY NO WARRANTY; see COPYING file  #
# This is free software, and you are welcome to redistribute   #
# it under certain conditions; see COPYING file for details    #
################################################################
package Handler;

use strict;

require Exporter;
use vars qw($VERSION @ISA @EXPORT);

@ISA = qw(Exporter);

use Diagram;

#---------------------------------------------------------------

#####################
# Constructor Methods

sub new
{
  my $class  = shift();
  my $self   = {};
  my %config = %{shift()};

  bless ($self, ref($class) || $class);
  $self->_initialise(\%config);

  return $self;
}

#------------------------------------------------------------------------
# Access Methods

sub parse_file
  {
    my $self     = shift();
    my $filename = shift();
    my %config   = $self->{config};
    my $infile   = (defined $config{inputpath}) ?
      $config{inputpath} . $filename : $filename ;

    $self->{file_open_error} = 0;

    open (INFILE, "<$infile") || _error_file();

    if ($self->{file_open_error} == 1)
      {
	print "skipping $infile..\n";
	return 0;
      }

    $self->_parse (\*INFILE,$infile);

    close INFILE;

    return 1;
  }

#----

sub output
  {
    my $self    = shift;
    my $Diagram = $self->{Diagram};

    my %config = %{$self->{Config}};

    $Diagram->remove_duplicates;

    #process template
    $Diagram->export_xml(\%config);

    return 1;
  }

#-----------------------------------------------------------------------------
# Internal Methods

sub _initialise
{
  my $self    = shift;
  my $config_ref = shift;
  my $Diagram = Diagram->new($config_ref);

  $self->{Config}  = $config_ref;
  $self->{Diagram} = $Diagram;

  return 1;
}

sub _error_file
  {
    my $self          = shift;
#    my $error_message = shift;

    $self->{file_open_error} = 1;

    print "Handler.pm : _error_file : error opening file\n";
    #$error_message\n";

    return 1;
  }

sub _parse
  {
    print "parsing file \n";
    return;
  }

1;

###############################################################################

=head1 NAME

Handler.pm - generic language handler superclass

=head1 CONSTRUCTION METHOD

Not actually used but subclassed ie HandlerPerl or HandlerC as below:

my $handler = HandlerPerl->New(\%Config);

=cut
