################################################################
# AutoDIA - Automatic Dia XML.   (C)Copyright 2001 A Trevena   #
#                                                              #
# AutoDIA comes with ABSOLUTELY NO WARRANTY; see COPYING file  #
# This is free software, and you are welcome to redistribute   #
# it under certain conditions; see COPYING file for details    #
#                                                              #
# DiaXMLWriter Copyright 1999 Felix Hallmann                   #
################################################################
package HandlerJava;

require Exporter;

use strict;

use vars qw($VERSION @ISA @EXPORT);

use Handler;
use Diagram;

use Inline::Java;

@ISA = qw(Handler Exporter);


#---------------------------------------------------------------

#####################
# Constructor Methods

# new inherited from Handler

#------------------------------------------------------------------------
# Access Methods

# parse_file inherited from Handler

#-----------------------------------------------------------------------------
# Internal Methods

# _initialise inherited from Handler

sub _parse
  {
    my $self     = shift;
    my $fh       = shift;
    my $filename = shift;
    my $Diagram  = $self->{Diagram};

    my $Class;

    close $fh;

    $Class = DiagramClass->new($className);
    # add class to diagram
    $Diagram->add_class($Class);

    my $Component = DiagramComponent->new($componentName);
    # add component to diagram
    my $exists = $Diagram->add_component($Component);

    # replace component if redundant
    if (ref $exists)
      {
	$Component = $exists;
      }
    # create new dependancy
    my $Dependancy = DiagramDependancy->new($Class, $Component);
    # add dependancy to diagram
    $Diagram->add_dependancy($Dependancy);
    # add dependancy to class
    $Class->add_dependancy($Dependancy);
    # add dependancy to component
    $Component->add_dependancy($Dependancy);

    # create superclass
    my $Superclass = DiagramSuperclass->new($super);
    # add superclass to diagram
    $Diagram->add_superclass($Superclass);
    # create new inheritance
    my $Inheritance = DiagramInheritance->new($Class, $Superclass);
    # add inheritance to superclass
    $Superclass->add_inheritance($Inheritance);
    # add inheritance to class
    $Class->add_inheritance($Inheritance);
    # add inheritance to diagram
    $Diagram->add_inheritance($Inheritance);

    $Class->add_operation(\%subroutine);


    $Class->add_attribute({
			   name => $attribute_name,
			   visibility => $attribute_visibility,
			  });
    $self->{Diagram} = $Diagram;

    return;
  }


 my $alu = new alu() ;
   print "9 + 16 = ", $alu->add(9, 16), "\n";
   print "9 - 16 = ", $alu->subtract(9, 16), "\n";



###############################################################################
# Java inline for use by parser.


use Inline Java => <<'STOP_THE_MADNESS';

// DiaXMLWriter Copyright 1999 Felix Hallmann <felix.hallmann@web.de>
// Changes to DiaXMLWriter Copyright 2001 Aaron Trevena <ajt@droogs.org>

import java.lang.reflect.*;
import java.lang.Class;
import java.io.PrintWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.File;

class class_handler {
    public class_handler(string filename)
    {
	Class c = null;
	try
	  { c = Class.forName(filename); }
	catch (ClassNotFoundException cnfe)
	  { System.err.println("Class not found. Check your classpath."); }


        public string get_name(class c)
        {
          string name = c.getName();
          return name;
        }

        public string[] get_methods(class c)
        {
          if (fields.length > 0)
          {
            for(int i = 0; i < fields.length; i++)
            {           // Display them.
               m = fields[i].getModifiers();
               if ((Modifier.isPublic(m))                    ||
                  (addPrivate   && Modifier.isPrivate(m))   ||
                   (addProtected && Modifier.isProtected(m)))
                   {
                     writeableAttribute = true;
                     break;
                   }
            }
            if (writeableAttribute)
            {
               out.print(DiaClassAttributeHead);
               for(int i = 0; i < fields.length; i++)
               {           // Display them.
                 m = fields[i].getModifiers();
                 if ((Modifier.isPublic(m))                    ||
                    (addPrivate   && Modifier.isPrivate(m))   ||
                    (addProtected && Modifier.isProtected(m)))
                 {
                   tmp = replace(DiaClassAttribute, "%name%", fields[i].getName());
                   tmp = replace(tmp, "%type%", typename(fields[i].getType()));
                   tmp = replace(tmp, "%visibility%", visibility(m));
                   tmp = replace(tmp, "%scope%", isStatic(m));
                   out.print(tmp);
                 }
            }
            out.print(DiaClassAttributeTail);
          }
          else
          {
             out.print(DiaClassAttributeEmpty);
          }

        }

    }
STOP_THE_MADNESS



1;

###############################################################################

=head1 NAME

HandlerJava.pm - AutoDia handler for Java (based on DiaXMLWriter)

=head1 INTRODUCTION

Rather than parsing the java file as other handlers do, this handler utilises the Java Virtual Machine to get metadata about a class. By using Inline::Java native java code is called to retreive this metadata which is then handled by the perl classes.

This is based on Felix Hallmanns DiaXMLWriter. Orginally Felix's program was pure java and used inline dia xml, so I have integrated much of its functionality into a parser allowing the information to be made available through AutoDia's abstraction as HTML, XML or even SQL via the Templating system.

=head1 CONSTRUCTION METHOD

use HandlerPerl;

my $handler = HandlerJava->New(\%Config);

This creates a new handler using the Configuration hash to provide rules selected at the command line.

=head1 ACCESS METHODS

$handler->Parse(filename); # where filename includes full or relative path.

This parses the named file and returns 1 if successful or 0 if the file could not be opened.

$handler->output(); # any arguments are ignored.

This outputs the Dia XML file according to the rules in the %Config hash passed at initialisation of the object.

=cut
