# NOTE: Derived from blib/lib/Ace.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Ace;

#line 1464 "blib/lib/Ace.pm (autosplit into blib/lib/auto/Ace/status.al)"
# Return a hash of miscellaneous status information from the server
# (to be expanded later)
sub status {
  my $self = shift;
  my $data = $self->raw_query('status');
  study $data;
  my ($version)   = $data=~/ACEDB version (\S+),/m;
  my ($date)      = $data=~/linked (.+)$/m;
  my ($directory) = $data=~/Data directory (\S+),/m;
  my ($blocks)    = $data=~/Disk: (\d+) blocks/m;
  my ($classes)   = $data=~/Lexiques: (\d+) classes/m;
  my ($keys)      = $data=~/(\d+) keys/;
  my ($memory)    = $data=~/Messalloc: (\d+)/;
  my ($write)     = $data=~/Write Access Yes/;
  my %data = (
	  'version'    => $version,
	  'date'       => $date,
	  'directory'  => $directory,
	  'blocks'     => $blocks,
	  'classes'    => $classes,
	  'keys'       => $keys,
	  'memory'     => $memory,
	  'write'      => $write,
	      );
  return wantarray ? %data : \%data;
}

# end of Ace::status
1;
