# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1445 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/list.al)"
# ----------------------------------------------------------------------


# *** Any additinal/changed methods must be mirrored in object_list
sub list {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;

    $methods{$field} =
      sub {
        my ($self, @list) = @_;
        defined $self->{$field} or $self->{$field} = [];
        #
        # Push of arguments deprecated.  Later, the semanticmay
        # change (likely to replace, rather than push onto, the list).
        #

        # XXX Deprecated 25.v.00 ---------

        # This code is deprecated.  Use at your peril.  It is not
        # supported, and will disappear at or after 25.v.01
        push @{$self->{$field}}, map { ref $_ eq 'ARRAY' ? @$_ : ($_) } @list;

        # XXX Deprecated 25.v.00 ---------

        return wantarray ? @{$self->{$field}} : $self->{$field};
      };

    $methods{"${field}_pop"} =
    $methods{"pop_$field"} =
      sub {
        my ($self) = @_;
        pop @{$self->{$field}}
      };

    $methods{"${field}_push"} =
    $methods{"push_$field"} =
      sub {
        my ($self, @values) = @_;
	push @{$self->{$field}}, @values;
      };

    $methods{"${field}_shift"} =
    $methods{"shift_$field"} =
      sub {
        my ($self) = @_;
        shift @{$self->{$field}}
      };

    $methods{"${field}_unshift"} =
    $methods{"unshift_$field"} =
      sub {
        my ($self, @values) = @_;
        unshift @{$self->{$field}}, @values;
      };

    $methods{"${field}_splice"} =
    $methods{"splice_$field"} =
      sub {
        my ($self, $offset, $len, @list) = @_;
        splice(@{$self->{$field}}, $offset, $len, @list);
      };

    $methods{"${field}_clear"} =
    $methods{"clear_$field"} =
      sub {
        my ($self) = @_;
        $self->{$field} = [];
      };

    $methods{"${field}_count"} =
    $methods{"count_$field"} =
      sub {
        my ($self) = @_;
        return exists $self->{$field} ? scalar @{$self->{$field}} : 0;
      };

    $methods{"${field}_index"} =
      sub {
	my $self = shift;
	my (@indices) = @_;
	my @Result;
	push @Result, $self->{$field}->[$_]
	  for @indices;
	return wantarray ? @Result : \@Result;
      };

    my $method_name = "${field}_set";
    $methods{$method_name} =
      sub {
	my $self = shift;
	my @args = @_;
	croak "$method_name expects an even number of fields\n"
	  if @args % 2;
	while ( my ($index, $value) = splice @args, 0, 2 ) {
	  $self->{$field}->[$index] = $value;
	}
      };

    #
    # Deprecated. v0.95 1.vi.00
    #
    $methods{"${field}_ref"} =
      sub {
        my ($self) = @_;
        $self->{$field};
      };
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::list
1;
