# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 860 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/object_list.al)"
# ----------------------------------------------------------------------


sub object_list {
  my ($class, @args) = @_;
  my %methods;

  while (@args) {
    my $class = shift @args;
    my $list = shift @args or die "No slot names for $class";

    my @list = ( ref($list) eq 'ARRAY' ) ? @$list : ($list);

    my $obj_def;
    foreach $obj_def (@list) {
      my $type = $class;
            # Hmmm. We have to do this for the closure to work. I.e. using
            # $class in the closure dosen't work. Someday I'll actually
            # understand scoping in Perl. [ Uh, is this true? 11/11/96 -PBS ]

      my ( $name, @composites );
      my $new_meth = 'new';
      if ( ! ref $obj_def ) {
        $name = $obj_def;
      } else {
        $name = $obj_def->{'slot'};
        my $composites = $obj_def->{'comp_mthds'};
        @composites = ref($composites) eq 'ARRAY' ? @$composites
                            : defined $composites ? ($composites) : ();
      }

      $methods{$name} = sub {
        my ($self, @list) = @_;
        defined $self->{$name} or $self->{$name} = [];
        if ( scalar @list == 1 and ref( $list[0] ) eq 'ARRAY' ) {
          @list = @{ $list[0] };
        }
        push @{$self->{$name}}, map {
          (ref $_ and UNIVERSAL::isa($_, $class)) ? $_ : $type->$new_meth($_)
        } @list;

        # Use wantarray for consistency with list, which uses it for
        # consistency with its own doco., and the hash impl.

        return wantarray ? @{$self->{$name}} : $self->{$name};
      };

      $methods{"pop_$name"} = sub {
        my ($self) = @_;
        pop @{$self->{$name}}
      };

      $methods{"push_$name"} = sub {
        my ($self, @values) = @_;
        push @{$self->{$name}}, @values;
      };

      $methods{"shift_$name"} = sub {
        my ($self) = @_;
        shift @{$self->{$name}}
      };

      $methods{"unshift_$name"} = sub {
        my ($self, @values) = @_;
        unshift @{$self->{$name}}, @values;
      };

      $methods{"splice_$name"} = sub {
        my ($self, $offset, $len, @list) = @_;
        splice(@{$self->{$name}}, $offset, $len, @list);
      };

      $methods{"clear_$name"} = sub {
        my ($self) = @_;
        $self->{$name} = [];
      };


      $methods{"count_$name"} = sub {
        my ($self) = @_;
        return exists $self->{$name} ? scalar @{$self->{$name}} : 0;
      };

      #
      # Deprecated in line with list, v0.95 (1.vi.00)
      #
      $methods{"ref_$name"} = sub {
        my ($self) = @_;
        $self->{$name};
      };
      
      $methods{"index_$name"} = sub {
        my $self = shift;
        my (@indices) = @_;
        my @Result;
        push @Result, $self->{$name}->[$_]
          for @indices;
        return $Result[0] if @_ == 1;
        return wantarray ? @Result : \@Result;
      };
      
      foreach (keys %methods) {
        /^(.*)_([^_]*)$/ or next;
        my ($verb, $name) = ($1, $2);
        $methods{"${name}_$verb"} = $methods{$_};
      }
      
      for my $method_name (("set_$name", "${name}_set")) {
        $methods{$method_name} = sub {
          my $self = shift;
          my @args = @_;
          croak "$method_name expects an even number of fields\n"
              if @args % 2;
          while ( my ($index, $value) = splice @args, 0, 2 ) {
            $self->{$name}->[$index] = $value;
          }
          return @_ / 2;
        };
      }
        
      my $meth;
      foreach $meth (@composites) {
        $methods{$meth} = sub {
          my ($self, @args) = @_;
          map { $_->$meth(@args) } $self->$name()
        };
      }
    }
  }
  $class = $class; # Huh? Without this line the next line doesn't work!
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::object_list
1;
