# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package CGI::Session;

#line 715 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/STORE.al)"
# STORE(): called when a value is assigned to a session hash
# Usage: $session{some_key} = "Some Value"
#
# RETURN VALUE: same as $session->param("some_key", "Some Value")
sub STORE {
    my ($self, $key, $value) = @_;

    # Map of the function related to the private data.
    # If user tries to set these values, we call respective methods
    # But for anything else we call param(), which will be ignoring
    # special names
    my %ok_map = (
        _session_etime => \&expires,
        _session_atime => \&atime,
    );

    if ( exists $ok_map{$key} ) {
        return $ok_map{$key}->($self, $value);

    }

    return $self->param($key, $value);
}

# end of CGI::Session::STORE
1;
