# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package CGI::Session;

#line 399 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/expires.al)"
# expires(): gets/sets the expiration time for the session
# Usage: CLASS->expires([seconds]);
#
# RETURN VALUE: if used w/out arguments, returns time() value
# if expire time was set.
# if used w/ argument, returns 1
sub expires {
    my ($self, $date) = @_;

    unless ( $date ) {
        return $self->{_data}->{_session_etime};
    }

    my $in_seconds = _date_shortcuts($date);

    $self->{_data}->{_session_etime} = time() + $in_seconds;
}

# end of CGI::Session::expires
1;
