# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package CGI::Session;

#line 523 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/load_param.al)"
# Loads the parameters from the session object to current CGI object
# Usage: CLASS->load_param($cgi [,\@array])
#
# RETURN VALUE: number of parameters successfully loaded
sub load_param {
    my $self = shift;
    my $cgi  = shift;
    my $class = ref($self) || $self;


    unless ( $cgi->UNIVERSAL::isa("CGI") ) {
        # We didn't receive a CGI object as the first argument
        croak "Usage: $class->load_param(\$cgi [,\@array]). Where \$cgi is the CGI.pm object";
    }

    # Get the names of parameters to load. If no parameters
    # provided, load all the session parameters to the current
    # CGI object
    my @params = ();
    if ( defined $_[0] ) {
        unless ( ref($_[0]) eq 'ARRAY' ) {
            croak "Usage: $class->load_param(\$cgi [,\@array])";
        }
        @params = @{ $_[0] };
    }

    unless ( @params ) {
        @params = $self->param();
    }

    # Saving CGI params into session params were not tough at all because
    # CGI->param() could return either a scalar or a list element.
    # But CGI::Session->param() can return all the available Perl
    # data structures. So we'll need to make sure to load only scalars
    # and arrayrefs and ignore all others
    my ($value, $nloaded);
    for ( @params ) {
        $value = $self->param($_);

        if ( my $type = ref($value) ) {

            if ( $type eq 'ARRAY' ) {
                # It is an arrayref
                $cgi->param(-name=>$_, -values=>$value);
                ++$nloaded;
            }

        } else {
            $cgi->param(-name=>$_, -value=>$value);
            ++$nloaded;
        }
    }

    return $nloaded;
}

# end of CGI::Session::load_param
1;
