# NOTE: Derived from blib/lib/CGI/Session.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package CGI::Session;

#line 461 "blib/lib/CGI/Session.pm (autosplit into blib/lib/auto/CGI/Session/save_param.al)"
# save_param(): saves the parameters in the CGI object into the session
# object.
# Usage: CLASS->save_param($cgi [, \@array])
#
# RETURN VALUE: number of parameters successfully saved
sub save_param {
    my $self = shift;
    my $cgi  = shift;
    my $class = ref($self) || $self;

    unless ( $cgi->UNIVERSAL::isa("CGI") ) {
        # We didn't receive a CGI object as the first argument
        croak "Usage: $class->save_param(\$cgi [,\@array]). Where \$cgi is the CGI.pm object";
    }

    # Get the names of all the parameters the user wants to save.
    # I believe @params = @{ $_[0] } || $cgi->param() syntax looks more
    # elegant, but if $_[0] is missing, Perl will issue warnings
    my @params = ();
    if ( defined $_[0] ) {

        # If we receive other than arrayref, we're still going to die
        # with less helpful error message. So let's kill it ourselves with
        # more friendly (yeah, right) diagnostic
        unless ( ref($_[0]) eq 'ARRAY' ) {
            croak "Usage: $class->save_param(\$cgi, [\@array])";
        }

        @params = @{ $_[0] };
    }

    # If fields to be saved are not given, let's save all the available
    # fields
    unless ( @params ) {
        @params = $cgi->param();
    }

    # We have to be careful here, since CGI.pm's param('name') syntax
    # can also return an array. It is most likely to happen in checkboxes
    # and multi-select popup menus.
    my (@values, $nsaved);
    for ( @params ) {

        # Let's assume it always returns an array.
        @values = $cgi->param($_);

        if ( @values > 1 ) {
            # if it really returned a list, save the reference to it
            # in the session parameter under the same name
            $self->param($_, \@values) && ++$nsaved;
            next;
        }

        # If it returned a single value, just save the first index
        $self->param($_, $values[0]) && ++$nsaved;
    }

    # now return number of parameters successfully saved
    return $nsaved;
}

# end of CGI::Session::save_param
1;
