# NOTE: Derived from blib/lib/Net/EasyTCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::EasyTCP;

#line 1609 "blib/lib/Net/EasyTCP.pm (autosplit into blib/lib/auto/Net/EasyTCP/receive.al)"
sub receive() {
	my $self = shift;
	my $timeout = shift || 300;
	my $returninternaldata = shift || 0;
	my $temp;
	my $realdata;
	my $result;
	my $lastactivity = time;
	my $selector;
	my @ready;
	if ($self->{_mode} ne "client" && $self->{_mode} ne "serverclient") {
		$@ = "$self->{_mode} cannot use method receive()";
		return undef;
		}
	$selector = new IO::Select;
	$selector->add($self->{_sock});
	while ((time - $lastactivity) < $timeout) {
		@ready = $selector->can_read($timeout);
		if (!@ready) {
			if ($! =~ /interrupt/i) {
				next;
				}
			else {
				last;
				}
			}
		$result = sysread($self->{_sock}, $temp, 4096);
		if ($result == 0) {
			# Socket closed
			$@ = "Socket closed when attempted reading";
			return undef;
			}
		elsif (!defined $result) {
			# Error in socket
			$@ = "Error reading from socket: $!";
			return undef;
			}
		else {
			# Read good data
			$lastactivity = time;
			$self->{_databuffer} .= $temp;
			while (1) {
				if (defined($realdata = &_extractdata($self)) ) {
					# We read something
					if ($realdata) {
						# It's real data that belongs to the application
						return $self->data(1);
						}
					elsif ($returninternaldata) {
						# It's internal but we've been instructed to return it
						return $self->data(1);
						}
					else {
						# It's internal data so we parse it
						&_parseinternaldata($self);
						}
					}
				else {
					# There's no (more) data to be extracted
					last;
					}
				}
			}
		}
	$@ = "Timed out waiting to receive data";
	return undef;
	}

#
# This method is a synonym for close()
#
# end of Net::EasyTCP::receive
1;
