# NOTE: Derived from blib/lib/Net/EasyTCP.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Net::EasyTCP;

#line 1412 "blib/lib/Net/EasyTCP.pm (autosplit into blib/lib/auto/Net/EasyTCP/start.al)"
sub start() {
	my $self = shift;
	my @ready;
	my $clientsock;
	my $tempdata;
	my $serverclient;
	my $realdata;
	my $result;
	my $error;
	my $negotiatingtimeout = 45;
	my $lastglobalkeygentime;
	my $peername;
	my $remoteport;
	my $remoteip;
	$_SELECTOR = new IO::Select;
	if ($self->{_mode} ne "server") {
		$@ = "$self->{_mode} cannot use method start()";
		return undef;
		}
	$self->{_running} = 1;
	$self->{_requeststop} = 0;
	$_SELECTOR->add($self->{_sock});
	$lastglobalkeygentime = time;
MLOOP:	while (!$self->{_requeststop}) {
		@ready = $_SELECTOR->can_read(1);
		foreach (@ready) {
			if ($_ == $self->{_sock}) {
				# The SERVER SOCKET is ready for accepting a new client
				$clientsock = $self->{_sock}->accept();
				if (!$clientsock) {
					$error = "Error while accepting new connection: $!";
					last MLOOP;
					}
				# We get remote IP and port, we'll need them to see if client is allowed or not
				$peername = getpeername($clientsock) or next;
				($remoteport, $remoteip) = sockaddr_in($peername) or next;
				$remoteip = inet_ntoa($remoteip) or next;
				# We create a new client object
				# We see if client is allowed to connect to us
				if (scalar(keys %{$self->{_clientip}}) && !$self->{_clientip}{$remoteip}) {
					# Client's IP is not allowed to connect to us
					close ($clientsock);
					}
				else {
					# We add it to our pool
					$_SELECTOR->add($clientsock);
					# We create a new client object:
					$self->{_clients}->{$clientsock} = &_new_client(
						$self,
						"_sock"		=>	$clientsock,
						"_remoteport"	=>	$remoteport,
						"_remoteip"	=>	$remoteip
						);
					# And we make it inherit some stuff from the server
					$self->{_clients}->{$clientsock}->{_serial} = ++$_SERIAL;
					$self->{_clients}->{$clientsock}->{_donotencrypt} = $self->{_donotencrypt};
					$self->{_clients}->{$clientsock}->{_donotcompress} = $self->{_donotcompress};
					$self->{_clients}->{$clientsock}->{_password} = $self->{_password};
					$self->{_clients}->{$clientsock}->{_callbacks} = $self->{_callbacks};
					$self->{_clients}->{$clientsock}->{_welcome} = $self->{_welcome};
					}
				}
			else {
				# One of the client sockets are ready
				$result = sysread($_, $tempdata, 4096);
				$serverclient = $self->{_clients}->{$_};
				if (!defined $result) {
					# Error somewhere during reading
					&_callback($serverclient, "disconnect");
					$serverclient->close();
					delete $self->{_clients}->{$_};
					}
				elsif ($result == 0) {
					# Client closed connection
					&_callback($serverclient, "disconnect");
					$serverclient->close();
					delete $self->{_clients}->{$_};
					}
				else {
					# Client sent us some good data (not necessarily a full packet)
					$serverclient->{_databuffer} .= $tempdata;
					while (defined ($realdata = &_extractdata($serverclient)) ) {
						if (!$realdata) {
							# It's internal protocol data
							&_parseinternaldata($serverclient);
							}
						else {
							# We found something and it's real data
							&_callback($serverclient, "data");
							}
						}
					}
				}
			}
		# Now we check on all the serverclients still negotiating and help them finish negotiating
		# or weed out the ones timing out
		foreach (keys %{$self->{_clients}}) {
			$serverclient = $self->{_clients}->{$_};
			if ($serverclient->{_negotiating}) {
				if (&_serverclient_negotiate($serverclient) ) {
					&_callback($serverclient, "connect");
					}
				elsif ((time - $serverclient->{_negotiating}) > $negotiatingtimeout) {
					$serverclient->close();
					delete $self->{_clients}->{$_};
					}
				}
			}
		# Now we re-generate the RSA keys if it's been over an hour
		#
		if (!$self->{_donotencrypt} && ((time-$lastglobalkeygentime) >= 3600)) {
			if (!&_generateglobalkeypair('Crypt::RSA')) {
				$error = "Could not generate global Crypt::RSA keypairs. $@";
				last MLOOP;
				}
			$lastglobalkeygentime = time;
			}
		}
	# If we reach here the server's been stopped
	$self->{_clients} = {};
	$self->{_running} = 0;
	$self->{_requeststop} = 0;
	if ($error) {
		$@ = $error;
		return undef;
		}
	else {
		return 1;
		}
	}

#
# This method stops the server and makes it return.
# Note: It doesn't stop the server immediately, it sets a flag
# and the flag should in a few seconds cause the infinite loop in start() method to stop
#
# end of Net::EasyTCP::start
1;
