#
#
# COPYRIGHT AND LICENSE
# Copyright (c) 2001 Juniper Networks, Inc.  All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 	1.	Redistributions of source code must retain the above
# copyright notice, this list of conditions and the following
# disclaimer. 
# 	2.	Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution. 
# 	3.	The name of the copyright owner may not be used to 
# endorse or promote products derived from this software without specific 
# prior written permission. 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# FILE: jkernel_methods.pl -- generated automagikally; DO NOT EDIT
#

%jkernel_methods = (
    ## Method : <clear-helper-statistics-information>
    ## Returns: nothing
    ## Command: "clear helper statistics"
    clear_helper_statistics_information => $NO_ARGS,

    ## Method : <get-interface-information>
    ## Returns: <interface-information>
    ## Command: "show interfaces"
    get_interface_information => {
	extensive => $TOGGLE,
	statistics => $TOGGLE,
	media => $TOGGLE,
	detail => $TOGGLE,
	terse => $TOGGLE,
	brief => $TOGGLE,
	descriptions => $TOGGLE,
	destination_class => $STRING,
	snmp_index => $STRING,
	interface_name => $STRING,
    },

    ## Method : <get-interface-queue-information>
    ## Returns: <interface-information>
    ## Command: "show interfaces queue"
    get_interface_queue_information => {
	forwarding_class => $STRING,
	interface_name => $STRING,
    },

    ## Method : <get-interface-filter-information>
    ## Returns: <interface-filter-information>
    ## Command: "show interfaces filters"
    get_interface_filter_information => {
	interface_name => $STRING,
    },

    ## Method : <get-interface-policer-information>
    ## Returns: <interface-policer-information>
    ## Command: "show interfaces policers"
    get_interface_policer_information => {
	interface_name => $STRING,
    },

    ## Method : <get-forwarding-table-information>
    ## Returns: <forwarding-table-information>
    ## Command: "show route forwarding-table"
    get_forwarding_table_information => {
	detail => $TOGGLE,
	extensive => $TOGGLE,
	multicast => $TOGGLE,
	family => $STRING,
	vpn => $STRING,
	summary => $TOGGLE,
	matching => $STRING,
	destination => $STRING,
    },

    ## Method : <get-accounting-profile-information>
    ## Returns: <accounting-profile-information>
    ## Command: "show accounting"
    get_accounting_profile_information => {
	profile => $STRING,
    },

    ## Method : <get-accounting-record-information>
    ## Returns: <accounting-record-information>
    ## Command: "show accounting records"
    get_accounting_record_information => {
	profile => $STRING,
	since => $STRING,
	utc_timestamp => $TOGGLE,
    },

    ## Method : <get-alarm-information>
    ## Returns: <alarm-information>
    ## Command: "show chassis alarms"
    get_alarm_information => $NO_ARGS,

    ## Method : <get-environment-information>
    ## Returns: <environment-information>
    ## Command: "show chassis environment"
    get_environment_information => $NO_ARGS,

    ## Method : <get-firmware-information>
    ## Returns: <firmware-information>
    ## Command: "show chassis firmware"
    get_firmware_information => $NO_ARGS,

    ## Method : <get-fpc-information>
    ## Returns: <fpc-information>
    ## Command: "show chassis fpc"
    get_fpc_information => $NO_ARGS,

    ## Method : <get-pic-information>
    ## Returns: <fpc-information>
    ## Command: "show chassis fpc pic-status"
    get_pic_information => {
	slot => $STRING,
    },

    ## Method : <get-spmb-information>
    ## Returns: <spmb-information>
    ## Command: "show chassis spmb"
    get_spmb_information => $NO_ARGS,

    ## Method : <get-spmb-sib-information>
    ## Returns: <spmb-sib-information>
    ## Command: "show chassis spmb sibs"
    get_spmb_sib_information => $NO_ARGS,

    ## Method : <get-chassis-inventory>
    ## Returns: <chassis-inventory>
    ## Command: "show chassis hardware"
    get_chassis_inventory => {
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-route-engine-information>
    ## Returns: <route-engine-information>
    ## Command: "show chassis routing-engine"
    get_route_engine_information => {
	slot => $STRING,
    },

    ## Method : <get-ssb-information>
    ## Returns: <scb-information>
    ## Command: "show chassis ssb"
    get_ssb_information => {
	slot => $STRING,
    },

    ## Method : <get-scb-information>
    ## Returns: <scb-information>
    ## Command: "show chassis scb"
    get_scb_information => $NO_ARGS,

    ## Method : <get-sfm-information>
    ## Returns: <scb-information>
    ## Command: "show chassis sfm"
    get_sfm_information => $NO_ARGS,

    ## Method : <get-feb-information>
    ## Returns: <scb-information>
    ## Command: "show chassis feb"
    get_feb_information => $NO_ARGS,

    ## Method : <get-snmp-information>
    ## Returns: <snmp-statistics>
    ## Command: "show snmp statistics"
    get_snmp_information => $NO_ARGS,

    ## Method : <get-rmon-information>
    ## Returns: <rmon-information>
    ## Command: "show snmp rmon"
    get_rmon_information => $NO_ARGS,

    ## Method : <get-rmon-alarm-information>
    ## Returns: <rmon-alarm-information>
    ## Command: "show snmp rmon alarms"
    get_rmon_alarm_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-rmon-event-information>
    ## Returns: <rmon-event-information>
    ## Command: "show snmp rmon events"
    get_rmon_event_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-cos-information>
    ## Returns: <cos-information>
    ## Command: "show class-of-service"
    get_cos_information => $NO_ARGS,

    ## Method : <get-cos-forwarding-class-information>
    ## Returns: <cos-forwarding-class-information>
    ## Command: "show class-of-service forwarding-class"
    get_cos_forwarding_class_information => $NO_ARGS,

    ## Method : <get-cos-drop-profile-information>
    ## Returns: <cos-drop-profile-information>
    ## Command: "show class-of-service drop-profile"
    get_cos_drop_profile_information => {
	profile_name => $STRING,
    },

    ## Method : <get-cos-classifier-information>
    ## Returns: <cos-classifier-information>
    ## Command: "show class-of-service classifier"
    get_cos_classifier_information => {
	name => $STRING,
	type => $STRING,
    },

    ## Method : <get-cos-rewrite-information>
    ## Returns: <cos-rewrite-information>
    ## Command: "show class-of-service rewrite-rule"
    get_cos_rewrite_information => {
	name => $STRING,
	type => $STRING,
    },

    ## Method : <get-cos-code-point-map-information>
    ## Returns: <cos-code-point-map-information>
    ## Command: "show class-of-service code-point-aliases"
    get_cos_code_point_map_information => {
	dscp => $TOGGLE,
	exp => $TOGGLE,
	ieee_802_1 => $TOGGLE,
	inet_precedence => $TOGGLE,
    },

    ## Method : <get-cos-scheduler-map-information>
    ## Returns: <cos-scheduler-map-information>
    ## Command: "show class-of-service scheduler-map"
    get_cos_scheduler_map_information => {
	name => $STRING,
    },

    ## Method : <get-cos-interface-map-information>
    ## Returns: <cos-interface-information>
    ## Command: "show class-of-service interface"
    get_cos_interface_map_information => {
	interface_name => $STRING,
    },

    ## Method : <get-cos-table-information>
    ## Returns: <cos-table-information>
    ## Command: "show class-of-service forwarding-table"
    get_cos_table_information => $NO_ARGS,

    ## Method : <get-cos-classifier-table-information>
    ## Returns: <cos-classifier-table-information>
    ## Command: "show class-of-service forwarding-table classifier"
    get_cos_classifier_table_information => $NO_ARGS,

    ## Method : <get-cos-classifier-table-map-information>
    ## Returns: <cos-classifier-table-map-information>
    ## Command: "show class-of-service forwarding-table classifier mapping"
    get_cos_classifier_table_map_information => $NO_ARGS,

    ## Method : <get-cos-scheduler-map-table-information>
    ## Returns: <cos-scheduler-map-table-information>
    ## Command: "show class-of-service forwarding-table scheduler-map"
    get_cos_scheduler_map_table_information => $NO_ARGS,

    ## Method : <get-cos-red-information>
    ## Returns: <cos-red-information>
    ## Command: "show class-of-service forwarding-table drop-profile"
    get_cos_red_information => $NO_ARGS,

    ## Method : <get-cos-rewrite-table-information>
    ## Returns: <cos-rewrite-table-information>
    ## Command: "show class-of-service forwarding-table rewrite-rule"
    get_cos_rewrite_table_information => $NO_ARGS,

    ## Method : <get-cos-rewrite-table-map-information>
    ## Returns: <cos-rewrite-table-map-information>
    ## Command: "show class-of-service forwarding-table rewrite-rule mapping"
    get_cos_rewrite_table_map_information => $NO_ARGS,

    ## Method : <get-fabric-queue-information>
    ## Returns: <fabric-queue-information>
    ## Command: "show class-of-service fabric queue"
    get_fabric_queue_information => {
	destination => $STRING,
	source => $STRING,
	summary => $TOGGLE,
    },

    ## Method : <get-logging-service-files-information>
    ## Returns: <logging-service-files-information>
    ## Command: "show services logging logfiles"
    get_logging_service_files_information => $NO_ARGS,

    ## Method : <get-logging-service-history-information>
    ## Returns: <logging-service-history-information>
    ## Command: "show services logging history"
    get_logging_service_history_information => $NO_ARGS,

    ## Method : <get-logging-service-client-history-information>
    ## Returns: <logging-service-history-information>
    ## Command: "show services logging history client"
    get_logging_service_client_history_information => {
	client_address => $STRING,
    },

    ## Method : <get-ggsn-imsi-trace>
    ## Returns: <ggsn-user-trace-information>
    ## Command: "show services ggsn trace imsi"
    get_ggsn_imsi_trace => {
	imsi_identifier => $STRING,
    },

    ## Method : <get-ggsn-msisdn-trace>
    ## Returns: <ggsn-user-trace-information>
    ## Command: "show services ggsn trace msisdn"
    get_ggsn_msisdn_trace => {
	msisdn_identifier => $STRING,
    },

    ## Method : <get-ggsn-traces>
    ## Returns: <ggsn-user-trace-information>
    ## Command: "show services ggsn trace all"
    get_ggsn_traces => $NO_ARGS,

    ## Method : <get-ggsn-status-information>
    ## Returns: <ggsn-interface-status-information>
    ## Command: "show services ggsn status"
    get_ggsn_status_information => $NO_ARGS,

    ## Method : <get-ggsn-statistics-information>
    ## Returns: <ggsn-statistics-information>
    ## Command: "show services ggsn statistics"
    get_ggsn_statistics_information => $NO_ARGS,

    ## Method : <get-ggsn-gtp-statistics-information>
    ## Returns: <ggsn-gtp-statistics-information>
    ## Command: "show services ggsn statistics gtp"
    get_ggsn_gtp_statistics_information => $NO_ARGS,

    ## Method : <get-ggsn-imsi-statistics-information>
    ## Returns: <ggsn-imsi-statistics-information>
    ## Command: "show services ggsn statistics imsi"
    get_ggsn_imsi_statistics_information => {
	imsi_identifier => $STRING,
    },

    ## Method : <get-ggsn-apn-statistics-information>
    ## Returns: <ggsn-apn-statistics-information>
    ## Command: "show services ggsn statistics apn"
    get_ggsn_apn_statistics_information => {
	apn_name => $STRING,
    },

    ## Method : <get-ggsn-sgsn-statistics-information>
    ## Returns: <ggsn-sgsn-statistics-information>
    ## Command: "show services ggsn statistics sgsn"
    get_ggsn_sgsn_statistics_information => {
	address => $STRING,
    },

    ## Method : <get-helper-statistics-information>
    ## Returns: <helper-statistics-information>
    ## Command: "show helper statistics"
    get_helper_statistics_information => $NO_ARGS,

    ## Method : <request-reboot>
    ## Returns: nothing
    ## Command: "request system reboot"
    request_reboot => {
	at => $STRING,
	in => $STRING,
	message => $STRING,
	media => $STRING,
    },

    ## Method : <request-halt>
    ## Returns: nothing
    ## Command: "request system halt"
    request_halt => {
	at => $STRING,
	in => $STRING,
	message => $STRING,
	media => $STRING,
    },

    ## Method : <request-ggsn-stop-node>
    ## Returns: nothing
    ## Command: "request services ggsn stop node"
    request_ggsn_stop_node => $NO_ARGS,

    ## Method : <request-ggsn-stop-interface>
    ## Returns: nothing
    ## Command: "request services ggsn stop interface"
    request_ggsn_stop_interface => {
	interface_name => $STRING,
    },

    ## Method : <request-ggsn-restart-node>
    ## Returns: nothing
    ## Command: "request services ggsn restart node"
    request_ggsn_restart_node => $NO_ARGS,

    ## Method : <request-ggsn-restart-interface>
    ## Returns: nothing
    ## Command: "request services ggsn restart interface"
    request_ggsn_restart_interface => {
	interface_name => $STRING,
    },

    ## Method : <request-ggsn-terminate-context>
    ## Returns: nothing
    ## Command: "request services ggsn pdp terminate context"
    request_ggsn_terminate_context => {
	imsi => $STRING,
	nsapi => $STRING,
    },

    ## Method : <request-ggsn-terminate-apn-contexts>
    ## Returns: nothing
    ## Command: "request services ggsn pdp terminate apn"
    request_ggsn_terminate_apn_contexts => {
	apn_name => $STRING,
    },

    ## Method : <request-ggsn-start-imsi-trace>
    ## Returns: nothing
    ## Command: "request services ggsn trace start imsi"
    request_ggsn_start_imsi_trace => {
	imsi_identifier => $STRING,
    },

    ## Method : <request-ggsn-start-msisdn-trace>
    ## Returns: nothing
    ## Command: "request services ggsn trace start msisdn"
    request_ggsn_start_msisdn_trace => {
	msisdn_identifier => $STRING,
    },

    ## Method : <request-ggsn-stop-imsi-trace>
    ## Returns: nothing
    ## Command: "request services ggsn trace stop imsi"
    request_ggsn_stop_imsi_trace => {
	imsi_identifier => $STRING,
    },

    ## Method : <request-ggsn-stop-msisdn-trace>
    ## Returns: nothing
    ## Command: "request services ggsn trace stop msisdn"
    request_ggsn_stop_msisdn_trace => {
	msisdn_identifier => $STRING,
    },

    ## Method : <request-ggsn-stop-trace-activity>
    ## Returns: nothing
    ## Command: "request services ggsn trace stop all"
    request_ggsn_stop_trace_activity => $NO_ARGS,

);
