#
#
# COPYRIGHT AND LICENSE
# Copyright (c) 2001 Juniper Networks, Inc.  All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 	1.	Redistributions of source code must retain the above
# copyright notice, this list of conditions and the following
# disclaimer. 
# 	2.	Redistributions in binary form must reproduce the above
# copyright notice, this list of conditions and the following disclaimer
# in the documentation and/or other materials provided with the
# distribution. 
# 	3.	The name of the copyright owner may not be used to 
# endorse or promote products derived from this software without specific 
# prior written permission. 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# FILE: jroute_methods.pl -- generated automagikally; DO NOT EDIT
#

%jroute_methods = (
    ## Method : <request-end-session>
    ## Returns: <end-session>
    ## Command: "quit"
    request_end_session => $NO_ARGS,

    ## Method : <clear-ipv6-nd-information>
    ## Returns: <ipv6-modify-nd>
    ## Command: "clear ipv6 neighbors"
    clear_ipv6_nd_information => {
	host => $STRING,
    },

    ## Method : <get-route-information>
    ## Returns: <route-information>
    ## Command: "show route"
    get_route_information => {
	terse => $TOGGLE,
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	best => $TOGGLE,
	exact => $TOGGLE,
	range => $TOGGLE,
	table => $STRING,
	inactive => $TOGGLE,
	damping => $STRING,
	next_hop => $STRING,
	source_gateway => $STRING,
	protocol => $STRING,
	bgp => $TOGGLE,
	dvmrp => $TOGGLE,
	pim => $TOGGLE,
	ripng => $TOGGLE,
	rip => $TOGGLE,
	msdp => $TOGGLE,
	neighbor => $STRING,
	bgp => $TOGGLE,
	rip => $TOGGLE,
	ripng => $TOGGLE,
	dvmrp => $TOGGLE,
	pim => $TOGGLE,
	msdp => $TOGGLE,
	peer => $STRING,
	aspath_regex => $STRING,
	no_community => $TOGGLE,
	community_name => $STRING,
	label_switched_path => $STRING,
	destination => $STRING,
	hidden => $TOGGLE,
	all => $TOGGLE,
    },

    ## Method : <get-instance-summary-information>
    ## Returns: <instance-information>
    ## Command: "show route instance"
    get_instance_summary_information => $NO_ARGS,

    ## Method : <get-instance-information>
    ## Returns: <instance-information>
    ## Command: "show route instance detail"
    get_instance_information => {
	name => $STRING,
    },

    ## Method : <get-route-summary-information>
    ## Returns: <route-summary-information>
    ## Command: "show route summary"
    get_route_summary_information => $NO_ARGS,

    ## Method : <get-bgp-summary-information>
    ## Returns: <bgp-information>
    ## Command: "show bgp summary"
    get_bgp_summary_information => $NO_ARGS,

    ## Method : <get-bgp-group-information>
    ## Returns: <bgp-group-information>
    ## Command: "show bgp group"
    get_bgp_group_information => {
	group_name => $STRING,
    },

    ## Method : <get-bgp-neighbor-information>
    ## Returns: <bgp-information>
    ## Command: "show bgp neighbor"
    get_bgp_neighbor_information => {
	neighbor_address => $STRING,
    },

    ## Method : <get-ipv6-nd-information>
    ## Returns: <ipv6-nd-information>
    ## Command: "show ipv6 neighbors"
    get_ipv6_nd_information => $NO_ARGS,

    ## Method : <get-ipv6-ra-information>
    ## Returns: <ipv6-ra-information>
    ## Command: "show ipv6 router-advertisement"
    get_ipv6_ra_information => {
	interface => $STRING,
	conflicts => $TOGGLE,
	prefix => $STRING,
    },

    ## Method : <get-isis-adjacency-information>
    ## Returns: <isis-adjacency-information>
    ## Command: "show isis adjacency"
    get_isis_adjacency_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	instance => $STRING,
	system_id => $STRING,
    },

    ## Method : <get-isis-database-information>
    ## Returns: <isis-database-information>
    ## Command: "show isis database"
    get_isis_database_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	instance => $STRING,
	system_id => $STRING,
    },

    ## Method : <get-isis-hostname-information>
    ## Returns: <isis-hostname-information>
    ## Command: "show isis hostname"
    get_isis_hostname_information => $NO_ARGS,

    ## Method : <get-isis-interface-information>
    ## Returns: <isis-interface-information>
    ## Command: "show isis interface"
    get_isis_interface_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	instance => $STRING,
	interface_name => $STRING,
    },

    ## Method : <get-isis-route-information>
    ## Returns: <isis-route-information>
    ## Command: "show isis route"
    get_isis_route_information => {
	instance => $STRING,
    },

    ## Method : <get-isis-spf-information>
    ## Returns: <isis-spf-information>
    ## Command: "show isis spf"
    get_isis_spf_information => $NO_ARGS,

    ## Method : <get-isis-statistics-information>
    ## Returns: <isis-statistics-information>
    ## Command: "show isis statistics"
    get_isis_statistics_information => {
	instance => $STRING,
    },

    ## Method : <get-mpls-admin-group-information>
    ## Returns: <mpls-admin-group-information>
    ## Command: "show mpls admin-groups"
    get_mpls_admin_group_information => $NO_ARGS,

    ## Method : <get-mpls-cspf-information>
    ## Returns: <mpls-cspf-information>
    ## Command: "show mpls cspf"
    get_mpls_cspf_information => $NO_ARGS,

    ## Method : <get-mpls-path-information>
    ## Returns: <mpls-path-information>
    ## Command: "show mpls path"
    get_mpls_path_information => {
	path => $STRING,
    },

    ## Method : <get-mpls-interface-information>
    ## Returns: <mpls-interface-information>
    ## Command: "show mpls interface"
    get_mpls_interface_information => $NO_ARGS,

    ## Method : <get-mpls-lsp-information>
    ## Returns: <mpls-lsp-information>
    ## Command: "show mpls lsp"
    get_mpls_lsp_information => {
	ingress => $TOGGLE,
	egress => $TOGGLE,
	transit => $TOGGLE,
	terse => $TOGGLE,
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	up => $TOGGLE,
	down => $TOGGLE,
	statistics => $TOGGLE,
	name => $STRING,
    },

    ## Method : <get-rsvp-interface-information>
    ## Returns: <rsvp-interface-information>
    ## Command: "show rsvp interface"
    get_rsvp_interface_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-rsvp-neighbor-information>
    ## Returns: <rsvp-neighbor-information>
    ## Command: "show rsvp neighbor"
    get_rsvp_neighbor_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-rsvp-session-information>
    ## Returns: <rsvp-session-information>
    ## Command: "show rsvp session"
    get_rsvp_session_information => {
	ingress => $TOGGLE,
	egress => $TOGGLE,
	transit => $TOGGLE,
	lsp => $TOGGLE,
	nolsp => $TOGGLE,
	up => $TOGGLE,
	down => $TOGGLE,
	terse => $TOGGLE,
	brief => $TOGGLE,
	detail => $TOGGLE,
	name => $STRING,
	interface => $STRING,
    },

    ## Method : <get-rsvp-statistics-information>
    ## Returns: <rsvp-statistics-information>
    ## Command: "show rsvp statistics"
    get_rsvp_statistics_information => $NO_ARGS,

    ## Method : <get-rsvp-version-information>
    ## Returns: <rsvp-version-information>
    ## Command: "show rsvp version"
    get_rsvp_version_information => $NO_ARGS,

    ## Method : <get-ted-database-information>
    ## Returns: <ted-database-information>
    ## Command: "show ted database"
    get_ted_database_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	system_id => $STRING,
    },

    ## Method : <get-ted-link-information>
    ## Returns: <ted-link-information>
    ## Command: "show ted link"
    get_ted_link_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-ted-protocol-information>
    ## Returns: <ted-protocol-information>
    ## Command: "show ted protocol"
    get_ted_protocol_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
    },

    ## Method : <get-ospf-database-information>
    ## Returns: <ospf-database-information>
    ## Command: "show ospf database"
    get_ospf_database_information => {
	router => $TOGGLE,
	network => $TOGGLE,
	netsummary => $TOGGLE,
	asbrsummary => $TOGGLE,
	extern => $TOGGLE,
	nssa => $TOGGLE,
	link_local => $TOGGLE,
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	summary => $TOGGLE,
	area => $STRING,
	lsa_id => $STRING,
	advertising_router => $STRING,
	instance => $STRING,
    },

    ## Method : <get-ospf-interface-information>
    ## Returns: <ospf-interface-information>
    ## Command: "show ospf interface"
    get_ospf_interface_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	interface_name => $STRING,
	instance => $STRING,
    },

    ## Method : <get-ospf-neighbor-information>
    ## Returns: <ospf-neighbor-information>
    ## Command: "show ospf neighbor"
    get_ospf_neighbor_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
	neighbor => $STRING,
	instance => $STRING,
    },

    ## Method : <get-ospf-route-information>
    ## Returns: <ospf-route-information>
    ## Command: "show ospf route"
    get_ospf_route_information => {
	detail => $TOGGLE,
	intra => $TOGGLE,
	inter => $TOGGLE,
	abr => $TOGGLE,
	asbr => $TOGGLE,
	extern => $TOGGLE,
	instance => $STRING,
    },

    ## Method : <get-ospf-statistics-information>
    ## Returns: <ospf-statistics-information>
    ## Command: "show ospf statistics"
    get_ospf_statistics_information => {
	instance => $STRING,
    },

    ## Method : <get-ospf-io-statistics-information>
    ## Returns: <ospf-io-statistics-information>
    ## Command: "show ospf io-statistics"
    get_ospf_io_statistics_information => $NO_ARGS,

    ## Method : <get-ospf-log-information>
    ## Returns: <ospf-log-information>
    ## Command: "show ospf log"
    get_ospf_log_information => {
	instance => $STRING,
    },

    ## Method : <get-ldp-interface-information>
    ## Returns: <ldp-interface-information>
    ## Command: "show ldp interface"
    get_ldp_interface_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-neighbor-information>
    ## Returns: <ldp-neighbor-information>
    ## Command: "show ldp neighbor"
    get_ldp_neighbor_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-session-information>
    ## Returns: <ldp-session-information>
    ## Command: "show ldp session"
    get_ldp_session_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-route-information>
    ## Returns: <ldp-route-information>
    ## Command: "show ldp route"
    get_ldp_route_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-path-information>
    ## Returns: <ldp-path-information>
    ## Command: "show ldp path"
    get_ldp_path_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-database-information>
    ## Returns: <ldp-database-information>
    ## Command: "show ldp database"
    get_ldp_database_information => {
	brief => $TOGGLE,
	detail => $TOGGLE,
	extensive => $TOGGLE,
    },

    ## Method : <get-ldp-statistics-information>
    ## Returns: <ldp-statistics-information>
    ## Command: "show ldp statistics"
    get_ldp_statistics_information => $NO_ARGS,

    ## Method : <get-l2ckt-connection-information>
    ## Returns: <l2ckt-connection-information>
    ## Command: "show l2circuit connections"
    get_l2ckt_connection_information => {
	neighbor => $STRING,
	interface => $STRING,
	down => $TOGGLE,
	up => $TOGGLE,
	up_down => $TOGGLE,
	brief => $TOGGLE,
	extensive => $TOGGLE,
	history => $TOGGLE,
	status => $TOGGLE,
    },

    ## Method : <get-l2vpn-connection-information>
    ## Returns: <l2vpn-connection-information>
    ## Command: "show l2vpn connections"
    get_l2vpn_connection_information => {
	instance => $STRING,
	local_site => $STRING,
	remote_site => $STRING,
	down => $TOGGLE,
	up => $TOGGLE,
	up_down => $TOGGLE,
	brief => $TOGGLE,
	extensive => $TOGGLE,
	history => $TOGGLE,
	status => $TOGGLE,
    },

    ## Method : <request-package-add>
    ## Returns: nothing
    ## Command: "request system software add"
    request_package_add => {
	force => $TOGGLE,
	reboot => $TOGGLE,
	delay_restart => $TOGGLE,
	no_copy => $TOGGLE,
	validate => $TOGGLE,
	package_name => $STRING,
    },

    ## Method : <request-package-delete>
    ## Returns: nothing
    ## Command: "request system software delete"
    request_package_delete => {
	force => $TOGGLE,
	package_name => $STRING,
    },

    ## Method : <request-package-validate>
    ## Returns: nothing
    ## Command: "request system software validate"
    request_package_validate => {
	package_name => $STRING,
    },

);
