#
# $Id: Node.pm,v 1.3 2000/10/05 21:05:30 kmacleod Exp $
#

use strict;

package Class::Orchard::Node;
use vars qw{ $VERSION };

$VERSION = "0.03";

sub new {
    my $type = shift;

    my %self;
    my $underlying_data = {};

    tie %self, $type, $underlying_data;

    if (@_) {
	die "$type: node must have even number of arguments"
	    if (@_ % 2);

	for (my $ii = 0; $ii < $#_; $ii += 2) {
	    $self{$_[$ii]} = $_[$ii+1];
	}
    }

    return bless \%self, $type;
}

sub TIEHASH {
    my ($self, $underlying_data) = @_;

    return bless $underlying_data, $self;
}

sub FETCH {
    my ($underlying_data, $key) = @_;

    my ($uri, $localname) = _uri_localname_from_key($key);

    my $method = "GET_$localname";
    if (my $function = UNIVERSAL::can($underlying_data, $method)) {
	$function->($underlying_data);
    } else {
	my $index = _index_from_uri_localname($uri, $localname);
	return $underlying_data->{$index};
    }
}

sub STORE {
    my ($underlying_data, $key, $value) = @_;

    my ($uri, $localname) = _uri_localname_from_key($key);

    my $method = "SET_$localname";
    if (my $function = UNIVERSAL::can($underlying_data, $method)) {
	$function->($underlying_data, $value);
    } else {
	my $index = _index_from_uri_localname($uri, $localname);
	$underlying_data->{$index} = $value;
    }
}

sub FIRSTKEY {
    my $self = shift;

    my $a = keys %$self; # reset each()

    my ($key, $value) = each %$self;
    if (!defined $key) {
	return undef;
    }

    my ($namespace, $localname) = _uri_localname_from_index($key);
    if (!defined $namespace) {
	return $localname;
    } else {
	return [$namespace, $localname];
    }
}

sub NEXTKEY {
    my $self = shift;

    my ($key, $value) = each %$self;
    if (!defined $key) {
	return undef;
    }

    my ($namespace, $localname) = _uri_localname_from_index($key);
    if (!defined $namespace) {
	return $localname;
    } else {
	return [$namespace, $localname];
    }
}    

sub _index_from_uri_localname {
    my ($uri, $localname) = @_;

    if (!defined($uri)) {
	$uri = "";
    }

    return "{" . $uri . "}" . $localname;
}

sub _uri_localname_from_index {
    my $index = shift;

    $index =~ m/^\{([^\}]*)\}(.*)$/;
    my ($namespace, $localname) = ($1, $2);
    if ($namespace eq "") {
	$namespace = undef;
    }
    return ($namespace, $localname);
}

sub _uri_localname_from_key {
    my $key = shift;

    if (ref($key) eq 'ARRAY') {
	if ($#$key != 1) {
	    die "array index to node must be [URI, LocalName]\n";
	}

	return (@$key);
    } elsif (!ref($key)) {
	return (undef, $key);
    }

    die "index to node must be a two-item array or a string\n";
}

1;
