<?xml version="1.0"?>
<!DOCTYPE methoddef SYSTEM "rpc-method.dtd">
<!--
    Generated automatically by make_method v1.06, Wed May  1 00:23:35 2002

    Any changes made here will be lost.
-->
<methoddef>
<name>system.status</name>
<version>1.0</version>
<signature>struct</signature>
<help>
Report on the various status markers of the server itself. The return value is
a STRUCT with the following members:

        Key         Type     Value

        host        STRING   Name of the (possibly virtual) host name to which
                             requests are sent.
        port        INT      TCP/IP port the server is listening on.
        name        STRING   The name of the server software, as it identifies
                             itself in transport headers.
        version     STRING   The software version. Note that this is defined as
                             a STRING, not a DOUBLE, to allow for non-numeric
                             values.
        path        STRING   URL path portion, for use when sending POST
                             request messages.
        child_pid   INT      The process ID of the child serving this request.
        date        ISO8601  The current date and time on the server, as an
                             ISO 8601 date string.
        date_int    INT      The current date as a UNIX time() value. This is
                             encoded as an INT rather than the dateTime.int
                             type, so that it is readable by older clients.
        started     ISO8601  The date and time when the current server started
                             accepting connections, as an ISO 8601 string.
        started_int
                    INT      The server start-time as a UNIX time() value. This
                             is also encoded as INT for the same reasons as
                             the "date_int" value above.
        child_started
                    ISO8601  The date and time when this child process was
                             created by the master Apache/mod_perl process.
        child_started_int
                    INT      As above.
        total_requests
                    INT      Total number of requests served thus far
                             (including the current one). This will not include
                             requests for which there was no matching method,
                             or HTTP-HEAD requests.
        methods_known
                    INT      The number of different methods the server has
                             registered for serving requests.

This is a slightly different system.struct implementation instrumented for
use in an Apache/mod_perl environment.
</help>
<code language="perl">
###############################################################################
#
#   Sub Name:       status
#
#   Description:    Create a status-reporting struct and returns it.
#
#   Arguments:      NAME      IN/OUT  TYPE      DESCRIPTION
#                   $srv      in      ref       Server object instance
#
#   Globals:        None.
#
#   Environment:    None.
#
#   Returns:        hashref
#
###############################################################################
sub status
{
    use strict;

    my $srv = shift;

    my $status = {};
    my $time = time;
    my $URI;

    require URI;

    $status-&gt;{name} = ref($srv);
    $status-&gt;{version} = new RPC::XML::string $srv-&gt;version;
    $status-&gt;{host} = $srv-&gt;host || $srv-&gt;{host} || '';
    $status-&gt;{port} = $srv-&gt;port || $srv-&gt;{port} || '';
    $status-&gt;{path} = new RPC::XML::string $srv-&gt;path;
    $status-&gt;{child_pid} = $$;
    $status-&gt;{date} = RPC::XML::datetime_iso8601
        -&gt;new(RPC::XML::time2iso8601($time));
    $status-&gt;{started} = RPC::XML::datetime_iso8601
        -&gt;new(RPC::XML::time2iso8601($srv-&gt;started));
    $status-&gt;{child_started} = RPC::XML::datetime_iso8601
        -&gt;new(RPC::XML::time2iso8601($srv-&gt;child_started));
    $status-&gt;{date_int} = $time;
    $status-&gt;{started_int} = $srv-&gt;started;
    $status-&gt;{child_started_int} = $srv-&gt;child_started;
    $status-&gt;{total_requests} = $srv-&gt;requests + 1;

    $status;
}
</code>
</methoddef>
