<?xml version="1.0"?>
<!DOCTYPE methoddef SYSTEM "rpc-method.dtd">
<!--
    Generated automatically by make_method v1.06, Wed May  1 00:23:36 2002

    Any changes made here will be lost.
-->
<methoddef>
<name>system.methodHelp</name>
<version>1.0</version>
<signature>string string</signature>
<signature>array array</signature>
<help>
Return the help text (such as this) associated with the specified method(s).
If a STRING parameter specifying the method name is passed, the return value
will be a STRING. If multiple methods are queried by passing an ARRAY of
STRING values, then the return value will be an ARRAY of STRING values, as
well.
</help>
<code language="perl">
###############################################################################
#
#   Sub Name:       methodHelp
#
#   Description:    Retrieve any help text for the specified methods.
#
#   Arguments:      NAME      IN/OUT  TYPE      DESCRIPTION
#                   $srv      in      ref       Server object instance
#                   $arg      in      ref/sc    Listref or scalar specification
#
#   Globals:        None.
#
#   Environment:    None.
#
#   Returns:        Success:    string or listref
#                   Failure:    fault object
#
###############################################################################
sub methodHelp
{
    use strict;

    my $srv = shift;
    my $arg = shift;

    my $name = $srv-&gt;{method_name};
    my $scalar = (ref $arg) ? 0 : 1;
    my @list = ($scalar) ? ($arg) : @$arg;
    my @results = ();

    # Exclude any that are hidden from introspection APIs
    @list = grep(! $srv-&gt;{__method_table}-&gt;{$_}-&gt;{hidden}, @list);
    for (@list)
    {
        if ($srv-&gt;{__method_table}-&gt;{$_})
        {
            push(@results, $srv-&gt;{__method_table}-&gt;{$_}-&gt;{help} || '');
        }
        else
        {
            return RPC::XML::fault-&gt;new(302, "$name: Method $_ unknown");
        }
    }

    return ($scalar) ? $results[0] : \@results;
}
</code>
</methoddef>
