package Net::Paraget::Display;
#
# $Id: Display.pm,v 1.2 2001/04/27 03:30:18 lrclause Exp $
#

use strict;

use Class::MethodMaker
  get_set       => [ qw( context ) ],
  new_hash_init => [ qw( new hash_init ) ];


sub ascii_status_graphic
{
    my ( $self, $width ) = @_;
    
    my $interval_list = $self->context->interval_manager->interval_list();
    
    my $total_size = $interval_list->last->end();
    my $blocksize = $total_size / $width;
    
    my $graphic = ' ' x $width;
    
    foreach my $interval ( $interval_list->as_list() )
    {
#	next unless $interval->completed();
	
	my $mark_start = int( $interval->start() / $blocksize );
	substr $graphic, $mark_start, 1, '!';
	
	# this is just down here for clarity
	$mark_start++; # because we already put a mark on
	my $mark_end   = int( $interval->end() / $blocksize );
	$mark_end = $mark_start if $mark_end < $mark_start;
	my $marks      = $mark_end - $mark_start;
	
	if ( $interval->completed() ) 
	{
	    substr $graphic, $mark_start, $marks, ( '#' x $marks );
	}
	else
	{
	    substr $graphic, $mark_start, $marks, ( '.' x $marks );
	}
    }
    
    return $graphic;
}


1;
