package Net::Paraget::MirrorSetGatherer;
#
# $Id: MirrorSetGatherer.pm,v 1.2 2001/04/17 03:19:14 lrclause Exp $
#

use strict;
use English;
use IO::File;
use File::Spec;
use Carp;
use vars qw( $DEBUG );

use URI;

use Net::Paraget::Mirror;

use Class::MethodMaker
  list          => [ qw( set_dirs ) ],
  hash          => 'sets',
  new_hash_init => 'new';

sub gather
{
    my ( $self, $set_name ) = @_;
    
    my @mirrors;
    
    foreach my $set_dir ( $self->set_dirs() )
    {
	my $filename = File::Spec->catfile( $set_dir, $set_name );
	
	next unless -e $filename;
	
	push @mirrors, $self->get_mirrors_from_file( $set_name, $filename );
    }
    
    return @mirrors;
}



sub get_mirrors_from_file
{
    my ( $self, $set_name, $filename ) = @_;
    
    my $file = IO::File->new( $filename );
    
    unless ( $file )
    {
	carp "warn opening $filename: $ERRNO";
	return ();
    }
    
    my @mirrors;
    
    while ( my $line = $file->getline() )
    {
	# ignore comments
	$line =~ s/\#.*$//;

	# strip surrounding spaces
	$line =~ s/^\s+//;
	$line =~ s/\s+$//;
	
	next unless $line;
	
	my $mirror = Net::Paraget::Mirror->new( $line );
	$mirror->type( $set_name );
	
	push @mirrors, $mirror;
    }
    
    return @mirrors;
}

1;
