package Net::Paraget::ServerList;
#
# $Id: ServerList.pm,v 1.5 2001/05/10 04:33:48 lrclause Exp $
#

use strict;
use XML::Simple;
use Data::Dumper;

use Class::MethodMaker
  hash          => [ qw( servers serverdata ) ],
  new_hash_init => 'new';


sub read_in_servers
{
    my ($self, $filename) = @_;

    if (-e $filename)
    {
	$self->state( "Reading server statistics from $filename", 1);
	
	my $data = XMLin($filename);
	
	$self->serverdata(%{$data->{'server'}});
    }
    else
    {
	$self->serverdata( "server" => {} );
    }
    
    return;
}

sub write_out_servers
{
    my ($self, $filename) = @_;

    foreach my $server ( $self->servers_values() ) {
	my $data = $server->save_state();
	$self->serverdata( $server->as_string(), $data );
    }

    $self->state( "Writing server statistics to $filename", 1);

    my $text = XMLout( { server => scalar($self->serverdata()) } );
    my $file = IO::File->new( ">$filename" );
    if (not $file) 
    {
	warn( "Could not open $filename for writing server statistics." );
	return;
    }
    print $file $text;
    close($file);
}


sub count_servers
{
    my ( $self ) = @_;
    return scalar $self->servers_keys();
}


sub average_speed
{
    my ( $self ) = @_;
    return $self->get_average( 'speed' );
}


sub average_overhead
{
    my ( $self ) = @_;
    return $self->get_average( 'overhead' );
}


sub get_average
{
    my ( $self, $value ) = @_;

    my $n = $self->count_servers() or return undef;
    my $sum = 0;

    foreach my $s ( $self->servers_values() )
    {
       my $x = $s->$value();
       $sum += $x if defined $x;
    }

    my $average = int ( $sum / $n );
    return $average;
}      
                                  
sub get_a
{
    my ( $self, $value ) = @_;
    my $average_string = "average_$value";
    my $default_string = "default_$value";
    
    my $a = ( $self->$value()
	      || $self->list->$average_string()
	      || $self->list->$default_string()
	    );
    return $a;
}


sub a_speed
{
    my ( $self ) = @_;
    return $self->get_a( 'speed' );
}


sub an_overhead
{
    my ( $self ) = @_;
    return $self->get_a( 'overhead' );
}


sub default_speed
{
    return 10**3;
}


sub default_overhead
{
    return 3;
}

sub state
{
    my ( $self, $string, $priority ) = @_;
    main::state( "server list: " . $string, $priority );
}

1;
