package Net::Paraget::ServerQueue;
#
# $Id: ServerQueue.pm,v 1.1.1.1 2001/01/31 19:40:39 ftobin Exp $
#

use strict;

use Net::Paraget::Server;

use Class::MethodMaker
  hash          => [ qw( _servers ) ],
  new_hash_init => 'new';


sub servers
{
    my ( $self ) = @_;
    return $self->_servers_values();
}

sub count
{
    my ( $self ) = @_;
    return scalar $self->servers();
}

sub ranked_average_speed
{
    my ( $self ) = @_;
    return $self->get_average( 'speed' );
}


sub ranked_average_overhead
{
    my ( $self ) = @_;
    return $self->get_average( 'overhead' );
}


sub get_average
{
    my ( $self, $value ) = @_;
    
    my $n = $self->count() or return undef;
    my $sum = 0;
    
    foreach my $s ( $self->get_ranked() )
    {
	my $x = $s->$value();
	$sum += $x if defined $x;
    }
    
    my $average = int ( $sum / $n );
    return $average;
}

# Add a list of new servers to the queue
sub add
{
    my ( $self, @new_servers, ) = @_;
    
    my @new_ranked_servers;
    
    for my $s ( @new_servers )
    {
	$self->_servers($s->id(), $s);
    }
}


sub remove
{
    my ($self, $server) = @_;

    $self->_servers_delete(   $server->id() );
}


sub get_unranked
{
    my ( $self ) = @_;
    my @unranked_servers;
    foreach my $server ( $self->servers() )
    {
	if ($server->disable() or
	    not defined $server->speed() )
	{
	    push @unranked_servers, $server;
	}
    }
    return @unranked_servers;
}

sub get_ranked
{
    my ( $self ) = @_;
    my @ranked_servers;
    foreach my $server ( $self->servers() )
    {
	if (not ($server->disabled() or
		 not defined $server->speed() ))
	{
	    push @ranked_servers, $server;
	}
    }
    return @ranked_servers;
}


sub count_ranked
{
    my ( $self ) = @_;
    return scalar $self->get_ranked();
}


sub count_unranked
{
    my ( $self ) = @_;
    return scalar $self->get_unranked();
}


1;
