module REXML
	# If you add a method, keep in mind two things:
	# (1) the first argument will always be a list of nodes from which to
	# filter.  In the case of context methods (such as position), the function
	# should return an array with a value for each child in the array.
	# (2) all method calls from XML will have "-" replaced with "_".
	# Therefore, in XML, "local-name()" is identical (and actually becomes)
	# "local_name()"
	module Functions
		@@node = nil
		@@pair = []
		@@variable = {}
		@@namespace_context = {}

		def Functions::node=(value); @@node = value; end
		def Functions::pair=(value); @@pair = value; end
		def Functions::variable=(value); @@variable = value; end
		def Functions::namespace_context=(value)
			@@namespace_context = value
		end
		def Functions::node; @@node; end
		def Functions::pair; @@pair; end
		def Functions::variable; @@variable; end
		def Functions::namespace_context; @@namespace_context; end

		def Functions::text( )
			return true if @@node.kind_of? Text
		end

		def Functions::last( )
			@@pair[1]
		end

		def Functions::position( )
			@@pair[0]
		end

		def Functions::count( node_set )
			node_set.size
		end

		# Since REXML is non-validating, this method is not implemented as it
		# requires a DTD
		def Functions::id( object )
		end

		# NOT TESTED
		def Functions::local_name( node_set=nil )
			get_namespace( node_set ){|node|node.local_name}
		end

		# NOT TESTED
		def Functions::namespace_uri( node_set=nil )
			get_namespace( node_set ) {|node| node.namespace}
		end

		def Functions::name( node_set=nil )
			get_namespace( node_set ) { |node| node.name }
		end

		# Helper method.
		def Functions::get_namespace( node_set = nil )
			if node_set == nil
				yield @@node if @@node.kind_of? Namespace
			else	
				return "" unless node_set.kind_of? Enumerable
				node = node_set.find{|node| node.kind_of? Namespace}
				return "" unless node
				yield node
			end
		end

		# A node-set is converted to a string by returning the string-value of the
		# node in the node-set that is first in document order. If the node-set is
		# empty, an empty string is returned.
		#
		# A number is converted to a string as follows
		#
		# NaN is converted to the string NaN 
		#
		# positive zero is converted to the string 0 
		#
		# negative zero is converted to the string 0 
		#
		# positive infinity is converted to the string Infinity 
		#
		# negative infinity is converted to the string -Infinity 
		#
		# if the number is an integer, the number is represented in decimal form
		# as a Number with no decimal point and no leading zeros, preceded by a
		# minus sign (-) if the number is negative
		#
		# otherwise, the number is represented in decimal form as a Number
		# including a decimal point with at least one digit before the decimal
		# point and at least one digit after the decimal point, preceded by a
		# minus sign (-) if the number is negative; there must be no leading zeros
		# before the decimal point apart possibly from the one required digit
		# immediately before the decimal point; beyond the one required digit
		# after the decimal point there must be as many, but only as many, more
		# digits as are needed to uniquely distinguish the number from all other
		# IEEE 754 numeric values.
		#
		# The boolean false value is converted to the string false. The boolean
		# true value is converted to the string true.
		#
		# An object of a type other than the four basic types is converted to a
		# string in a way that is dependent on that type.
		def Functions::string( object=nil )
			object = context unless object
			if object.kind_of? Array
				string( object[0] )
			elsif object.kind_of? Text
				object.to_s
			elsif object.kind_of? Element
				object.name
			else
				object.to_s
			end
		end

		# UNTESTED
		def Functions::concat( *objects )
			objects.join
		end

		# UNTESTED
		def Functions::starts_with( string, test )
			string.index(test) == 0
		end

		# UNTESTED
		def Functions::contains( string, test )
			string.include? test
		end

		# UNTESTED
		def Functions::substring_before( string, test )
			string[ 0...string.index(test) ]
		end

		# UNTESTED
		def Functions::substring_after( string, test )
			string[ string.index(test)+1..-1 ]
		end

		# UNTESTED
		def Functions::substring( string, start, length=0 )
			length = string.size if length==0
			string[start-1,length]
		end

		# UNTESTED
		def Functions::string_length( string )
			string.size
		end

		# UNTESTED
		def Functions::normalize_space( string=nil )
			string = string(@@node) if string.nil?
			if string.kind_of? Array
				string.collect{|x| string.to_s.strip.gsub(/\s+/um, ' ') if string}
			else
				string.to_s.strip.gsub(/\s+/um, ' ')
			end
		end

		# UNTESTED
		def Functions::translate( string, tr1, tr2 )
			string.tr tr1,tr2
		end

		# UNTESTED
		def Functions::boolean( object=nil )
			if object.kind_of? String
				if object =~ /\d+/u
					return object.to_f != 0
				else
					return object.size > 0
				end
			elsif object.kind_of? Array
				object = object.find{|x| x and true}
			end
			return (object and true) & true		# if rv is nil, this turns it into false
		end

		# UNTESTED
		def Functions::not( object )
			not boolean( object )
		end

		# UNTESTED
		def Functions::true( )
			true
		end

		# UNTESTED
		def Functions::false(  )
			false
		end

		# UNTESTED
		def Functions::lang( language )
			@@node.collect do |node|
				if node.kind_of? Element
					lang = false
					until node.nil? or lang
						lang = compare_language node.attributes["xml:lang"], language
						node = node.parent
					end
				end
			end
		end

		def Functions::compare_language lang1, lang2
			lang2.downcase.index(lang1.downcase) == 0
		end

		# a string that consists of optional whitespace followed by an optional
		# minus sign followed by a Number followed by whitespace is converted to
		# the IEEE 754 number that is nearest (according to the IEEE 754
		# round-to-nearest rule) to the mathematical value represented by the
		# string; any other string is converted to NaN
		#
		# boolean true is converted to 1; boolean false is converted to 0
		#
		# a node-set is first converted to a string as if by a call to the string
		# function and then converted in the same way as a string argument
		#
		# an object of a type other than the four basic types is converted to a
		# number in a way that is dependent on that type
		def Functions::number( object=nil )
			object = @node unless object
			if object == true
				object = "1"
			elsif object == false
				object = "0"
			elsif object.kind_of? Array
				object = string( object )
			else
				object = object.to_s
			end
			object.to_f
		end

		def Functions::sum( nodes )
		end
		
		def Functions::floor( nodes, number )
			number = number.to_f if number.kind_of? String
			number.floor
		end

		def Functions::ceiling( nodes, number )
			number = number.to_f if number.kind_of? String
			number.ceil
		end

		def Functions::round( nodes, number )
			number = number.to_f if number.kind_of? String
			number.round
		end

		def Functions::method_missing( id )
			XPath.match( @@node, id.id2name )
		end
	end
end
