require 'net/http'
require 'rss'
include RSS
module RSS
	class Cache
			CacheEntry = Struct.new("CacheEntry", :channel, :url, :time)
		def initialize
			@hits = 0
			@cache = Hash.new
		end

		def get(host, path)
			if(@cache[host+path] != nil && @cache[host+path].time > (Time.now - 120)) then
				@hits += 1
				print "rsscache: Cache hit #{@hits} recorded on request for #{host}#{path}\n"
				return @cache[host+path].channel
			else
				print "New URL #{host}#{path} requested\n"
				http = Net::HTTP.new(host)
				resp, body = http.get(path)   
					
				@cache[host+path] = CacheEntry.new(RSS.from_xml(body), host+path, Time.now)
				return @cache[host+path].channel
			end
		end
	end

end

if __FILE__ == $0 then
	x = RSS::Cache.new
	print x.get("slashdot.org", "/slashdot.rdf")
end
